/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMStringHelper;

public class CMIntSet {
    private static int MINIMUM_SIZE = 8;
    private int count;
    private int[] integers;

    public CMIntSet(int initialCapacity) {
        initialCapacity = Math.max(MINIMUM_SIZE, initialCapacity);
        this.integers = new int[initialCapacity];
        this.count = 0;
    }

    public CMIntSet(CMIntSet source) {
        this.integers = new int[source.integers.length];
        System.arraycopy(source.integers, 0, this.integers, 0, source.count);
        this.count = source.count;
    }

    public CMIntSet(int[] s) {
        this(s.length);
        this.integers = s;
        this.count = s.length;
    }

    public static CMIntSet fromString(String s) {
        String[] strings = CMStringHelper.split(s, ':', true);
        CMIntSet intSet = new CMIntSet(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            intSet.integers[i] = Integer.parseInt(strings[i]);
        }
        intSet.count = strings.length;
        return intSet;
    }

    public void clear() {
        this.count = 0;
    }

    public int get(int index) {
        if (index < 0 || index >= this.integers.length) {
            return -1;
        }
        return this.integers[index];
    }

    public boolean add(int integer) {
        int i = this.indexOf(integer);
        if (i == -1) {
            this.checkCapacity();
            this.integers[this.count] = integer;
            ++this.count;
            return true;
        }
        return false;
    }

    public int getCount() {
        return this.count;
    }

    public boolean remove(int integer) {
        int i = this.indexOf(integer);
        if (i == -1) {
            return false;
        }
        for (int j = i; j < this.count - 1; ++j) {
            this.integers[j] = this.integers[j + 1];
        }
        --this.count;
        return true;
    }

    public boolean contains(int integer) {
        int i = this.indexOf(integer);
        return i != -1;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public String toString() {
        if (this.count == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toString(this.integers[0]));
        for (int i = 1; i < this.count; ++i) {
            sb.append(":");
            sb.append(Integer.toString(this.integers[i]));
        }
        return sb.toString();
    }

    private void checkCapacity() {
        if (this.count < this.integers.length - 1) {
            return;
        }
        int[] newIntegers = new int[2 * this.integers.length];
        System.arraycopy(this.integers, 0, newIntegers, 0, this.integers.length);
        this.integers = newIntegers;
    }

    private int indexOf(int integer) {
        for (int i = 0; i < this.count; ++i) {
            if (this.integers[i] != integer) continue;
            return i;
        }
        return -1;
    }
}

