/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import java.util.Vector;

public class CMList {
    protected Vector m_vector;
    protected int m_size;
    protected int m_first;
    protected int m_last;

    public CMList(int initialCapacity) {
        this.m_vector = new Vector(initialCapacity);
        this.m_vector.setSize(initialCapacity);
        this.m_size = 0;
        this.m_first = 0;
        this.m_last = 0;
    }

    public int size() {
        return this.m_size;
    }

    public Object firstElement() {
        return this.m_vector.elementAt(this.m_first);
    }

    public Object lastElement() {
        return this.m_vector.elementAt(this.m_last);
    }

    public Object elementAt(int index) {
        index = (this.m_first + index) % this.m_vector.size();
        return this.m_vector.elementAt(index);
    }

    public void pushLast(Object element) {
        this.checkCapacity();
        if (this.m_size == 0) {
            this.m_first = 0;
            this.m_last = 0;
        } else {
            this.m_last = (this.m_last + 1) % this.m_vector.size();
        }
        this.m_vector.setElementAt(element, this.m_last);
        ++this.m_size;
    }

    public void pushFirst(Object element) {
        this.checkCapacity();
        if (this.m_size == 0) {
            this.m_first = 0;
            this.m_last = 0;
        } else {
            this.m_first = (this.m_first - 1) % this.m_vector.size();
        }
        this.m_vector.setElementAt(element, this.m_first);
        ++this.m_size;
    }

    public Object popLast() {
        Object element;
        if (this.m_size == 0) {
            element = null;
        } else {
            element = this.m_vector.elementAt(this.m_last);
            this.m_last = (this.m_last - 1) % this.m_vector.size();
            --this.m_size;
        }
        return element;
    }

    public Object popFirst() {
        Object element;
        if (this.m_size == 0) {
            element = null;
        } else {
            element = this.m_vector.elementAt(this.m_first);
            this.m_first = (this.m_first + 1) % this.m_vector.size();
            --this.m_size;
        }
        return element;
    }

    private void checkCapacity() {
        if (this.m_size < this.m_vector.size()) {
            return;
        }
        Vector newVector = new Vector(this.m_size * 2);
        newVector.setSize(this.m_size * 2);
        for (int newIndex = 0; newIndex < this.m_size; ++newIndex) {
            int oldIndex = (this.m_first + newIndex) % this.m_size;
            Object element = this.m_vector.elementAt(oldIndex);
            newVector.setElementAt(element, newIndex);
        }
        this.m_vector = newVector;
        this.m_first = 0;
        this.m_last = this.m_size - 1;
    }
}

