/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CacheObject;
import com.cognos.mobile.common.ICMCache;
import com.cognos.mobile.common.MRUEnumeration;
import java.util.Enumeration;
import java.util.Hashtable;

public class CMMRUCache
implements ICMCache {
    Hashtable hashtable = new Hashtable();
    int cacheSize;
    CacheObject head;
    CacheObject tail;

    @Override
    public int size() {
        return this.hashtable.size();
    }

    @Override
    public int capacity() {
        return this.cacheSize;
    }

    public CMMRUCache(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("MRU cache must contain at least one entry");
        }
        this.cacheSize = size;
    }

    @Override
    public void put(Object key, Object value) {
        CacheObject entry = (CacheObject)this.hashtable.get(key);
        if (entry != null) {
            entry.setValue(value);
            this.touchEntry(entry);
        } else {
            if (this.hashtable.size() == this.cacheSize) {
                entry = this.purgeEntry();
                entry.setKey(key);
                entry.setValue(value);
            } else {
                entry = new CacheObject(key, value);
            }
            this.addEntry(entry);
            this.hashtable.put(entry.getKey(), entry);
        }
    }

    @Override
    public Object get(Object key) {
        CacheObject entry = (CacheObject)this.hashtable.get(key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void remove(Object key) {
        CacheObject entry = (CacheObject)this.hashtable.get(key);
        if (entry != null) {
            this.removeEntry(entry);
            this.hashtable.remove(entry.getKey());
        }
    }

    @Override
    public void cleanAll() {
        this.hashtable = new Hashtable();
        this.head = null;
        this.tail = null;
    }

    @Override
    public Enumeration elements() {
        return new MRUEnumeration(this.tail);
    }

    protected void addEntry(CacheObject entry) {
        if (this.head == null) {
            this.head = entry;
            this.tail = entry;
        } else {
            this.tail.setNext(entry);
            entry.setPrevious(this.tail);
            this.tail = entry;
        }
    }

    protected void removeEntry(CacheObject entry) {
        if (entry == this.head) {
            this.head = entry.getNext();
        }
        if (this.tail == entry) {
            this.tail = entry.getPrevious();
        }
        CacheObject previous = entry.getPrevious();
        CacheObject next = entry.getNext();
        if (previous != null) {
            previous.setNext(next);
        }
        if (next != null) {
            next.setPrevious(previous);
        }
        entry.setPrevious(null);
        entry.setNext(null);
    }

    protected void touchEntry(CacheObject entry) {
        if (this.tail == entry) {
            return;
        }
        this.removeEntry(entry);
        this.addEntry(entry);
    }

    protected CacheObject purgeEntry() {
        CacheObject entry = this.head;
        this.removeEntry(entry);
        this.hashtable.remove(entry.getKey());
        entry.setValue(null);
        return entry;
    }
}

