/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMAreaAndCentroid;
import com.cognos.mobile.common.CMPoint;
import com.cognos.mobile.common.CMVect;

public class CMMathHelper {
    public static double dotProduct(CMVect v0, CMVect v1) {
        return v0.x * v1.x + v0.y * v1.y;
    }

    public static boolean isPointInTriangle(CMPoint a, CMPoint b, CMPoint c, CMPoint p) {
        CMVect vac = new CMVect(c, a);
        CMVect vab = new CMVect(b, a);
        CMVect vap = new CMVect(p, a);
        double dpcac = CMMathHelper.dotProduct(vac, vac);
        double dpcab = CMMathHelper.dotProduct(vac, vab);
        double dpcap = CMMathHelper.dotProduct(vac, vap);
        double dpbab = CMMathHelper.dotProduct(vab, vab);
        double dpbap = CMMathHelper.dotProduct(vab, vap);
        double denom = 1.0 / (dpcac * dpbab - dpcab * dpcab);
        double ac = (dpbab * dpcap - dpcab * dpbap) * denom;
        double ab = (dpcac * dpbap - dpcab * dpcap) * denom;
        return ac > 0.0 && ab > 0.0 && ac + ab <= 1.0;
    }

    public static int multiplyIntByDouble(int i, double d) {
        i = (int)((double)i * d + 0.5);
        return i;
    }

    public static double linearInterpolate(double zero, double one, double fraction) {
        double rc = zero * (1.0 - fraction) + one * fraction;
        return rc;
    }

    public static double computeArea(int[] coords) {
        CMPoint p0 = new CMPoint();
        CMPoint p1 = new CMPoint();
        double area = 0.0;
        for (int i = 0; i < coords.length / 2; ++i) {
            CMMathHelper.extractCoords(coords, i, p0, p1);
            area += p0.x * p1.y - p1.x * p0.y;
        }
        return area *= 0.5;
    }

    public static CMAreaAndCentroid computeAreaAndCentroid(int[] coords) {
        CMPoint p0 = new CMPoint();
        CMPoint p1 = new CMPoint();
        double sumX = 0.0;
        double sumY = 0.0;
        double area = 0.0;
        CMAreaAndCentroid res = new CMAreaAndCentroid();
        if (coords.length == 2) {
            res.centroidX = coords[0];
            res.centroidY = coords[1];
            res.area = 1.0;
        } else if (coords.length == 4) {
            res.centroidX = (coords[0] + coords[2]) / 2;
            res.centroidY = (coords[1] + coords[3]) / 2;
            res.area = 1.0;
        } else {
            for (int i = 0; i < coords.length / 2; ++i) {
                CMMathHelper.extractCoords(coords, i, p0, p1);
                double common = p0.x * p1.y - p1.x * p0.y;
                sumX += (p0.x + p1.x) * common;
                sumY += (p0.y + p1.y) * common;
                area += common;
            }
            if (Math.abs(area *= 0.5) > 1.0E-4) {
                res.centroidX = 1.0 / (6.0 * area) * sumX;
                res.centroidY = 1.0 / (6.0 * area) * sumY;
            }
            res.area = area;
        }
        return res;
    }

    public static int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    public static double distance(CMPoint p0, CMPoint p1) {
        return Math.sqrt((p1.x - p0.x) * (p1.x - p0.x) + (p1.y - p0.y) * (p1.y - p0.y));
    }

    private static void extractCoords(int[] coords, int i, CMPoint p0, CMPoint p1) {
        p0.x = coords[2 * i];
        p0.y = coords[2 * i + 1];
        if (2 * i < coords.length - 3) {
            p1.x = coords[2 * i + 2];
            p1.y = coords[2 * i + 3];
        } else {
            p1.x = coords[0];
            p1.y = coords[1];
        }
    }
}

