/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMAreaAndCentroid;
import com.cognos.mobile.common.CMMathHelper;
import java.util.Arrays;
import java.util.Stack;
import java.util.Vector;

public class CMMathHelper2 {
    public static CMAreaAndCentroid computeAreaAndCentroid(int[] coords) {
        CMAreaAndCentroid res = CMMathHelper.computeAreaAndCentroid(coords);
        if (res.centroidX <= 0.0 || res.centroidY <= 0.0 || res.area == 0.0) {
            int[] fixedCoords = CMMathHelper2.fixCoords(coords);
            res = CMMathHelper.computeAreaAndCentroid(fixedCoords);
        }
        return res;
    }

    public static int[] fixCoords(int[] coords) {
        if (coords.length > 5) {
            Point[] points = CMMathHelper2.generatePoints(coords);
            CMMathHelper2.orderCoords(points);
            int idx = 0;
            int[] fixedCoords = new int[points.length * 2];
            for (int i = 0; i < points.length; ++i) {
                Point point = points[i];
                fixedCoords[idx++] = (int)point.x;
                fixedCoords[idx++] = (int)point.y;
            }
            return fixedCoords;
        }
        return coords;
    }

    private static Point[] generatePoints(int[] coords) {
        Vector<Object> pointsTrimmed = new Vector<Object>(1);
        int numPoints = coords.length / 2;
        Object[] points = new Point[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            points[i] = new Point(coords[i * 2], coords[i * 2 + 1]);
        }
        Arrays.sort(points);
        Object pPrev = points[0];
        double minX = ((Point)pPrev).x;
        double maxX = ((Point)pPrev).x;
        double minY = ((Point)pPrev).y;
        double maxY = ((Point)pPrev).y;
        pointsTrimmed.add(pPrev);
        for (int i = 1; i < points.length; ++i) {
            Object pThis = points[i];
            if (((Point)pThis).x == ((Point)pPrev).x && ((Point)pThis).y == ((Point)pPrev).y) continue;
            if (((Point)pThis).x != ((Point)pPrev).x) {
                if (((Point)pThis).x < minX) {
                    minX = ((Point)pThis).x;
                } else if (((Point)pThis).x > maxX) {
                    maxX = ((Point)pThis).x;
                }
            }
            if (((Point)pThis).y != ((Point)pPrev).y) {
                if (((Point)pThis).y < minY) {
                    minY = ((Point)pThis).y;
                } else if (((Point)pThis).y > maxY) {
                    maxY = ((Point)pThis).y;
                }
            }
            pointsTrimmed.add(pThis);
            pPrev = pThis;
        }
        if ((minX == maxX || minY == maxY) && pointsTrimmed.size() > 1) {
            Point p2;
            Point p1;
            if (minX == maxX) {
                p1 = new Point(minX, minY);
                p2 = new Point(minX, maxY);
            } else {
                p1 = new Point(minX, minY);
                p2 = new Point(maxX, minY);
            }
            return new Point[]{p1, p2};
        }
        return pointsTrimmed.toArray(new Point[pointsTrimmed.size()]);
    }

    private static void orderCoords(Point[] points) {
        Stack<Point> pointStack = new Stack<Point>();
        int numPoints = points.length;
        if (numPoints > 2) {
            Point tempPoint;
            int i;
            Point root = points[0];
            for (i = 2; i < numPoints; ++i) {
                for (int j = numPoints - 1; j >= i; --j) {
                    if (root.polarCompare(points[j - 1], points[j]) != 1) continue;
                    tempPoint = points[j - 1];
                    points[j - 1] = points[j];
                    points[j] = tempPoint;
                }
            }
            for (i = 1; i < points.length - 1 && points[i + 1].orientate(points[0], points[i]) == 3; ++i) {
            }
            pointStack.removeAllElements();
            pointStack.push(points[0]);
            pointStack.push(points[i]);
            ++i;
            while (i < numPoints) {
                boolean go = true;
                while (go) {
                    if (!pointStack.empty()) {
                        tempPoint = (Point)pointStack.pop();
                        if (pointStack.empty() || points[i].orientate((Point)pointStack.peek(), tempPoint) != 0) continue;
                        pointStack.push(tempPoint);
                        go = false;
                        continue;
                    }
                    go = false;
                }
                pointStack.push(points[i]);
                ++i;
            }
            int idx = 0;
            while (pointStack.size() > 0) {
                Point pp = (Point)pointStack.pop();
                points[idx++] = pp;
            }
        }
    }

    public static class Point
    implements Comparable {
        public double x;
        public double y;

        public Point() {
        }

        public Point(double nx, double ny) {
            this.x = nx;
            this.y = ny;
        }

        public double length() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }

        public int orientate(Point p0, Point p1) {
            Point vp = new Point(p1.x - p0.x, p1.y - p0.y);
            Point vo = new Point(this.x - p0.x, this.y - p0.y);
            double area = vp.x * vo.y - vo.x * vp.y;
            if (area > 0.0) {
                return 0;
            }
            if (area < 0.0) {
                return 1;
            }
            if (vp.x * vo.x < 0.0 || vp.y * vo.y < 0.0) {
                return 2;
            }
            if (vp.length() < vo.length()) {
                return 3;
            }
            if (p0.equals(this)) {
                return 4;
            }
            if (p1.equals(this)) {
                return 5;
            }
            return 6;
        }

        public int polarCompare(Point p0, Point p1) {
            double polar1;
            Point v0 = new Point(p0.x - this.x, p0.y - this.y);
            Point v1 = new Point(p1.x - this.x, p1.y - this.y);
            double polar0 = v0.polarAngle();
            if (polar0 < (polar1 = v1.polarAngle())) {
                return -1;
            }
            if (polar0 > polar1) {
                return 1;
            }
            if (v0.length() < v1.length()) {
                return -1;
            }
            if (v0.length() > v1.length()) {
                return 1;
            }
            return 0;
        }

        public double polarAngle() {
            if (this.x == 0.0 && this.y == 0.0) {
                return -1.0;
            }
            if (this.x == 0.0) {
                return this.y > 0.0 ? 90 : 270;
            }
            double angle = Math.atan(this.y / this.x);
            angle *= 57.29577951308232;
            if (this.x > 0.0) {
                return this.y >= 0.0 ? angle : 360.0 + angle;
            }
            return 180.0 + angle;
        }

        public int compareTo(Object other) {
            Point op = (Point)other;
            if (op.y == this.y && op.x == this.x) {
                return 0;
            }
            if (op.y < this.y || op.y == this.y && op.x < this.x) {
                return 1;
            }
            return -1;
        }
    }
}

