/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMException;

public class CMObjectStack {
    private Object[] m_items;
    private int m_top;

    public CMObjectStack(int maxDepth) {
        this.m_items = new Object[maxDepth];
        this.m_top = -1;
    }

    public Object peek() throws CMException {
        if (this.m_top == -1) {
            throw new CMException(1003, "stack empty");
        }
        return this.m_items[this.m_top];
    }

    public void push(Object item) throws CMException {
        if (this.m_top == this.m_items.length - 1) {
            throw new CMException(1003, "stack overflow");
        }
        this.m_items[++this.m_top] = item;
    }

    public Object pop() throws CMException {
        if (this.m_top == -1) {
            throw new CMException(1003, "stack empty");
        }
        return this.m_items[this.m_top--];
    }

    public boolean isEmpty() {
        return this.m_top == -1;
    }

    public int size() {
        return this.m_items.length - 1 - this.m_top;
    }

    public Object objectAt(int indexFromTop) {
        return this.m_items[indexFromTop];
    }
}

