/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMStringHelper;

public class CMPathHelper {
    public static char DIR_SEPARATOR = (char)47;

    public static String getParent(String path) {
        if (path.equals("/")) {
            return "/";
        }
        if (path.endsWith("/")) {
            String p = path.substring(0, path.lastIndexOf(47));
            if ((p = p.substring(0, p.lastIndexOf(47) + 1)).length() == 0) {
                return "/";
            }
            return p;
        }
        return path.substring(0, path.lastIndexOf(47) + 1);
    }

    public static boolean isDir(String path) {
        return (path = CMPathHelper.cleanPath(path)).length() > 0 && path.charAt(path.length() - 1) == DIR_SEPARATOR;
    }

    public static boolean isFile(String path) {
        return (path = CMPathHelper.cleanPath(path)).length() == 0 || path.charAt(path.length() - 1) != DIR_SEPARATOR;
    }

    public static String ensureDir(String path) {
        if ((path = CMPathHelper.cleanPath(path)).length() == 0 || path.charAt(path.length() - 1) != DIR_SEPARATOR) {
            path = path + DIR_SEPARATOR;
        }
        return path;
    }

    public static String ensureFile(String path) {
        if ((path = CMPathHelper.cleanPath(path)).length() > 0 && path.charAt(path.length() - 1) == DIR_SEPARATOR) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static SplitPathResult splitPath(String path) {
        return CMPathHelper.splitPath(path, true);
    }

    public static SplitPathResult splitSourcePath(String path) {
        return CMPathHelper.splitPath(path, false);
    }

    private static SplitPathResult splitPath(String path, boolean toCleanPath) {
        int index;
        SplitPathResult result = new SplitPathResult();
        if (toCleanPath) {
            path = CMPathHelper.cleanPath(path);
        }
        if ((index = CMStringHelper.lastIndexOf(path, DIR_SEPARATOR)) == -1) {
            result.dir = null;
            result.file = path;
        } else if (index == path.length() - 1) {
            result.dir = path;
            result.file = null;
        } else {
            result.dir = path.substring(0, index + 1);
            result.file = path.substring(index + 1);
        }
        return result;
    }

    public static SplitFileResult splitFile(String filename) {
        SplitFileResult result = new SplitFileResult();
        int index = CMStringHelper.lastIndexOf(filename = CMPathHelper.cleanPath(filename), '.');
        if (index == -1) {
            result.fname = filename;
            result.ext = "";
        } else {
            result.fname = filename.substring(0, index);
            result.ext = filename.substring(index);
        }
        return result;
    }

    public static String getPathExt(String pathName) {
        SplitPathResult sp = CMPathHelper.splitPath(pathName);
        SplitFileResult sf = CMPathHelper.splitFile(sp.file);
        return sf.ext;
    }

    public static String getPathFname(String pathName) {
        SplitPathResult sp = CMPathHelper.splitPath(pathName);
        SplitFileResult sf = CMPathHelper.splitFile(sp.file);
        return sf.fname;
    }

    public static String slashSafeAppend(String firstPart, String secondPart) {
        String appended = null;
        if (firstPart == null) {
            return secondPart;
        }
        if (secondPart == null) {
            return firstPart;
        }
        firstPart = CMPathHelper.ensureDir(firstPart);
        appended = secondPart.startsWith("/") ? firstPart + secondPart.substring(1) : firstPart + secondPart;
        return appended;
    }

    private static String cleanPath(String path) {
        if (path == null) {
            path = "";
        }
        path = path.replace('\\', DIR_SEPARATOR);
        path = path.trim();
        return path;
    }

    public static class SplitFileResult {
        public String fname;
        public String ext;
    }

    public static class SplitPathResult {
        public String dir;
        public String file;
    }
}

