/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMUrlHelper;
import java.util.Enumeration;
import java.util.Hashtable;

public class CMPropertiesCookie {
    private final Hashtable properties;
    private boolean dirty = false;
    private String cookie;

    public CMPropertiesCookie() {
        this.properties = new Hashtable();
        this.cookie = "";
    }

    public CMPropertiesCookie(String cookie) {
        this.properties = new Hashtable();
        if (cookie == null || cookie.length() == 0) {
            this.cookie = "";
        } else {
            if (cookie.startsWith("\"") && cookie.endsWith("\"")) {
                cookie = cookie.substring(1);
                cookie = cookie.substring(0, cookie.length() - 1);
            }
            this.cookie = cookie;
            int start = 0;
            while (start < cookie.length()) {
                String key;
                String entry;
                int eq;
                int end = cookie.indexOf(124, start);
                if (end == -1) {
                    end = cookie.length();
                }
                if (start < end && (eq = (entry = cookie.substring(start, end)).indexOf(61)) != -1 && (key = entry.substring(0, eq)) != null && key.length() > 0) {
                    try {
                        String value = CMUrlHelper.decodeUrl(entry.substring(eq + 1), '*');
                        this.properties.put(key, value);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                start = end + 1;
            }
        }
    }

    public CMPropertiesCookie(Hashtable properties) {
        this.properties = properties;
        this.cookie = null;
    }

    public String getProperty(String property) {
        return (String)this.properties.get(property);
    }

    public void setProperty(String property, String value) {
        if (CMStringHelper.compareStrings(value, (String)this.properties.get(property)) != 0) {
            this.properties.put(property, value);
            this.cookie = null;
            this.dirty = true;
        }
    }

    public String toString() {
        if (this.cookie == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("\"");
            String prefix = "";
            Enumeration e = this.properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)this.properties.get(key);
                sb.append(prefix);
                sb.append(key);
                sb.append('=');
                sb.append(CMUrlHelper.encodeUrl(value, '*'));
                prefix = "|";
            }
            sb.append("\"");
            this.cookie = sb.toString();
        }
        return this.cookie;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CMPropertiesCookie)) {
            return false;
        }
        CMPropertiesCookie rhs = (CMPropertiesCookie)o;
        if (this.properties.size() != rhs.properties.size()) {
            return false;
        }
        Enumeration e = this.properties.keys();
        while (e.hasMoreElements()) {
            String rhsValue;
            String key = (String)e.nextElement();
            String value = (String)this.properties.get(key);
            if (value.equals(rhsValue = (String)rhs.properties.get(key))) continue;
            return false;
        }
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void removeProperty(String prop) {
        this.properties.remove(prop);
        this.dirty = true;
    }
}

