/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.common.MobileException;

public class CMRuntimeException
extends RuntimeException
implements MobileException {
    private static final long serialVersionUID = 5888824832718785939L;
    private int m_errorCode;
    private String[] m_params;
    private Object arg;
    private Object attachedArg;

    public CMRuntimeException(int errorCode, Object arg) {
        this(errorCode, null, null, null);
        this.arg = arg;
    }

    public CMRuntimeException(int errorCode) {
        this(errorCode, null, null, null);
    }

    public CMRuntimeException(int errorCode, String[] params) {
        this(errorCode, params, null, null);
    }

    public CMRuntimeException(int errorCode, String details) {
        this(errorCode, null, details, null);
    }

    public CMRuntimeException(int errorCode, String[] params, String details) {
        this(errorCode, params, details, null);
    }

    public CMRuntimeException(int errorCode, Throwable ex) {
        this(errorCode, null, null, ex);
    }

    public CMRuntimeException(int errorCode, String[] params, Throwable ex) {
        this(errorCode, params, null, ex);
    }

    public CMRuntimeException(int errorCode, String details, Throwable t) {
        this(errorCode, null, details, t);
    }

    public CMRuntimeException(int errorCode, String[] params, String details, Throwable t) {
        super(CMException.buildMessage(errorCode, params, details), t);
        this.m_errorCode = errorCode;
        this.m_params = params;
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }

    @Override
    public String[] getErrorParams() {
        return this.m_params;
    }

    @Override
    public final Object getArgument() {
        return this.arg;
    }

    public final void setAttachedArgument(Object obj) {
        this.attachedArg = obj;
    }

    public final Object getAttachedArgument() {
        return this.attachedArg;
    }

    public String getLocalizedMessage(IResourceManager resourceManager) {
        String message = resourceManager.formatString(Integer.toString(this.m_errorCode), this.m_params);
        if (message == null || message.length() == 0) {
            message = resourceManager.formatString(CMIDs.UNKNOWN_ERROR_CODE, Integer.toString(this.m_errorCode));
        }
        return message;
    }
}

