/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMBase64;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.tagsoup.Util;
import com.cognos.mobile.vm.PlatformIndependentReader;
import com.cognos.mobile.vm.PlatformIndependentWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public final class CMStringHelper {
    public static final int S = 1000;
    public static final int M = 60000;
    public static final int H = 3600000;
    public static final int D = 86400000;

    public static int compareStrings(String str1, String str2) {
        int nullFlags = 0;
        if (str1 == null || str1.length() == 0) {
            nullFlags |= 1;
        }
        if (str2 == null || str2.length() == 0) {
            nullFlags |= 2;
        }
        switch (nullFlags) {
            case 3: {
                return 0;
            }
            case 1: {
                return -1;
            }
            case 2: {
                return 1;
            }
        }
        return str1.compareTo(str2);
    }

    public static int lastIndexOf(String str, char ch) {
        int index;
        int lastIndex = -1;
        if (str == null) {
            return -1;
        }
        while (-1 != (index = str.indexOf(ch, lastIndex + 1))) {
            lastIndex = index;
        }
        return lastIndex;
    }

    public static int lastIndexOf(String str, String token) {
        int index;
        if (str == null) {
            return -1;
        }
        int last = -1;
        while (-1 != (index = str.indexOf(token, last + 1))) {
            last = index;
        }
        return last;
    }

    public static String formatDateTime(Date dt) {
        if (dt == null) {
            return "";
        }
        String fmt = CMStringHelper.formatDate(dt) + " " + CMStringHelper.formatTime(dt);
        return fmt;
    }

    public static Hashtable parseDate(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        Hashtable<String, String> h = new Hashtable<String, String>(10);
        String dS = d.toString();
        h.put("a", cal.get(9) == 1 ? "pm" : "am");
        h.put("h", "" + cal.get(10));
        h.put("H", "" + cal.get(11));
        int start = 0;
        int end = dS.indexOf(32, start);
        String dow = dS.substring(start, end);
        h.put("E", dow);
        start = end + 1;
        end = dS.indexOf(32, start);
        String mon = dS.substring(start, end);
        h.put("M", mon);
        start = end + 1;
        end = dS.indexOf(32, start);
        String dd = dS.substring(start, end);
        h.put("d", dd);
        start = end + 1;
        end = dS.indexOf(58, start);
        dS.substring(start, end);
        start = end + 1;
        end = dS.indexOf(58, start);
        String mm = dS.substring(start, end);
        h.put("m", mm);
        start = end + 1;
        end = dS.indexOf(32, start);
        String ss = dS.substring(start, end);
        h.put("s", ss);
        int S = cal.get(14);
        if (S < 10) {
            h.put("S", "00" + S);
        } else if (S < 100) {
            h.put("S", "0" + S);
        } else {
            h.put("S", "" + S);
        }
        start = end + 1;
        end = dS.indexOf(32, start);
        String zzz = dS.substring(start, end);
        h.put("z", zzz);
        start = end + 1;
        end = dS.length();
        String yyyy = dS.substring(start, end);
        h.put("y", yyyy);
        return h;
    }

    public static String durationToString(long time) {
        int ms = (int)(time % 1000L);
        int s = (int)(time % 60000L / 1000L);
        int m = (int)(time % 3600000L / 60000L);
        int h = (int)(time % 86400000L / 3600000L);
        int d = (int)(time / 86400000L);
        StringBuffer sb = new StringBuffer(d + " ");
        if (h < 10) {
            sb.append("0");
        }
        sb.append(h + ":");
        if (m < 10) {
            sb.append("0");
        }
        sb.append(m + ":");
        if (s < 10) {
            sb.append("0");
        }
        sb.append(s + ".");
        if (ms < 10) {
            sb.append("00");
        } else if (ms < 100) {
            sb.append("0");
        }
        sb.append(ms);
        return sb.toString();
    }

    public static String durationToUseString(long time) {
        int ms = (int)(time % 1000L);
        int s = (int)(time % 60000L / 1000L);
        int m = (int)(time % 3600000L / 60000L);
        int h = (int)(time % 86400000L / 3600000L);
        int d = (int)(time / 86400000L);
        StringBuffer sb = new StringBuffer("P" + d + "DT");
        if (h < 10) {
            sb.append("0");
        }
        sb.append(h + "H");
        if (m < 10) {
            sb.append("0");
        }
        sb.append(m + "M");
        if (s < 10) {
            sb.append("0");
        }
        sb.append(s + ".");
        if (ms < 10) {
            sb.append("00");
        } else if (ms < 100) {
            sb.append("0");
        }
        sb.append(ms + "S");
        return sb.toString();
    }

    public static String format(Date d, String f) {
        StringBuffer result = new StringBuffer();
        Hashtable h = CMStringHelper.parseDate(d);
        char[] ff = f.toCharArray();
        char c = ' ';
        char delim = '\'';
        boolean indelim = false;
        for (int i = 0; i < ff.length; ++i) {
            int hour;
            if (indelim) {
                if (ff[i] != delim) {
                    result.append(ff[i]);
                    continue;
                }
                indelim = false;
                continue;
            }
            if (ff[i] == delim) {
                indelim = true;
                continue;
            }
            if (ff[i] == c) continue;
            if (ff[i] == 'h') {
                c = ff[i];
                if (i + 1 < ff.length && ff[i + 1] == 'h') {
                    hour = Integer.parseInt((String)h.get("" + c));
                    result.append(hour < 10 ? "0" + hour : "" + hour);
                    continue;
                }
                result.append(h.get("" + c));
                continue;
            }
            if (ff[i] == 'M') {
                c = ff[i];
                if (i + 2 >= ff.length || ff[i + 1] == 'M' && ff[i + 2] != 'M') {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(d);
                    int month = 1 + cal.get(2);
                    result.append(month < 10 ? "0" + month : "" + month);
                    while (i < ff.length && ff[i] == 'M') {
                        ++i;
                    }
                    --i;
                    continue;
                }
                result.append(h.get("" + c));
                continue;
            }
            c = ff[i];
            if (h.containsKey("" + c)) {
                if (ff[i] == 'H') {
                    if (i + 1 < ff.length && ff[i + 1] == 'H') {
                        hour = Integer.parseInt((String)h.get("" + c));
                        result.append(hour < 10 ? "0" + hour : "" + hour);
                        continue;
                    }
                    result.append(h.get("" + c));
                    continue;
                }
                result.append(h.get("" + c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String formateDateElapsed(Date date, String deviceFormattedDate, String deviceFormattedTime, boolean future, IResourceManager resourceManager) {
        if (date != null) {
            Date currentDate = new Date();
            long dateNum = date.getTime();
            long currentDateNum = currentDate.getTime();
            long diff = future ? dateNum - currentDateNum : currentDateNum - dateNum;
            long dayDiff = diff / 86400000L;
            if (dayDiff < 0L) {
                return deviceFormattedDate + " " + deviceFormattedTime;
            }
            if (dayDiff < 1L) {
                long hourDiff = diff / 3600000L;
                long minDiff = diff / 60000L;
                if (minDiff < 2L) {
                    if (future) {
                        return resourceManager.loadString(CMIDs.RINFO_IN_LESS_THAN_MINUTE);
                    }
                    return resourceManager.loadString(CMIDs.RINFO_LESS_THAN_MINUTE_AGO);
                }
                if (hourDiff < 1L) {
                    if (future) {
                        return resourceManager.formatString(CMIDs.RINFO_IN_X_MINUTES, String.valueOf(diff / 60000L));
                    }
                    return resourceManager.formatString(CMIDs.RINFO_X_MINUTES_AGO, String.valueOf(diff / 60000L));
                }
                if ((int)hourDiff == 1) {
                    if (future) {
                        return resourceManager.loadString(CMIDs.RINFO_IN_ONE_HOUR);
                    }
                    return resourceManager.loadString(CMIDs.RINFO_ONE_HOUR_AGO);
                }
                if (future) {
                    return resourceManager.formatString(CMIDs.RINFO_IN_X_HOURS, String.valueOf(hourDiff));
                }
                return resourceManager.formatString(CMIDs.RINFO_X_HOURS_AGO, String.valueOf(hourDiff));
            }
            if (dayDiff < 2L) {
                if (future) {
                    return resourceManager.formatString(CMIDs.RINFO_TOMORROW_AT, deviceFormattedTime);
                }
                return resourceManager.formatString(CMIDs.RINFO_YESTERDAY_AT, deviceFormattedTime);
            }
            if (dayDiff < 8L) {
                if (future) {
                    return resourceManager.formatString(CMIDs.RINFO_IN_X_DAYS, String.valueOf(dayDiff));
                }
                return resourceManager.formatString(CMIDs.RINFO_X_DAYS_AGO, String.valueOf(dayDiff));
            }
            return deviceFormattedDate;
        }
        return null;
    }

    public static String formatDate(Date dt) {
        char[] fmt = new char[10];
        if (dt == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int y = cal.get(1);
        int M = cal.get(2) + 1;
        int d = cal.get(5);
        CMStringHelper.formatZeroPadNumber(y, fmt, 0, 4);
        fmt[4] = 45;
        CMStringHelper.formatZeroPadNumber(M, fmt, 5, 2);
        fmt[7] = 45;
        CMStringHelper.formatZeroPadNumber(d, fmt, 8, 2);
        return new String(fmt);
    }

    public static String formatTime(Date dt) {
        char[] fmt = new char[8];
        if (dt == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int h = cal.get(11);
        int m = cal.get(12);
        int s = cal.get(13);
        CMStringHelper.formatZeroPadNumber(h, fmt, 0, 2);
        fmt[2] = 58;
        CMStringHelper.formatZeroPadNumber(m, fmt, 3, 2);
        fmt[5] = 58;
        CMStringHelper.formatZeroPadNumber(s, fmt, 6, 2);
        return new String(fmt);
    }

    public static Date parseDate(String date) {
        return CMStringHelper.parseDateTimeCommon(date, 1);
    }

    public static Date parseTime(String time) {
        return CMStringHelper.parseDateTimeCommon(time, 11);
    }

    public static Date parseDateTime(String dateTime) {
        return CMStringHelper.parseDateTimeCommon(dateTime, 1);
    }

    public static String formatPoint(int x, int y) {
        String str = "(" + Integer.toString(x) + "," + Integer.toString(y) + ")";
        return str;
    }

    public static String formatAddress(int address) {
        char[] buf = new char[5];
        buf[0] = 36;
        CMStringHelper.formatZeroPadHexNumber(address, buf, 1, 4);
        return new String(buf);
    }

    public static String formatColor(int color) {
        char[] buf = new char[10];
        buf[0] = 48;
        buf[1] = 120;
        buf[2] = 48;
        buf[3] = 48;
        CMStringHelper.formatZeroPadHexNumber(color, buf, 4, 6);
        return new String(buf);
    }

    public static String formatColorHtml(int color) {
        char[] buf = new char[7];
        buf[0] = 35;
        CMStringHelper.formatZeroPadHexNumber(color, buf, 1, 6);
        return new String(buf);
    }

    public static String formatHexLiteral(int intValue) {
        char[] buf = new char[10];
        buf[0] = 48;
        buf[1] = 120;
        CMStringHelper.formatZeroPadHexNumber(intValue, buf, 2, 8);
        return new String(buf);
    }

    public static String formatHexComponent(int intValue) {
        char[] buf = new char[2];
        CMStringHelper.formatZeroPadHexNumber(intValue, buf, 0, 2);
        return new String(buf);
    }

    public static String formatString(String fmt, String p1) {
        return CMStringHelper.formatString(fmt, new String[]{p1});
    }

    public static String formatString(String fmt, String[] params) {
        int i;
        if (fmt == null || params == null) {
            return fmt;
        }
        int length = fmt.length();
        for (i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            length += params[i].length();
        }
        StringBuffer sb = new StringBuffer(length);
        length = fmt.length();
        block7: for (i = 0; i < length; ++i) {
            char ch = fmt.charAt(i);
            switch (ch) {
                case '{': {
                    if (i == length - 1) continue block7;
                    ch = fmt.charAt(++i);
                    switch (ch) {
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int paramIndex = ch - 49;
                            if (paramIndex < 0 || paramIndex >= params.length || params[paramIndex] == null) break;
                            sb.append(params[paramIndex]);
                            break;
                        }
                        default: {
                            sb.append('%');
                            sb.append(ch);
                        }
                    }
                    if (i == length - 1 || fmt.charAt(i + 1) != '}') continue block7;
                    ++i;
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String cleanIntegerForParse(String str, int base) {
        String validDigits;
        switch (base) {
            case 2: {
                validDigits = "bB01";
                break;
            }
            case 8: {
                validDigits = "01234567";
                break;
            }
            default: {
                validDigits = "0123456789";
                break;
            }
            case 16: {
                validDigits = "xX0123456789ABCDEFabcdef";
            }
        }
        int len = str == null ? 0 : str.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            boolean isValid;
            char ch = str.charAt(i);
            boolean bl = isValid = validDigits.indexOf(ch) >= 0;
            if (isValid) {
                sb.append(ch);
                continue;
            }
            if (sb.length() != 0) break;
        }
        return sb.toString();
    }

    public static boolean parseBoolean(String booleanString) {
        if (booleanString == null || booleanString.length() < 1) {
            throw new IllegalArgumentException();
        }
        return booleanString.equalsIgnoreCase("true");
    }

    public static int parseInteger(String str, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            value = defaultValue;
        }
        return value;
    }

    public static int parseIntegerLiteral(String str) throws NumberFormatException {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int decPt = str.indexOf(46);
        if (decPt > 0) {
            str = str.substring(0, decPt);
        }
        if (str.charAt(0) == '0' && str.length() > 1) {
            switch (str.charAt(1)) {
                case 'X': 
                case 'x': {
                    return CMStringHelper.parseIntegerHelper(str.substring(2), 16);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    return CMStringHelper.parseIntegerHelper(str, 8);
                }
                case 'B': 
                case 'b': {
                    return CMStringHelper.parseIntegerHelper(str.substring(2), 2);
                }
            }
            throw new NumberFormatException("invalid number: " + str);
        }
        return Integer.parseInt(str);
    }

    public static int parseIntegerLiteral(String str, int defaultValue) {
        int value;
        try {
            value = CMStringHelper.parseIntegerLiteral(str);
        }
        catch (NumberFormatException ex) {
            value = defaultValue;
        }
        return value;
    }

    public static String quoteStringLiteral(String str) {
        int length = null == str ? 0 : str.length();
        StringBuffer buf = new StringBuffer(length + 3);
        buf.append('\"');
        block3: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    buf.append('\\');
                    buf.append(ch);
                    continue block3;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String[] parseLines(String message) {
        return CMStringHelper.split(message, '\n', true);
    }

    public static String[] parseWords(String line) {
        return CMStringHelper.split(line, ' ', false);
    }

    public static String[] split(String string, char delimiter, boolean trim) {
        Vector<String> tokens = new Vector<String>();
        if (string != null) {
            String token;
            int begin = 0;
            int end = string.indexOf(delimiter, begin);
            while (end != -1) {
                token = string.substring(begin, end);
                if (trim) {
                    token = token.trim();
                }
                if (token != null) {
                    tokens.addElement(token);
                }
                begin = end + 1;
                end = string.indexOf(delimiter, begin);
            }
            if (begin < string.length()) {
                token = string.substring(begin);
                if (trim) {
                    token = token.trim();
                }
                tokens.addElement(token);
            }
        }
        int count = tokens.size();
        String[] rc = new String[count];
        for (int i = 0; i < count; ++i) {
            rc[i] = (String)tokens.elementAt(i);
        }
        return rc;
    }

    public static String[] split(String string, String[] delimiters, boolean trim, boolean outputDelimiter) {
        StringBuffer foundDelimiter = new StringBuffer();
        Vector<String> tokens = new Vector<String>();
        if (string != null) {
            String token;
            int begin = 0;
            int end = CMStringHelper.indexOfFirstDelimiter(string, delimiters, begin, foundDelimiter);
            while (end != -1) {
                if (end > begin) {
                    token = string.substring(begin, end);
                    if (trim) {
                        token = token.trim();
                    }
                    if (token != null && token.length() > 0) {
                        tokens.addElement(token);
                    }
                }
                if (outputDelimiter) {
                    tokens.addElement(string.substring(end, end + foundDelimiter.length()));
                }
                if (outputDelimiter) {
                    begin = end + foundDelimiter.length();
                }
                end = CMStringHelper.indexOfFirstDelimiter(string, delimiters, begin, foundDelimiter);
            }
            if (begin < string.length()) {
                token = string.substring(begin);
                if (trim) {
                    token = token.trim();
                }
                tokens.addElement(token);
            }
        }
        int count = tokens.size();
        String[] rc = new String[count];
        for (int i = 0; i < count; ++i) {
            rc[i] = (String)tokens.elementAt(i);
        }
        return rc;
    }

    public static int indexOfFirstDelimiter(String string, String[] delimiters, int begin, StringBuffer firstDelimiter) {
        int firstDelimiterIndexOf = -1;
        for (int i = 0; i < delimiters.length; ++i) {
            int currentDelimiterIndexOf = string.indexOf(delimiters[i], begin);
            if (currentDelimiterIndexOf >= 0 && firstDelimiterIndexOf >= 0) {
                if (currentDelimiterIndexOf >= firstDelimiterIndexOf) continue;
                firstDelimiterIndexOf = currentDelimiterIndexOf;
                firstDelimiter.setLength(0);
                firstDelimiter.append(delimiters[i]);
                continue;
            }
            if (currentDelimiterIndexOf < 0) continue;
            firstDelimiterIndexOf = currentDelimiterIndexOf;
            firstDelimiter.setLength(0);
            firstDelimiter.append(delimiters[i]);
        }
        return firstDelimiterIndexOf;
    }

    public static String formatBytes(int bytes, String[] byteFormats, char decimal) {
        double ONE_KB = 1024.0;
        double ONE_MB = 1048576.0;
        double ONE_GB = 1.073741824E9;
        double ONE_TB = 1.099511627776E12;
        double ONE_PB = 1.125899906842624E15;
        double ONE_EB = 1.152921504606847E18;
        double ONE_ZB = 1.1805916207174113E21;
        double ONE_YB = 1.2089258196146292E24;
        if ((double)bytes <= 999.0) {
            return CMStringHelper.formatString(byteFormats[0], Integer.toString(bytes));
        }
        if ((double)bytes <= 1022976.0) {
            return CMStringHelper.formatString(byteFormats[1], CMStringHelper.threeNonDigits(decimal, (double)bytes / 1024.0));
        }
        if ((double)bytes <= 1.047527424E9) {
            return CMStringHelper.formatString(byteFormats[2], CMStringHelper.threeNonDigits(decimal, (double)bytes / 1048576.0));
        }
        if ((double)bytes <= 1.072668082176E12) {
            return CMStringHelper.formatString(byteFormats[3], CMStringHelper.threeNonDigits(decimal, (double)bytes / 1.073741824E9));
        }
        if ((double)bytes <= 1.098412116148224E15) {
            return CMStringHelper.formatString(byteFormats[4], CMStringHelper.threeNonDigits(decimal, (double)bytes / 1.099511627776E12));
        }
        if ((double)bytes <= (double)1.124774E18f) {
            return CMStringHelper.formatString(byteFormats[5], CMStringHelper.threeNonDigits(decimal, (double)bytes / 1.125899906842624E15));
        }
        if ((double)bytes <= 1.1517685831022401E21) {
            return CMStringHelper.formatString(byteFormats[6], CMStringHelper.threeNonDigits(decimal, (double)bytes / 1.152921504606847E18));
        }
        if ((double)bytes <= (double)1.179411E24f) {
            return CMStringHelper.formatString(byteFormats[7], CMStringHelper.threeNonDigits(decimal, (double)bytes / 1.1805916207174113E21));
        }
        return CMStringHelper.formatString(byteFormats[8], CMStringHelper.threeNonDigits(decimal, (double)bytes / 1.2089258196146292E24));
    }

    public static void formatZeroPadNumber(int number, char[] buf, int start, int len) {
        for (int pos = start + len - 1; pos >= start; --pos) {
            buf[pos] = (char)(48 + number % 10);
            number /= 10;
        }
    }

    public static void formatZeroPadHexNumber(int number, char[] buf, int start, int len) {
        for (int pos = start + len - 1; pos >= start; --pos) {
            int digit = number % 16;
            buf[pos] = digit < 10 ? (char)(48 + digit) : (char)(65 + digit - 10);
            number /= 16;
        }
    }

    private static String threeNonDigits(char decimal, double number) {
        int whole;
        if (number >= 100.0) {
            number = Math.floor(number + 0.5);
            return Integer.toString((int)number);
        }
        if (number >= 10.0) {
            number = Math.floor(number * 10.0 + 0.5) / 10.0;
            int whole2 = (int)number;
            int fraction = (int)((number - (double)whole2) * 10.0);
            return Integer.toString(whole2) + decimal + Integer.toString(fraction);
        }
        int fraction = (int)(((number = Math.floor(number * 100.0 + 0.5) / 100.0) - (double)(whole = (int)number)) * 100.0 + 0.5);
        if (fraction < 10) {
            return Integer.toString(whole) + decimal + Integer.toString(fraction) + "0";
        }
        return Integer.toString(whole) + decimal + Integer.toString(fraction);
    }

    private static int parseIntegerHelper(String str, int base) {
        int value = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int digit = 0;
            value *= base;
            switch (str.charAt(i)) {
                case '0': {
                    digit = 0;
                    break;
                }
                case '1': {
                    digit = 1;
                    break;
                }
                case '2': {
                    digit = 2;
                    break;
                }
                case '3': {
                    digit = 3;
                    break;
                }
                case '4': {
                    digit = 4;
                    break;
                }
                case '5': {
                    digit = 5;
                    break;
                }
                case '6': {
                    digit = 6;
                    break;
                }
                case '7': {
                    digit = 7;
                    break;
                }
                case '8': {
                    digit = 8;
                    break;
                }
                case '9': {
                    digit = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    digit = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    digit = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    digit = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    digit = 13;
                }
                case 'E': 
                case 'e': {
                    digit = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    digit = 15;
                    break;
                }
                default: {
                    throw new NumberFormatException("illegal digit: " + str.charAt(i));
                }
            }
            if (digit >= base) {
                throw new NumberFormatException("illegal base " + base + " digit: " + str.charAt(i));
            }
            value += digit;
        }
        return value;
    }

    private static Date parseDateTimeCommon(String date, int startDatePart) {
        int numberSoFar = 0;
        int datePart = startDatePart;
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(0L));
        c.set(11, 0);
        date = date.trim();
        int len = date.length();
        for (int i = 0; i < len; ++i) {
            char ch = date.charAt(i);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    numberSoFar *= 10;
                    numberSoFar += ch - 48;
                    break;
                }
                case ' ': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case 'T': {
                    datePart = CMStringHelper.setDatePart(c, datePart, numberSoFar);
                    if (datePart == 14) {
                        if (i + 1 >= len) break;
                        String remainder = date.substring(i + 1).trim();
                        int rl = remainder.length();
                        if (rl > 0) {
                            String ms;
                            int end = 3;
                            if (rl < 3) {
                                end = rl;
                            }
                            if ((ms = remainder.substring(0, end)).length() == 2) {
                                ms = ms + "0";
                            } else if (ms.length() == 1) {
                                ms = ms + "00";
                            }
                            c.set(14, Integer.parseInt(ms));
                        }
                        i = len;
                        numberSoFar = 0;
                        break;
                    }
                    numberSoFar = 0;
                }
            }
            if (numberSoFar == 0) continue;
            CMStringHelper.setDatePart(c, datePart, numberSoFar);
        }
        return c.getTime();
    }

    private static int setDatePart(Calendar c, int datePart, int numberSoFar) {
        switch (datePart) {
            case 1: {
                c.set(1, numberSoFar);
                datePart = 2;
                break;
            }
            case 2: {
                c.set(2, numberSoFar - 1);
                datePart = 5;
                break;
            }
            case 5: {
                c.set(5, numberSoFar);
                datePart = 11;
                break;
            }
            case 11: {
                c.set(11, numberSoFar);
                datePart = 12;
                break;
            }
            case 12: {
                c.set(12, numberSoFar);
                datePart = 13;
                break;
            }
            case 13: {
                c.set(13, numberSoFar);
                datePart = 14;
                break;
            }
            case 14: {
                c.set(14, numberSoFar);
                datePart = -1;
            }
        }
        return datePart;
    }

    public static String abbreviate(int titleSize, String current) {
        if (current.length() > titleSize && current.length() > 3) {
            int start = current.length() - (titleSize - 3);
            return "... " + current.substring(start, start + (titleSize - 3));
        }
        return current;
    }

    public static String join(Object[] components, String separator, boolean removeNullComponents) {
        StringBuffer sb = new StringBuffer();
        String sep = "";
        for (int i = 0; i < components.length; ++i) {
            if (!removeNullComponents || removeNullComponents && components[i] != null) {
                sb.append(sep);
                sb.append(components[i]);
            }
            sep = separator;
        }
        return sb.toString();
    }

    public static String join(String[] list, String separator) {
        return CMStringHelper.join((Object[])list, separator, false);
    }

    public static String join(String[] list, String separator, boolean removeNullComponents) {
        return CMStringHelper.join((Object[])list, separator, removeNullComponents);
    }

    public static String trimRight(int maxSize, String current) {
        String ellipsis = "...";
        if (current != null && current.length() > maxSize && maxSize > ellipsis.length()) {
            return current.substring(0, maxSize - ellipsis.length() - 1) + ellipsis;
        }
        return current;
    }

    public static String replaceAll(String s, String wha, String with, boolean caseSensitive) {
        return CMStringHelper.replaceAll(s, new String[]{wha}, new String[]{with}, caseSensitive);
    }

    public static String replaceAll(String s, String[] wha, String[] with, boolean caseSensitive) {
        int firstEnd;
        if (wha == null || wha.length == 0 || wha.length == 1 && (wha[0] == null || wha[0] == "") || with == null || with.length == 0 || s == null) {
            return s;
        }
        int start = 0;
        int end = 0;
        StringBuffer result = new StringBuffer();
        int loopSize = wha.length <= with.length ? wha.length : with.length;
        String source = caseSensitive ? s : s.toUpperCase();
        do {
            String firstWhat = "";
            String firstWith = "";
            firstEnd = -1;
            int thisEnd = end;
            for (int i = 0; i < loopSize; ++i) {
                String what;
                if (wha[i] == null || wha[i].equals("") || (thisEnd = source.indexOf(what = caseSensitive ? wha[i] : wha[i].toUpperCase(), start)) < 0 || firstWith != "" && (firstWith == "" || thisEnd >= firstEnd)) continue;
                firstWhat = what;
                firstWith = with[i];
                firstEnd = thisEnd;
            }
            if (firstEnd < 0) continue;
            end = firstEnd;
            result.append(s.substring(start, firstEnd));
            result.append(firstWith);
            start = firstEnd + firstWhat.length();
        } while (firstEnd >= 0);
        result.append(s.substring(start));
        return result.toString();
    }

    public static String encode(Vector v) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PlatformIndependentWriter daos = new PlatformIndependentWriter(baos);
        daos.write(v.size());
        for (int i = 0; i < v.size(); ++i) {
            byte[] b = ((String)v.elementAt(i)).getBytes("UTF-8");
            daos.write(b.length);
            daos.write(b);
        }
        baos.close();
        return CMUrlHelper.encodeUrl(CMBase64.encodeBytes(baos.toByteArray()));
    }

    public static String encode(String[] s) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PlatformIndependentWriter daos = new PlatformIndependentWriter(baos);
        daos.write(s.length);
        for (int i = 0; i < s.length; ++i) {
            byte[] b = s[i].getBytes("UTF-8");
            daos.write(b.length);
            daos.write(b);
        }
        baos.close();
        return CMUrlHelper.encodeUrl(CMBase64.encodeBytes(baos.toByteArray()));
    }

    public static String[] decode(String s) throws IOException {
        byte[] b = CMBase64.decode(CMUrlHelper.decodeUrl(s));
        PlatformIndependentReader din = new PlatformIndependentReader(new ByteArrayInputStream(b));
        int i = din.readInt();
        String[] result = new String[i];
        for (int j = 0; j < i; ++j) {
            int size = din.readInt();
            byte[] data = new byte[size];
            din.readBytes(data, 0, size);
            result[j] = new String(data, "UTF-8");
        }
        return result;
    }

    public static String extractErrorCode(String content) {
        int l = content.length();
        for (int i = 0; i < l - 9; ++i) {
            int j;
            if (!Util.isUpper(content.charAt(i)) || !Util.isUpper(content.charAt(i + 1)) || !Util.isUpper(content.charAt(i + 2)) || content.charAt(i + 3) != '-' || !Util.isUpper(content.charAt(i + 4)) || !Util.isUpper(content.charAt(i + 5)) || !Util.isUpper(content.charAt(i + 6)) || content.charAt(i + 7) != '-' || !Util.isDigit(content.charAt(i + 8))) continue;
            for (j = i + 9; j < l && Util.isDigit(content.charAt(j)); ++j) {
            }
            return content.substring(i, j);
        }
        return null;
    }

    public static String obfuscatePassword(String content) {
        if (content == null || content.length() == 0) {
            return content;
        }
        String passwordLiteral = "password=";
        String obfuscatedPasswordLiteral = "pazzword=";
        char obfuscationCharacter = '*';
        int passwordLocation = content.indexOf(passwordLiteral);
        if (passwordLocation != -1) {
            int numRemainingCharacters = Math.max(0, content.length() - passwordLocation - passwordLiteral.length());
            content = CMStringHelper.replaceAll(content, passwordLiteral, obfuscatedPasswordLiteral, true);
            content = content.substring(0, passwordLocation + passwordLiteral.length());
            for (int i = 0; i < numRemainingCharacters; ++i) {
                content = content + obfuscationCharacter;
            }
        }
        return content;
    }
}

