/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.VM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;

public class CMStringHelper2 {
    private static Class<CMStringHelper2> CLASS = CMStringHelper2.class;

    public static String formatDateTime(Date date) {
        Calendar dt = Calendar.getInstance();
        dt.setTime(date);
        if (dt == null) {
            return "";
        }
        return CMStringHelper2.formatDate(dt) + " " + CMStringHelper2.formatTime(dt);
    }

    public static String formatDateTimeWithMiliSeconds(Date date) {
        Calendar dt = Calendar.getInstance();
        dt.setTime(date);
        if (dt == null) {
            return "";
        }
        return CMStringHelper2.formatDate(dt) + " " + CMStringHelper2.formatTimeWithMiliSeconds(dt);
    }

    public static String formatDateTime(Calendar dt) {
        if (dt == null) {
            return "";
        }
        String fmt = CMStringHelper2.formatDate(dt) + " " + CMStringHelper2.formatTime(dt);
        return fmt;
    }

    public static String formatDate(Calendar dt) {
        char[] fmt = new char[10];
        if (dt == null) {
            return "";
        }
        int y = dt.get(1);
        int M = dt.get(2) + 1;
        int d = dt.get(5);
        CMStringHelper.formatZeroPadNumber(y, fmt, 0, 4);
        fmt[4] = 45;
        CMStringHelper.formatZeroPadNumber(M, fmt, 5, 2);
        fmt[7] = 45;
        CMStringHelper.formatZeroPadNumber(d, fmt, 8, 2);
        return new String(fmt);
    }

    public static String formatTime(Calendar dt) {
        char[] fmt = new char[8];
        if (dt == null) {
            return "";
        }
        int h = dt.get(11);
        int m = dt.get(12);
        int s = dt.get(13);
        CMStringHelper.formatZeroPadNumber(h, fmt, 0, 2);
        fmt[2] = 58;
        CMStringHelper.formatZeroPadNumber(m, fmt, 3, 2);
        fmt[5] = 58;
        CMStringHelper.formatZeroPadNumber(s, fmt, 6, 2);
        return new String(fmt);
    }

    public static String formatTimeWithMiliSeconds(Calendar dt) {
        char[] fmt = new char[12];
        if (dt == null) {
            return "";
        }
        int h = dt.get(11);
        int m = dt.get(12);
        int s = dt.get(13);
        int ms = dt.get(14);
        CMStringHelper.formatZeroPadNumber(h, fmt, 0, 2);
        fmt[2] = 58;
        CMStringHelper.formatZeroPadNumber(m, fmt, 3, 2);
        fmt[5] = 58;
        CMStringHelper.formatZeroPadNumber(s, fmt, 6, 2);
        fmt[8] = 46;
        CMStringHelper.formatZeroPadNumber(ms, fmt, 9, 3);
        return new String(fmt);
    }

    public static Calendar parseDate(String date) {
        return CMStringHelper2.parseDateTimeCommon(date, 1);
    }

    public static Calendar parseTime(String time) {
        return CMStringHelper2.parseDateTimeCommon(time, 11);
    }

    public static Calendar parseDateTime(String dateTime) {
        return CMStringHelper2.parseDateTimeCommon(dateTime, 1);
    }

    private static Calendar parseDateTimeCommon(String date, int startDatePart) {
        int numberSoFar = 0;
        int datePart = startDatePart;
        Calendar c = Calendar.getInstance();
        c.set(1, 0);
        c.set(2, 0);
        c.set(5, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        date = date.trim();
        int len = date.length();
        for (int i = 0; i < len; ++i) {
            char ch = date.charAt(i);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    numberSoFar *= 10;
                    numberSoFar += ch - 48;
                    break;
                }
                case ' ': 
                case '-': 
                case '/': 
                case ':': {
                    datePart = CMStringHelper2.setDatePart(c, datePart, numberSoFar);
                    numberSoFar = 0;
                }
            }
            if (numberSoFar == 0) continue;
            CMStringHelper2.setDatePart(c, datePart, numberSoFar);
        }
        return c;
    }

    private static int setDatePart(Calendar c, int datePart, int numberSoFar) {
        switch (datePart) {
            case 1: {
                c.set(1, numberSoFar);
                datePart = 2;
                break;
            }
            case 2: {
                c.set(2, numberSoFar - 1);
                datePart = 5;
                break;
            }
            case 5: {
                c.set(5, numberSoFar);
                datePart = 11;
                break;
            }
            case 11: {
                c.set(11, numberSoFar);
                datePart = 12;
                break;
            }
            case 12: {
                c.set(12, numberSoFar);
                datePart = 13;
                break;
            }
            case 13: {
                c.set(13, numberSoFar);
                datePart = -1;
            }
        }
        return datePart;
    }

    public static String join(Set set, String separator) {
        StringBuffer sb = new StringBuffer();
        String sep = "";
        Iterator it = set.iterator();
        while (it.hasNext()) {
            sb.append(sep);
            sb.append(it.next().toString());
            sep = separator;
        }
        return sb.toString();
    }

    public static String replace(String text, String targetText, String newText) {
        if (text == null) {
            return null;
        }
        if (targetText == null || newText == null || targetText.length() == 0) {
            return text;
        }
        Pattern pattern = Pattern.compile(targetText, 2);
        Matcher matcher = pattern.matcher(text);
        return matcher.replaceAll(newText);
    }

    public static String streamToString(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toString("UTF-8");
    }

    public static InputStream stringToInputStream(String str) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes("UTF-8"));
            return is;
        }
        catch (UnsupportedEncodingException e) {
            return new ByteArrayInputStream(str.getBytes());
        }
    }

    public static String md5Hash(String str) {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        String result = null;
        try {
            result = DigestUtils.md5Hex((byte[])str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            VM.log(CLASS, 3, e);
            throw new AssertionError((Object)e);
        }
        return result;
    }

    public static String replaceAll(String s, String[] wha, String[] with) {
        if (wha == null || wha.length == 0 || wha.length == 1 && (wha[0] == null || wha[0] == "") || with == null || with.length == 0 || s == null) {
            return s;
        }
        int loopSize = wha.length <= with.length ? wha.length : with.length;
        HashMap<String, String> replacementPairs = new HashMap<String, String>(loopSize);
        for (int i = 0; i < loopSize; ++i) {
            replacementPairs.put(wha[i], with[i]);
        }
        return CMStringHelper2.replaceAll(s, replacementPairs);
    }

    public static String replaceAll(String s, Map<String, String> replacementPairs) {
        if (replacementPairs == null || s == null) {
            return s;
        }
        String regex = "(" + CMStringHelper2.join(replacementPairs.keySet(), "|") + ")";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        StringBuffer buff = new StringBuffer(s.length());
        while (matcher.find()) {
            matcher.appendReplacement(buff, replacementPairs.get(matcher.group(1)));
        }
        matcher.appendTail(buff);
        return buff.toString();
    }

    public static String utf8Truncate(String s, int maxLen) {
        try {
            if (s == null) {
                return s;
            }
            byte[] bytes = s.getBytes("UTF-8");
            if (bytes.length <= maxLen) {
                return s;
            }
            Charset utf8Charset = Charset.forName("UTF-8");
            CharsetDecoder utf8Decoder = utf8Charset.newDecoder();
            ByteBuffer bb = ByteBuffer.wrap(bytes, 0, maxLen);
            CharBuffer cb = CharBuffer.allocate(maxLen);
            utf8Decoder.onMalformedInput(CodingErrorAction.IGNORE);
            utf8Decoder.decode(bb, cb, true);
            utf8Decoder.flush(cb);
            return new String(cb.array(), 0, cb.position());
        }
        catch (UnsupportedEncodingException e) {
            return s.substring(0, maxLen);
        }
    }
}

