/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.vm.VM;

public class CMUrlHelper {
    static final String[] HEX = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0a", "0b", "0c", "0d", "0e", "0f", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3a", "3b", "3c", "3d", "3e", "3f", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "5e", "5f", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6a", "6b", "6c", "6d", "6e", "6f", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7a", "7b", "7c", "7d", "7e", "7f", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9a", "9b", "9c", "9d", "9e", "9f", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf", "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "da", "db", "dc", "dd", "de", "df", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"};
    private static String REALM_EQUALS = "realm=";

    public static String encodeUrl(String url) {
        return CMUrlHelper.encodeUrl(url, '%');
    }

    public static String encodeSourcePathElement(String element) {
        String[] searchVals = new String[]{"%", "/"};
        String[] replaceVals = new String[]{"%25", "%2F"};
        return CMStringHelper.replaceAll(element, searchVals, replaceVals, false);
    }

    public static String decodeSourcePathElement(String element) {
        String[] searchVals = new String[]{"%2F", "%25"};
        String[] replaceVals = new String[]{"/", "%"};
        return CMStringHelper.replaceAll(element, searchVals, replaceVals, false);
    }

    public static String encodeUrl(String url, char controlChar) {
        if (url == null) {
            return "";
        }
        int length = url.length();
        StringBuffer encodedUrl = new StringBuffer(length * 3);
        for (int i = 0; i < length; ++i) {
            char ch = url.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                encodedUrl.append(ch);
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                encodedUrl.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                encodedUrl.append(ch);
                continue;
            }
            if (ch == ' ') {
                encodedUrl.append('+');
                continue;
            }
            if (ch == controlChar) {
                encodedUrl.append(controlChar);
                encodedUrl.append(HEX[ch]);
                continue;
            }
            if (ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')') {
                encodedUrl.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                encodedUrl.append(controlChar);
                encodedUrl.append(HEX[ch]);
                continue;
            }
            if (ch <= '\u07ff') {
                encodedUrl.append(controlChar);
                encodedUrl.append(HEX[0xC0 | ch >> 6]);
                encodedUrl.append(controlChar);
                encodedUrl.append(HEX[0x80 | ch & 0x3F]);
                continue;
            }
            encodedUrl.append(controlChar);
            encodedUrl.append(HEX[0xE0 | ch >> 12]);
            encodedUrl.append(controlChar);
            encodedUrl.append(HEX[0x80 | ch >> 6 & 0x3F]);
            encodedUrl.append(controlChar);
            encodedUrl.append(HEX[0x80 | ch & 0x3F]);
        }
        return encodedUrl.toString();
    }

    public static String decodeUrl(String url) {
        return CMUrlHelper.decodeUrl(url, '%');
    }

    public static String decodeUrl(String url, char controlChar) {
        if (url == null || url.length() == 0) {
            return "";
        }
        StringBuffer decodedUrl = new StringBuffer(url.length());
        int l = url.length();
        int n = -1;
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            int b;
            char c = url.charAt(i);
            if (c == controlChar) {
                int hb = (Character.isDigit(c = url.charAt(++i)) ? c - 48 : 10 + Character.toLowerCase(c) - 97) & 0xF;
                c = url.charAt(++i);
                int lb = (Character.isDigit(c) ? c - 48 : 10 + Character.toLowerCase(c) - 97) & 0xF;
                b = hb << 4 | lb;
            } else {
                b = c == '+' ? 32 : (int)c;
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more != 0) continue;
                decodedUrl.append((char)sumb);
                continue;
            }
            if ((b & 0x80) == 0) {
                decodedUrl.append((char)b);
                continue;
            }
            if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
                continue;
            }
            if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
                continue;
            }
            if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
                continue;
            }
            if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
                continue;
            }
            sumb = b & 1;
            more = 5;
        }
        return decodedUrl.toString();
    }

    public static String encodeHexValue(int value, char controlChar) {
        String hex = value < 15 ? controlChar + "0" + Integer.toHexString(value) : (value < 255 ? controlChar + Integer.toHexString(value) : (value < 4095 ? controlChar + "0" + Integer.toHexString(value) : controlChar + Integer.toHexString(value)));
        return hex;
    }

    public static AuthenticateHeader parseAuthenticateHeader(String header) {
        AuthenticateHeader rc = new AuthenticateHeader();
        if (header == null) {
            return rc;
        }
        int i = (header = header.trim()).indexOf(32);
        if (i == -1) {
            rc.scheme = header;
            return rc;
        }
        rc.scheme = header.substring(0, i - 1);
        if ((header = header.substring(i).trim()).startsWith(REALM_EQUALS)) {
            int endRealmChar;
            if ((header = header.substring(REALM_EQUALS.length())).length() > 0 && header.charAt(0) == '\"') {
                endRealmChar = 34;
                header = header.substring(1);
            } else {
                endRealmChar = 32;
            }
            int endRealm = header.indexOf(endRealmChar);
            if (endRealm == -1) {
                rc.realm = header;
                header = "";
            } else {
                rc.realm = header.substring(0, endRealm);
                header = header.substring(endRealm + 1);
                header = header.trim();
            }
        }
        rc.params = header;
        return rc;
    }

    public static final String getWebRoot(String gatewayUrl) {
        try {
            String path;
            URI uri = URI.parseURI(gatewayUrl, !gatewayUrl.startsWith("?"));
            String string = path = uri.getPath() != null ? uri.getPath() : "";
            if (path.startsWith("/")) {
                return path;
            }
            return "/" + path;
        }
        catch (CMException e) {
            VM.log(CMUrlHelper.class, 3, "couldn't parse URI '" + gatewayUrl + "'", e);
            return "/";
        }
    }

    public static String getUrlTerm(String url, boolean first) {
        block5: {
            if (url == null || url.equals("")) {
                return "";
            }
            String[] terms = CMStringHelper.split(url, '/', true);
            if (terms.length <= 0) break block5;
            if (first) {
                for (int i = 0; i < terms.length; ++i) {
                    if ("".equals(terms[i])) continue;
                    return terms[i];
                }
            } else {
                for (int i = terms.length - 1; i >= 0; --i) {
                    if ("".equals(terms[i])) continue;
                    return terms[i];
                }
            }
        }
        return "";
    }

    public static class AuthenticateHeader {
        public String realm;
        public String scheme;
        public String params;
    }
}

