/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.vm.VM;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CMUrlHelper2 {
    private static String[] postFixesThatDoNotNeedTrailingSlash = new String[]{"/", ".cgi", ".dll", ".so", ".sl", "cognos_module"};

    public static final String getWebRoot(String gatewayUrl) {
        try {
            String path;
            URL url = CMUrlHelper2.buildWebContentURL(CMUrlHelper2.buildGatewayURL(CMUrlHelper2.URLWithString(gatewayUrl)));
            String string = path = url.getPath() != null ? url.getPath() : "";
            if (path.endsWith("/") && !path.equals("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.startsWith("/")) {
                return path;
            }
            return "/" + path;
        }
        catch (Exception e) {
            VM.log(CMUrlHelper.class, 3, "couldn't parse URI '" + gatewayUrl + "'", e);
            return "/";
        }
    }

    private static URL buildWebContentURL(URL c10GatewayURL) {
        URL web = null;
        if (c10GatewayURL != null) {
            String gatewayString = c10GatewayURL.toString();
            int poscgibin = gatewayString.indexOf("cgi-bin");
            if (poscgibin > 0) {
                String webContentURLStr = gatewayString.substring(0, poscgibin);
                web = CMUrlHelper2.URLWithString(webContentURLStr);
            } else {
                String p2pd = "p2pd/";
                int posp2pd = gatewayString.indexOf(p2pd);
                if (posp2pd > 0) {
                    String webContentURLStr = gatewayString.substring(0, posp2pd + p2pd.length());
                    web = CMUrlHelper2.URLWithString(webContentURLStr);
                } else {
                    web = CMUrlHelper2.urlByChoppingPathTerms(c10GatewayURL, 2);
                    if (web == null) {
                        VM.log(CMUrlHelper.class, 3, "Cannot determine webcontent URL from gateway: '" + gatewayString + "'. " + "Please confirm that your Cognos Configuration \"Gateway URI\" ends with /<gateway_alias>/bi/v1/disp.");
                    }
                }
            }
        }
        return web;
    }

    private static void splitToList(String source, String regex, String str, List<String> list, boolean skipEmpty) {
        String[] terms = source.split(regex);
        list.clear();
        for (String term : terms) {
            if (skipEmpty && term.trim().length() == 0) continue;
            list.add(term);
        }
    }

    private static URL URLrelativeTo(URL parent, String path) {
        try {
            return new URL(parent, path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL urlByChoppingPathTerms(URL url, int chop) {
        URL choppedURL = null;
        String path = url.getPath();
        ArrayList<String> pathTerms = new ArrayList<String>();
        CMUrlHelper2.splitToList(path, "/", "/", pathTerms, true);
        if (pathTerms.size() > chop || chop == 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < pathTerms.size() - chop; ++i) {
                sb.append("/");
                sb.append((String)pathTerms.get(i));
            }
            sb.append("/");
            choppedURL = CMUrlHelper2.URLrelativeTo(url, sb.toString());
        }
        return choppedURL;
    }

    private static String ensureProtocol(String url) {
        int iNotSlash;
        String caseInsensitiveUrl = url.toLowerCase();
        String httpWithSlash = "http://";
        String httpsWithSlash = "https://";
        if (caseInsensitiveUrl.startsWith(httpWithSlash) || caseInsensitiveUrl.startsWith(httpsWithSlash)) {
            return url;
        }
        String http = "http:";
        String https = "https:";
        String protocol = null;
        int beginIndex = -1;
        if (caseInsensitiveUrl.startsWith(http)) {
            beginIndex = http.length();
            protocol = httpWithSlash;
        } else if (caseInsensitiveUrl.startsWith(https)) {
            beginIndex = https.length();
            protocol = httpsWithSlash;
        }
        if (beginIndex >= 0 && beginIndex < url.length()) {
            return String.format("%s%s", protocol, url.substring(beginIndex));
        }
        for (iNotSlash = 0; iNotSlash < url.length() && url.charAt(iNotSlash) == '/'; ++iNotSlash) {
        }
        if (iNotSlash > 0) {
            url = url.substring(iNotSlash);
        }
        return String.format("%s%s", httpWithSlash, url);
    }

    private static URL buildGatewayURL(URL c10GatewayURL) {
        URL fixedGateway = null;
        if (c10GatewayURL != null) {
            String gateway = c10GatewayURL.toString();
            int idx = gateway.indexOf("?");
            if (idx > 0) {
                gateway = gateway.substring(0, idx);
            }
            gateway = CMUrlHelper2.ensureProtocol(gateway);
            String lowerCaseGW = gateway.toLowerCase();
            boolean appendSlashToGatewayUrl = true;
            for (String postfix : postFixesThatDoNotNeedTrailingSlash) {
                if (!lowerCaseGW.endsWith(postfix)) continue;
                appendSlashToGatewayUrl = false;
                break;
            }
            if (appendSlashToGatewayUrl) {
                gateway = String.format("%s/", gateway);
            }
            fixedGateway = CMUrlHelper2.URLWithString(gateway);
            fixedGateway = CMUrlHelper2.normalizeURL(fixedGateway);
        }
        return fixedGateway;
    }

    private static URL normalizeURL(URL url) {
        if (url == null) {
            return null;
        }
        URL result = null;
        String protocol = url.getProtocol().toLowerCase();
        String host = url.getHost().toLowerCase();
        int port = url.getPort();
        if (url.getDefaultPort() == port) {
            port = -1;
        }
        String path = url.getPath().replace("//", "/");
        try {
            path = new URI(path).normalize().toString();
        }
        catch (URISyntaxException e) {
            VM.log(CMUrlHelper.class, 3, "couldn't normalizeURL  '" + url.toString() + "'", e);
        }
        try {
            result = new URL(protocol, host, port, path);
        }
        catch (MalformedURLException e) {
            VM.log(CMUrlHelper.class, 3, "couldn't normalizeURL '" + url.toString() + "'", e);
        }
        return result;
    }

    private static URL URLWithString(String url) {
        URL aUrl = null;
        try {
            boolean absoluteUrl = false;
            String lowerCaseUrl = url.toLowerCase();
            if (lowerCaseUrl.startsWith("http://") || lowerCaseUrl.startsWith("https://")) {
                absoluteUrl = true;
            }
            if (!absoluteUrl) {
                url = "http://" + url;
            }
            aUrl = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return aUrl;
    }

    public static String getUrlTerm(String url, boolean first) {
        block5: {
            if (url == null || url.equals("")) {
                return "";
            }
            String[] terms = CMStringHelper.split(url, '/', true);
            if (terms.length <= 0) break block5;
            if (first) {
                for (int i = 0; i < terms.length; ++i) {
                    if ("".equals(terms[i])) continue;
                    return terms[i];
                }
            } else {
                for (int i = terms.length - 1; i >= 0; --i) {
                    if ("".equals(terms[i])) continue;
                    return terms[i];
                }
            }
        }
        return "";
    }

    public static Map<String, String> getURLParameters(String url) throws CMException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        try {
            URI uri = new URI(url);
            String query = uri.getQuery();
            if (query != null) {
                String[] queries = CMStringHelper.split(query, '&', false);
                for (int i = 0; i < queries.length; ++i) {
                    String[] pair = CMStringHelper.split(queries[i], '=', false);
                    parameters.put(pair[0], pair[1]);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new CMException(1006, (Throwable)e);
        }
        return parameters;
    }

    public static String setURLParameters(String url, Map<String, String> parameters) throws CMException {
        if (parameters == null || url == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<Map.Entry<String, String>> i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
            if (!i.hasNext()) continue;
            buffer.append('&');
        }
        String result = url;
        try {
            URI uri = new URI(url);
            URI uriResult = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), buffer.toString(), uri.getFragment());
            result = uriResult.toString();
        }
        catch (URISyntaxException e) {
            throw new CMException(1006, (Throwable)e);
        }
        return result;
    }
}

