/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class CapturingOutputStream
extends OutputStream {
    private int count = 0;
    private int offset;
    private int length;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public CapturingOutputStream(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    @Override
    public void write(byte[] bs) {
        this.write(bs, 0, bs.length);
    }

    @Override
    public void write(byte[] bs, int o, int l) {
        int wantToCapture;
        int wantToThrowAway = this.offset - this.count;
        if (wantToThrowAway > 0) {
            if (l <= wantToThrowAway) {
                o += l;
                this.count += l;
                l = 0;
                return;
            }
            o += wantToThrowAway;
            l -= wantToThrowAway;
            this.count += wantToThrowAway;
        }
        int n = wantToCapture = this.length == -1 ? l : this.offset + this.length - this.count;
        if (wantToCapture > 0) {
            if (l <= wantToCapture) {
                this.baos.write(bs, o, l);
                o += l;
                this.count += l;
                l = 0;
                return;
            }
            this.baos.write(bs, o, wantToCapture);
            o += wantToCapture;
            l -= wantToCapture;
            this.count += wantToCapture;
        }
        if (l > 0) {
            this.count += l;
        }
    }

    @Override
    public void write(int b) {
        if (this.count >= this.offset && (this.length == -1 || this.count < this.offset + this.length)) {
            this.baos.write(b);
        }
        ++this.count;
    }

    public byte[] getCapturedBytes() {
        return this.baos.toByteArray();
    }

    public int getTotalLength() {
        return this.count;
    }
}

