/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.jzlib.ZInputStream;
import com.cognos.mobile.jzlib.ZOutputStream;
import com.cognos.mobile.standardedition.InputStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;

public class CompressionHelper {
    public static OutputStream getCompressionStream(OutputStream wrappedStream) {
        return new ZOutputStream(wrappedStream, 9);
    }

    public static byte[] compress(byte[] input) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream outStream = CompressionHelper.getCompressionStream(baos);
            outStream.write(input);
            outStream.flush();
            outStream.close();
            byte[] compressedBytes = baos.toByteArray();
            baos.close();
            return compressedBytes;
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    public static byte[] decompress(byte[] input) {
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(input);
            InflaterInputStream inStream = new InflaterInputStream(byteStream);
            return InputStreamFactory.slurpStream(inStream);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    public static InputStream getDecompressionStream(InputStream wrappedStream) {
        return new ZInputStream(wrappedStream);
    }
}

