/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.vm.VM;

public class ExceptionCracker {
    private static final Class CLASS = ExceptionCracker.class;

    public static Data crackException(Throwable ex, IResourceManager resourceManager) {
        Data data = new Data();
        String[] params = null;
        if (ex instanceof CMException) {
            CMException cmex = (CMException)ex;
            params = cmex.getErrorParams();
            data.errorCode = cmex.getErrorCode();
        } else {
            data.errorCode = 2000;
        }
        data.details = ex.toString();
        String key = Integer.toString(data.errorCode);
        try {
            data.message = resourceManager.formatString(key, params);
        }
        catch (Exception e) {
            data.message = null;
        }
        if (data.message == null || data.message.length() == 0) {
            VM.log(CLASS, 2, "no message for error code: " + data.errorCode);
            data.message = resourceManager.formatString(CMIDs.UNKNOWN_ERROR_CODE, key);
            data.errorCodeString = key;
        } else {
            int space = data.message.indexOf(" ");
            if (space > -1) {
                data.errorCodeString = data.message.substring(0, space);
                data.message = data.message.substring(space + 1);
            } else {
                data.errorCodeString = key;
            }
        }
        data.details = data.errorCodeString + "\n" + ex.toString();
        if (data.errorCode == 2011) {
            data.details = resourceManager.loadString(CMIDs.DEMO_EXCEPTION_DETAILS);
        }
        if (data.details != null && data.details.indexOf(CMIDs.SERVER_UNREACHABLE) != -1) {
            data.message = resourceManager.loadString(CMIDs.SERVER_UNREACHABLE);
        }
        return data;
    }

    public static class Data {
        public int errorCode;
        public String errorCodeString;
        public String message;
        public String details;
        public String stackTrace;
    }
}

