/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;

public class FlowContainer {
    private static Class CLASS = FlowContainer.class;
    private static final int OBJECT_TOO_HIGH = 1;
    private static final int OBJECT_TOO_LOW = 2;
    private static final int OBJECT_TOO_LEFT = 4;
    private static final int OBJECT_TOO_RIGHT = 8;
    private int flow;
    private boolean allowGrowX;
    private boolean allowGrowY;
    private int parentX;
    private int parentY;
    private int parentCX;
    private int parentCY;
    private int objectX;
    private int objectY;
    private int extentCX;
    private int extentCY;

    public FlowContainer(int flow, boolean allowGrowX, boolean allowGrowY, int parentX, int parentY, int parentCX, int parentCY) {
        this.flow = flow;
        this.allowGrowX = allowGrowX;
        this.allowGrowY = allowGrowY;
        this.parentX = parentX;
        this.parentY = parentY;
        this.parentCX = parentCX;
        this.parentCY = parentCY;
        this.objectX = parentX;
        this.objectY = parentY;
        this.extentCX = 0;
        this.extentCY = 0;
    }

    public VMPoint getExtent() {
        return new VMPoint(this.extentCX, this.extentCY);
    }

    public VMPoint insertNextLine() {
        if (this.objectX != this.parentX) {
            if (this.allowGrowY) {
                this.parentCY = Math.max(this.parentCY, this.extentCY);
            }
            this.objectX = this.parentX;
            this.objectY = this.parentY + this.extentCY;
        }
        return new VMPoint(this.objectX, this.objectY);
    }

    public VMPoint insertObjectAtPosition(int objectX, int objectY, int objectCX, int objectCY) {
        this.objectX = objectX;
        this.objectY = objectY;
        return this.insertObject(objectCX, objectCY);
    }

    public VMPoint insertObject(int objectCX, int objectCY) {
        VMRect parent = new VMRect(this.parentX, this.parentY, this.parentCX, this.parentCY);
        VMRect object = new VMRect(this.objectX, this.objectY, objectCX, objectCY);
        int loopCount = 0;
        int disallowedFlags = 0;
        while (true) {
            if (object.cx <= 0 || object.cy <= 0) {
                object.cx = 0;
                object.cy = 0;
                break;
            }
            if (++loopCount > 20) {
                VM.log(CLASS, 3, "flowObject loop count exceeds 20!");
                break;
            }
            int flags = 0;
            if (object.y < parent.y) {
                flags |= 1;
            }
            if (object.getBottom() > parent.getBottom()) {
                flags |= 2;
            }
            if (object.x < parent.x) {
                flags |= 4;
            }
            if (object.getRight() > parent.getRight()) {
                flags |= 8;
            }
            if ((flags &= ~disallowedFlags) == 0) break;
            if ((flags & 4) == 4) {
                switch (this.flow) {
                    default: {
                        object.x += parent.x - object.x;
                        break;
                    }
                    case 1: {
                        if (this.allowGrowX) {
                            parent.x -= parent.x - object.x;
                            parent.cx += parent.x - object.x;
                            break;
                        }
                        if (object.x == parent.getRight() - object.cx) break;
                        object.x = parent.getRight() - object.cx;
                        object.y = parent.getBottom();
                    }
                }
                disallowedFlags |= 4;
                continue;
            }
            if ((flags & 8) == 8) {
                switch (this.flow) {
                    case 1: {
                        object.x -= object.getRight() - parent.getRight();
                        break;
                    }
                    case 0: {
                        if (this.allowGrowX) {
                            parent.cx += object.getRight() - parent.getRight();
                            break;
                        }
                        if (object.x == parent.x) break;
                        object.x = parent.x;
                        object.y = parent.getBottom();
                    }
                }
                disallowedFlags |= 8;
                continue;
            }
            if ((flags & 1) == 1) {
                object.y += parent.y - object.y;
                disallowedFlags |= 1;
                continue;
            }
            if ((flags & 2) != 2) continue;
            if (this.allowGrowY) {
                parent.cy += object.getBottom() - parent.getBottom();
            } else {
                object.cy -= object.getBottom() - parent.getBottom();
            }
            disallowedFlags |= 2;
        }
        VMPoint topLeft = this.updateState(object, parent);
        return topLeft;
    }

    public VMPoint textAlignObject(int textAlign, int objectCX, int objectCY) {
        int newX;
        boolean atLineStart = false;
        switch (this.flow) {
            case 0: {
                atLineStart = this.objectX <= this.parentY;
                break;
            }
            case 1: {
                boolean bl = atLineStart = this.objectX + objectCX >= this.parentX + this.parentCX;
            }
        }
        if (!atLineStart) {
            this.insertNextLine();
        }
        switch (textAlign) {
            default: {
                newX = this.parentX;
                break;
            }
            case 1: {
                newX = this.parentX + this.parentCX - objectCX;
                break;
            }
            case 2: {
                this.objectX = newX = this.parentX + (this.parentCX - objectCX) / 2;
            }
        }
        VMRect object = new VMRect(newX, this.objectY, objectCX, objectCY);
        int newParentCY = this.allowGrowY ? Math.max(this.parentCY, this.objectY + objectCY - this.parentY) : this.parentCY;
        VMRect parent = new VMRect(this.parentX, this.parentY, this.parentCX, newParentCY);
        return this.updateState(object, parent);
    }

    private VMPoint updateState(VMRect object, VMRect parent) {
        if (this.allowGrowX) {
            this.parentCX = parent.cx;
        }
        if (this.allowGrowY) {
            this.parentCY = parent.cy;
        }
        this.extentCX = Math.max(this.extentCX, object.getRight() - this.parentX);
        this.extentCY = Math.max(this.extentCY, object.getBottom() - this.parentY);
        switch (this.flow) {
            default: {
                this.objectX = object.x + object.cx;
                this.objectY = object.y;
                break;
            }
            case 1: {
                this.objectX = object.x;
                this.objectY = object.y;
            }
        }
        VMPoint topLeft = new VMPoint(object.x, object.y);
        return topLeft;
    }
}

