/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.vm.VM;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageInfo {
    private static final Class<ImageInfo> CLASS = ImageInfo.class;
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    private int blobID;
    private int width;
    private int height;

    public ImageInfo(int blobID, int width, int height) {
        this.blobID = blobID;
        this.width = width;
        this.height = height;
    }

    public ImageInfo(int blobID) {
        this.blobID = blobID;
        this.width = -1;
        this.height = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getDimensions(byte[] bytes) {
        int[] dimensions = new int[]{-1, -1};
        Iterator<ImageReader> imageReaderIt = null;
        ImageInputStream imageIn = null;
        ImageReader imageReader = null;
        try {
            imageIn = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            imageReaderIt = ImageIO.getImageReaders(imageIn);
            imageReader = imageReaderIt.next();
            imageReader.setInput(imageIn);
            dimensions[0] = imageReader.getWidth(imageReader.getMinIndex());
            dimensions[1] = imageReader.getHeight(imageReader.getMinIndex());
        }
        catch (Exception e) {
            VM.log(CLASS, 0, "Couldn't obtain height/width for an image, exception: " + e);
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
            if (imageIn != null) {
                try {
                    imageIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return dimensions;
    }

    public int getBlobID() {
        return this.blobID;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

