/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

public class IntMap {
    private final int BUCKETS = 20;
    private Entry[] buckets = new Entry[20];
    private int size = 0;

    public Object get(int key) {
        int bucket = this.getBucket(key);
        Entry entry = this.buckets[bucket];
        while (entry != null) {
            if (entry.key == key) {
                return entry.val;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean contains(int key) {
        return this.get(key) != null;
    }

    public void put(int key, Object val) {
        int bucket = this.getBucket(key);
        Entry entry = this.buckets[bucket];
        if (entry == null) {
            this.buckets[bucket] = new Entry(key, val, null);
            ++this.size;
        } else {
            while (entry != null) {
                if (entry.key == key) {
                    entry.val = val;
                    return;
                }
                entry = entry.next;
            }
            this.buckets[bucket] = entry = new Entry(key, val, this.buckets[bucket]);
            ++this.size;
        }
    }

    public Object remove(int key) {
        block3: {
            int bucket = this.getBucket(key);
            Entry entry = this.buckets[bucket];
            if (entry == null) {
                return null;
            }
            if (entry.key == key) {
                this.buckets[bucket] = entry.next;
                --this.size;
                return entry.val;
            }
            do {
                Entry prev = entry;
                entry = entry.next;
                if (entry == null) break block3;
            } while (entry.key != key);
            prev.next = entry.next;
            --this.size;
            return entry.val;
        }
        return null;
    }

    public IntMap copy() {
        IntMap copy = new IntMap();
        copy.size = this.size;
        copy.buckets = new Entry[this.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry n;
            if (this.buckets[i] == null) continue;
            Entry e = this.buckets[i];
            copy.buckets[i] = n = new Entry(e.key, e.val, null);
            while ((e = e.next) != null) {
                n = n.next = new Entry(e.key, e.val, null);
            }
        }
        return copy;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        for (int i = 0; i < 20; ++i) {
            this.buckets[i] = null;
        }
        this.size = 0;
    }

    private int getBucket(int key) {
        if (key < 0) {
            return -key % 20;
        }
        return key % 20;
    }

    public IntEnumeration keys() {
        return new IntEnumeration();
    }

    public class IntEnumeration {
        private int bucket = 0;
        private Entry next = null;

        private IntEnumeration() {
            this.findNext();
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public int nextElement() {
            Entry ret = this.next;
            this.findNext();
            return ret.key;
        }

        public Object nextValue() {
            Entry ret = this.next;
            this.findNext();
            return ret.val;
        }

        private void findNext() {
            if (this.next != null) {
                this.next = this.next.next;
            }
            if (this.next == null) {
                while (this.bucket < 20) {
                    this.next = IntMap.this.buckets[this.bucket++];
                    if (this.next == null) continue;
                    return;
                }
            }
        }
    }

    private static class Entry {
        public int key;
        public Object val;
        public Entry next = null;

        public Entry(int key, Object val, Entry next) {
            this.key = key;
            this.val = val;
            this.next = next;
        }
    }
}

