/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.client.LeaseKeyChecker;
import com.cognos.mobile.common.CMBase64;
import com.cognos.mobile.common.CMCircularLogger;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.ICMImageFactory;
import com.cognos.mobile.common.ICMXMLParserFactory;
import com.cognos.mobile.common.ILogger;
import com.cognos.mobile.common.IPromptPrompter;
import com.cognos.mobile.event.Event;
import com.cognos.mobile.event.ICookieManager;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.event.IServerResponseListener;
import com.cognos.mobile.model.data.About;
import com.cognos.mobile.model.data.AtomFeedNode;
import com.cognos.mobile.model.data.PortalItem;
import com.cognos.mobile.model.data.Render;
import com.cognos.mobile.model.data.Report;
import com.cognos.mobile.prompts.PSearchAndSelect;
import com.cognos.mobile.prompts.PTree;
import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.prompts.Prompts;
import com.cognos.mobile.prompts.TreePromptNode;
import com.cognos.mobile.request.ChunkedRequestHandler;
import com.cognos.mobile.request.DBResponseHandler;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerRequestFactory;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.request.ImageHandler;
import com.cognos.mobile.request.KeyResponseHandler;
import com.cognos.mobile.request.MetaHandler;
import com.cognos.mobile.request.MobXmlResponseHandler;
import com.cognos.mobile.request.PromptHandler;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.task.ICancellable;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.xml.XMLAboutHandler;
import com.cognos.mobile.xml.XMLBrowseAtomFeedHandler;
import com.cognos.mobile.xml.XMLBrowsePortalHandler;
import com.cognos.mobile.xml.XMLBrowseTreeNodePromptHandler;
import com.cognos.mobile.xml.XMLGetSettingsHandler;
import com.cognos.mobile.xml.XMLPromptHandler;
import com.cognos.mobile.xml.XMLRenderInProgressHandler;
import com.cognos.mobile.xml.XMLRenderStatusHandler;
import com.cognos.mobile.xml.XMLResponseHandler;
import com.cognos.mobile.xml.XMLRunReportHandler;
import com.cognos.mobile.xml.XMLSearchHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class MobileServiceProxy {
    public static final int CONNECTION_UNKNOWN = 0;
    public static final int CONNECTION_OFFLINE = 1;
    public static final int CONNECTION_ONLINE = 2;
    private static final int NUMBER_OF_REQUESTS_TO_KEEP = 7;
    private static final Class CLASS = MobileServiceProxy.class;
    private static final int MAX_URL_REPEATS = 20;
    private final ICMImageFactory imgFact;
    private final ICMXMLParserFactory xmlPFact;
    private final IServerRequestFactory serverRequestFactory;
    private final ICMXMLParserFactory xmlParserFactory;
    private final IEventManager eventManager;
    private final IRecoverableResponseHandler[] recoverableResponseHandlers;
    private final VMOptions options;
    private ServerRequestModifier[] serverRequestModifiers = null;
    private ICookieManager cookieManager = ICookieManager.NULL;
    private IServerResponseListener serverResponseListener = IServerResponseListener.NULL;
    private LeaseKeyChecker leaseKeyChecker = null;
    private IPromptPrompter prompter;
    private ILogger logger = ILogger.NULL;
    private int connectionState = 0;
    private boolean completedFirstGet = false;

    public MobileServiceProxy(IServerRequestFactory serverRequestFactory, ICMImageFactory imgFact, VMOptions options, ICMXMLParserFactory xmlParserFactory, IEventManager eventManager, IRecoverableResponseHandler[] responseHandlers, IPromptPrompter prompter) {
        if (eventManager == null) {
            throw new IllegalArgumentException("eventManager can't be null");
        }
        this.serverRequestFactory = serverRequestFactory;
        this.options = options;
        this.xmlParserFactory = xmlParserFactory;
        this.eventManager = eventManager;
        this.imgFact = imgFact;
        this.xmlPFact = xmlParserFactory;
        this.recoverableResponseHandlers = responseHandlers;
        this.prompter = prompter == null ? new IPromptPrompter(){

            @Override
            public boolean prompt(Prompts prompts) throws CMException {
                return false;
            }
        } : prompter;
        this.logger = new CMCircularLogger(7, CMCircularLogger.FLAG_SEPARATORS);
    }

    public MobileServiceProxy(IServerRequestFactory serverRequestFactory, ICMImageFactory imgFact, VMOptions options, ICMXMLParserFactory xmlParserFactory, IEventManager eventManager, IRecoverableResponseHandler[] responseHandlers) {
        this(serverRequestFactory, imgFact, options, xmlParserFactory, eventManager, responseHandlers, null);
    }

    public void setPromptPrompter(IPromptPrompter p) {
        this.prompter = p;
    }

    public int getConnectionState() {
        return this.connectionState;
    }

    public void addServerRequestModifier(ServerRequestModifier srm) {
        if (this.serverRequestModifiers == null) {
            this.serverRequestModifiers = new ServerRequestModifier[]{srm};
        } else {
            ServerRequestModifier[] srms = new ServerRequestModifier[this.serverRequestModifiers.length + 1];
            System.arraycopy(this.serverRequestModifiers, 0, srms, 1, this.serverRequestModifiers.length);
            srms[0] = srm;
            this.serverRequestModifiers = srms;
        }
    }

    public void setCookieManager(ICookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public void setServerResponseListener(IServerResponseListener listener) {
        this.serverResponseListener = listener;
    }

    public void setLeaseKeyChecker(LeaseKeyChecker leaseKeyChecker) {
        this.leaseKeyChecker = leaseKeyChecker;
    }

    public About getAbout(ITaskMonitor taskMonitor, boolean forceLogon) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_ABOUT);
        if (forceLogon) {
            request.setArgument("h_CAM_action", "logonAs");
        }
        XMLAboutHandler handler = new XMLAboutHandler();
        this.doServerCommand(request, handler, taskMonitor);
        return handler.getAboutInformation();
    }

    public int getRenderStatus(ITaskMonitor taskMonitor, boolean forceLogon, int renderID) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_RENDER_STATUS);
        request.setArgument(CMUrlConstants.PARAM_RENDERID[0], renderID);
        if (forceLogon) {
            request.setArgument("h_CAM_action", "logonAs");
        }
        XMLRenderStatusHandler handler = new XMLRenderStatusHandler();
        this.doServerCommand(request, handler, taskMonitor);
        return handler.getRenderStatus();
    }

    public PortalItem[] browsePortal(String path, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_BROWSE_PORTAL);
        request.setArgument(CMUrlConstants.PARAM_REPORT_PATH[0], CMUrlHelper.encodeUrl(path));
        XMLBrowsePortalHandler handler = new XMLBrowsePortalHandler();
        this.doServerCommand(request, handler, taskMonitor);
        return handler.getPortalItems();
    }

    public AtomFeedNode browseAtomFeed(AtomFeedNode node, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_BROWSE_ATOM_FEED);
        request.setArgument(CMUrlConstants.PARAM_ATOM_LINK[0], CMUrlHelper.encodeUrl(node.getAtomLink()));
        XMLBrowseAtomFeedHandler atomFeedHandler = new XMLBrowseAtomFeedHandler(node, this.xmlParserFactory);
        this.doServerCommand(request, atomFeedHandler, taskMonitor);
        return node;
    }

    public int appendChunk(int id, ITaskMonitor taskMonitor, String body) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_CHUNKREQUEST);
        request.setArgument(CMUrlConstants.PARAM_METHOD[0], "POST");
        request.setArgument(CMUrlConstants.PARAM_RESOURCE[0], id);
        request.setArgument(CMUrlConstants.PARAM_CONTENT_BODY[0], body);
        ChunkedRequestHandler handler = new ChunkedRequestHandler(this, this.xmlPFact);
        this.doServerCommand(request, handler, taskMonitor);
        return handler.getLength();
    }

    public int chunkRequest(ITaskMonitor taskMonitor, String body) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_CHUNKREQUEST);
        request.setArgument(CMUrlConstants.PARAM_METHOD[0], "POST");
        request.setArgument(CMUrlConstants.PARAM_CONTENT_BODY[0], body);
        ChunkedRequestHandler handler = new ChunkedRequestHandler(this, this.xmlPFact);
        this.doServerCommand(request, handler, taskMonitor);
        return handler.getChunkId();
    }

    public void execute(XMLResponseHandler handler, boolean forceLogOn, String servletPath, String resourcePath, String method, String body, ITaskMonitor taskMonitor, boolean noAdditionalContent) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_METHOD[0], method);
        request.setArgument(CMUrlConstants.PARAM_RESOURCE[0], resourcePath);
        if (noAdditionalContent) {
            request.setArgument(CMUrlConstants.PARAM_NO_ADDITIONAL_CONTENT[0], "");
        }
        if (forceLogOn) {
            request.setArgument("h_CAM_action", "logonAs");
        }
        if (servletPath != null) {
            request.setArgument(CMUrlConstants.PARAM_OPERATION[0], servletPath);
        }
        if (body != null && (method.equalsIgnoreCase("post") || method.equalsIgnoreCase("put"))) {
            request.setArgument(CMUrlConstants.PARAM_CONTENT_BODY[0], body);
        }
        this.doServerCommand(request, handler, taskMonitor);
    }

    public Hashtable getSettings(boolean forceLogOn, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_GET_SETTINGS);
        if (forceLogOn) {
            request.setArgument("h_CAM_action", "logonAs");
        }
        XMLGetSettingsHandler handler = new XMLGetSettingsHandler();
        this.doServerCommand(request, handler, taskMonitor);
        return handler.getSettings();
    }

    public KeyResponseHandler getKey(ITaskMonitor taskMonitor, String platform) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_GET_KEY);
        request.setArgument(CMUrlConstants.PARAM_RESOURCE[0], "/?platform=" + platform);
        KeyResponseHandler handler = new KeyResponseHandler();
        this.doServerCommand(request, handler, taskMonitor);
        return handler;
    }

    public Report[] search(String keyword, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_SEARCH);
        request.setArgument(CMUrlConstants.PARAM_QUERY[0], CMUrlHelper.encodeUrl(keyword));
        XMLSearchHandler handler = new XMLSearchHandler();
        this.doServerCommand(request, handler, taskMonitor);
        return handler.getReportList();
    }

    public void log(String msg) throws CMException {
        if (this.options.serverUrlLooksOK()) {
            IServerRequest request = this.serverRequestFactory.createServerRequest("admin/status", IServerRequestFactory.REQUEST_TYPE_POST);
            request.setArgument("msg", msg);
            this.doServerCommand(request, new IRecoverableResponseHandler(){

                @Override
                public boolean canHandle(IServerResponse response) throws CMException {
                    return true;
                }

                @Override
                public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
                    return null;
                }
            }, null);
        } else {
            System.out.println(msg);
        }
    }

    public TreePromptNode browseTreeNodePrompt(PTree tree, TreePromptNode node, String conversation, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_BROWSE_TREE_PROMPT);
        request.setArgument(CMUrlConstants.PARAM_REPORT_PATH[0], CMUrlHelper.encodeUrl(conversation));
        request.setArgument(CMUrlConstants.PARAM_CONTENT_BODY[0], CMUrlHelper.encodeUrl(tree.toExpandPromptAnswers(node)));
        XMLBrowseTreeNodePromptHandler handler = new XMLBrowseTreeNodePromptHandler(node, this.xmlParserFactory);
        this.doServerCommand(request, handler, taskMonitor);
        return node;
    }

    public void searchAndSelectPrompt(PSearchAndSelect ss, Prompts prompts, String value, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_CCS);
        request.setArgument(CMUrlConstants.PARAM_RESOURCE[0], "/promptDescription/report/" + prompts.getStoreId());
        String promptAnswers = "<promptAnswers xlmns='http://developer.cognos.com/schemas/rds/types/2'><conversationID>" + prompts.getConversationId() + "</conversationID>" + ss.toSearchPromptAnswers(value) + "</promptAnswers>";
        request.setArgument(CMUrlConstants.PARAM_CONTENT_BODY[0], CMUrlHelper.encodeUrl(promptAnswers));
        XMLPromptHandler handler = new XMLPromptHandler(this.xmlParserFactory);
        this.doServerCommand(request, handler, taskMonitor);
        Prompts ps = handler.getPrompts();
        Prompt[] pp = ps.listPromptItems();
        for (int i = 0; i < pp.length; ++i) {
            PSearchAndSelect ssp;
            Prompt p = pp[i];
            if (p.type() != 5 || !(ssp = (PSearchAndSelect)p).getId().equals(ss.getId())) continue;
            ss.resetOptions(ssp.getOptions());
        }
    }

    public Render runReport(String storeID, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_COMPILE_REPORT);
        request.setArgument(CMUrlConstants.PARAM_WAITFOR[0], 6);
        if (storeID.indexOf(47) == -1) {
            request.setArgument(CMUrlConstants.PARAM_RESOURCE[0], CMUrlHelper.encodeUrl(storeID));
        } else {
            request.setArgument(CMUrlConstants.PARAM_REPORT_PATH[0], CMUrlHelper.encodeUrl(storeID));
        }
        XMLRunReportHandler handler = new XMLRunReportHandler();
        MetaHandler metaHandler = new MetaHandler(new IRecoverableResponseHandler[]{new PromptHandler(this.xmlPFact, this.prompter, this, this.options), new MobXmlResponseHandler(this.serverResponseListener, this.xmlParserFactory, handler)});
        this.doServerCommand(request, metaHandler, taskMonitor);
        return handler.getRender();
    }

    public Render drillThroughReport(String context, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_DRILLTHROUGH);
        request.setArgument(CMUrlConstants.PARAM_CONTEXT_XML[0], CMUrlHelper.encodeUrl(context));
        XMLRunReportHandler handler = new XMLRunReportHandler();
        MetaHandler metaHandler = new MetaHandler(new IRecoverableResponseHandler[]{new PromptHandler(this.xmlPFact, this.prompter, this, this.options), new MobXmlResponseHandler(this.serverResponseListener, this.xmlParserFactory, handler)});
        this.doServerCommand(request, metaHandler, taskMonitor);
        return handler.getRender();
    }

    public Render drillUpDownReport(int sourceRenderID, String direction, String context, int widgetId, int pageIndex, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_DRILL_UP_DOWN);
        request.setArgument(CMUrlConstants.PARAM_CONTEXT_XML[0], CMUrlHelper.encodeUrl(context));
        request.setArgument(CMUrlConstants.PARAM_DRILL_DIRECTION[0], direction);
        request.setArgument(CMUrlConstants.PARAM_RENDERID[0], sourceRenderID);
        request.setArgument(CMUrlConstants.PARAM_WIDGETID[0], widgetId);
        request.setArgument(CMUrlConstants.PARAM_PAGE_INDEX[0], pageIndex);
        XMLRunReportHandler handler = new XMLRunReportHandler();
        MetaHandler metaHandler = new MetaHandler(new IRecoverableResponseHandler[]{new PromptHandler(this.xmlPFact, this.prompter, this, this.options), new MobXmlResponseHandler(this.serverResponseListener, this.xmlParserFactory, handler)});
        this.doServerCommand(request, metaHandler, taskMonitor);
        return handler.getRender();
    }

    public void updateInProgressStatus(Render render, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_POST);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_RENDER_IN_PROGRESS);
        request.setArgument(CMUrlConstants.PARAM_WAITFOR[0], 6);
        request.setArgument(CMUrlConstants.PARAM_RENDERID[0], render.renderID);
        request.setArgument(CMUrlConstants.PARAM_P64GUID[0], render.inProgress.getNodeID());
        request.setArgument(CMUrlConstants.PARAM_PPS_TRACKING[0], render.inProgress.getTrackingVal());
        XMLRenderInProgressHandler handler = new XMLRenderInProgressHandler(render.inProgress);
        MetaHandler metaHandler = new MetaHandler(new IRecoverableResponseHandler[]{new MobXmlResponseHandler(this.serverResponseListener, this.xmlParserFactory, handler)});
        this.doServerCommand(request, metaHandler, taskMonitor);
    }

    public byte[] downloadDB(int renderID, int pageIndex, int[] totalLength, boolean compressed, ITaskMonitor taskMonitor) throws CMException {
        VM.log(CLASS, 0, "starting to download DB");
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_DOWNLOAD_DB);
        request.setArgument(CMUrlConstants.PARAM_RENDERID[0], renderID);
        request.setArgument(CMUrlConstants.PARAM_PAGE_INDEX[0], pageIndex);
        request.setArgument(CMUrlConstants.PARAM_COMPRESSED[0], compressed ? CMUrlConstants.VALUE_BOOLEAN_TRUE : CMUrlConstants.VALUE_BOOLEAN_FALSE);
        DBResponseHandler handler = new DBResponseHandler();
        this.doServerCommand(request, handler, taskMonitor);
        VM.log(CLASS, 0, "finished downloading DB");
        totalLength[0] = handler.getTotalLength();
        return handler.getBytes();
    }

    public int downloadDB(int renderID, int pageIndex, byte[] bytes, int offset, boolean compressed, ITaskMonitor taskMonitor) throws CMException {
        VM.log(CLASS, 0, "starting to download DB");
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_DOWNLOAD_DB);
        request.setArgument(CMUrlConstants.PARAM_RENDERID[0], renderID);
        request.setArgument(CMUrlConstants.PARAM_PAGE_INDEX[0], pageIndex);
        request.setArgument(CMUrlConstants.PARAM_OFFSET, offset);
        request.setArgument(CMUrlConstants.PARAM_COMPRESSED[0], compressed ? CMUrlConstants.VALUE_BOOLEAN_TRUE : CMUrlConstants.VALUE_BOOLEAN_FALSE);
        DBResponseHandler handler = new DBResponseHandler(bytes, offset);
        this.doServerCommand(request, handler, taskMonitor);
        VM.log(CLASS, 0, "finished downloading DB");
        return handler.getBytesReceived();
    }

    public IVMImage downloadImage(VMScene scene, String url) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request = request.copy(URI.parseURI(url, false), 1);
        ImageHandler handler = new ImageHandler(scene, this.imgFact, this);
        this.doServerCommand(request, handler, ITaskMonitor.NULL);
        return handler.getImage();
    }

    public boolean setDashboard(int renderID, String method) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_DASHBOARD);
        request.setArgument(CMUrlConstants.PARAM_RENDERID[0], renderID);
        request.setArgument(CMUrlConstants.PARAM_METHOD[0], method);
        XMLResponseHandler handler = new XMLResponseHandler();
        this.doServerCommand(request, handler, ITaskMonitor.NULL);
        return handler.success();
    }

    public PortalItem[] getFavourites() throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_FAVOURITE);
        request.setArgument(CMUrlConstants.PARAM_METHOD[0], "list");
        XMLBrowsePortalHandler handler = new XMLBrowsePortalHandler();
        this.doServerCommand(request, handler, ITaskMonitor.NULL);
        return handler.getPortalItems();
    }

    public PortalItem[] setFavourite(String storeID, String method) throws CMException {
        IServerRequest request = this.serverRequestFactory.createServerRequest(IServerRequestFactory.REQUEST_TYPE_GET);
        request.setArgument(CMUrlConstants.PARAM_OPERATION[0], CMUrlConstants.SERVLET_FAVOURITE);
        if (storeID.indexOf(47) == -1) {
            request.setArgument(CMUrlConstants.PARAM_RESOURCE[0], CMUrlHelper.encodeUrl(storeID));
        } else {
            request.setArgument(CMUrlConstants.PARAM_REPORT_PATH[0], CMUrlHelper.encodeUrl(storeID));
        }
        request.setArgument(CMUrlConstants.PARAM_METHOD[0], method);
        XMLBrowsePortalHandler handler = new XMLBrowsePortalHandler();
        this.doServerCommand(request, handler, ITaskMonitor.NULL);
        return handler.getPortalItems();
    }

    public void doServerCommand(IServerRequest request, XMLResponseHandler xmlResponseHandler, ITaskMonitor taskMonitor) throws CMException {
        MobXmlResponseHandler responseHandler = new MobXmlResponseHandler(this.serverResponseListener, this.xmlParserFactory, xmlResponseHandler);
        this.doServerCommand(request, responseHandler, taskMonitor);
    }

    public void dump(StringBuffer sb) {
        sb.append("CS " + this.connectionState + "; CFG " + this.completedFirstGet + "\n");
        if (this.logger != null) {
            this.logger.dump(sb);
        }
    }

    private void doServerCommand(IServerRequest originalRequest, IRecoverableResponseHandler clientHandler, ITaskMonitor taskMonitor) throws CMException {
        IServerRequest request = originalRequest;
        if (taskMonitor == null) {
            VM.log(CLASS, 0, "taskmonitor is null for request " + request.toString());
            taskMonitor = ITaskMonitor.NULL;
        }
        if (!this.completedFirstGet && request.getRequestMethod() == IServerRequestFactory.REQUEST_TYPE_POST) {
            this.getAbout(taskMonitor, false);
            request = request.copy(this.options.getEffectiveServerUri(), 3);
            this.completedFirstGet = true;
        }
        int urlRepeatCount = 0;
        while (true) {
            boolean online = false;
            IServerResponse response = null;
            try {
                if (this.serverRequestModifiers != null) {
                    for (int i = 0; i < this.serverRequestModifiers.length; ++i) {
                        this.serverRequestModifiers[i].modify(request);
                    }
                }
                String cookiesHeader = this.cookieManager.getCookiesHeader();
                request.setHeader("Cookie", cookiesHeader);
                Hashtable basicCredentials = this.options.getCredentials("HTTP-BASIC", false);
                if (basicCredentials != null) {
                    String domain = (String)basicCredentials.get("d");
                    String c = "";
                    if (domain != null && domain.length() > 0) {
                        c = c + domain;
                        c = c + "\\";
                    }
                    c = c + (String)basicCredentials.get("u");
                    c = c + ":";
                    c = c + (String)basicCredentials.get("p");
                    byte[] bytes = c.getBytes();
                    request.setHeader("Authorization", "Basic " + CMBase64.encodeBytes(bytes));
                }
                taskMonitor.setCancellableObject(request);
                response = request.execute(this.options, this.logger);
                taskMonitor.setCancellableObject(ICancellable.NULL);
                taskMonitor.throwIfCancelled();
                String[] cookiesSet = response.getCookies();
                for (int setCookiesIdx = 0; setCookiesIdx < cookiesSet.length; ++setCookiesIdx) {
                    int eql;
                    int sep = cookiesSet[setCookiesIdx].indexOf(";");
                    if (sep > -1) {
                        cookiesSet[setCookiesIdx] = cookiesSet[setCookiesIdx].substring(0, sep);
                    }
                    if ((eql = cookiesSet[setCookiesIdx].indexOf("=")) <= -1) continue;
                    String key = cookiesSet[setCookiesIdx].substring(0, eql);
                    String value = cookiesSet[setCookiesIdx].substring(eql + 1);
                    this.cookieManager.setCookie(key, value);
                    VM.log(CLASS, 0, "received cookie '" + key + "=" + value + "'");
                }
                IServerRequest newRequest = null;
                boolean handled = false;
                if (clientHandler.canHandle(response)) {
                    newRequest = clientHandler.handle(originalRequest, request, response, taskMonitor);
                    handled = true;
                    VM.log(CLASS, 1, "response handled by " + clientHandler.getClass().getName());
                } else {
                    for (int i = 0; i < this.recoverableResponseHandlers.length; ++i) {
                        if (this.recoverableResponseHandlers[i].canHandle(response)) {
                            newRequest = this.recoverableResponseHandlers[i].handle(originalRequest, request, response, taskMonitor);
                            handled = true;
                            VM.log(CLASS, 1, "response handled by " + this.recoverableResponseHandlers[i].getClass().getName());
                            break;
                        }
                        VM.log(CLASS, 0, "handler " + this.recoverableResponseHandlers[i].getClass().getName() + " declined to handle response");
                    }
                }
                online = true;
                if (handled) {
                    if (newRequest == null) {
                        VM.log(CLASS, 0, "server command completed successfully");
                        if (this.leaseKeyChecker != null) {
                            this.leaseKeyChecker.renewLease();
                        }
                        return;
                    }
                } else {
                    StringBuffer sb = new StringBuffer();
                    sb.append("couldn't handle response: response code ");
                    sb.append(response.getResponseCode());
                    sb.append(" starting with '");
                    sb.append(response.toString());
                    sb.append("'");
                    sb.append("\nResponse:\n" + this.readInputStreamAsString(response.getInputStream()));
                    VM.log(CLASS, 3, sb.toString());
                    throw new CMException(1157, sb.toString());
                }
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable sb) {
                        // empty catch block
                    }
                }
                if (++urlRepeatCount > 20) {
                    String message = "too many retries";
                    VM.log(CLASS, 3, message);
                    online = true;
                    throw new CMException(1103, message);
                }
                request = newRequest;
            }
            catch (CMException e) {
                if (e.getErrorCode() != 1502 && (e.getMessage() == null || e.getMessage().indexOf("IOCancelledException") == -1)) {
                    this.options.clearEffectiveServerUrl();
                }
                throw e;
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Exception exception) {}
                    response = null;
                }
                if (online && this.connectionState != 2) {
                    this.connectionState = 2;
                    this.eventManager.postEvent(new Event(this, 6));
                } else if (!online && this.connectionState != 1) {
                    this.connectionState = 1;
                    this.eventManager.postEvent(new Event(this, 6));
                }
            }
            taskMonitor.throwIfCancelled();
        }
    }

    private String readInputStreamAsString(InputStream in) {
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[1024];
        try {
            int n = 0;
            while ((n = in.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static interface ServerRequestModifier {
        public void modify(IServerRequest var1) throws CMException;
    }
}

