/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMVectorHelper;
import java.util.Vector;

public class RangeList {
    Vector ranges = new Vector();

    public boolean contains(int item) {
        int i = this.findRangeWithItem(item);
        return i != -1;
    }

    public void add(int item) {
        int i = this.findRangeWithItem(item);
        if (i != -1) {
            return;
        }
        i = this.findInsertionPoint(item);
        Range r = new Range(item, item);
        this.ranges.insertElementAt(r, i);
        this.compress();
    }

    public void add(int start, int stop) {
        if (stop < start) {
            int swap = start;
            start = stop;
            stop = swap;
        }
        int istart = this.findRangeWithItem(start);
        int istop = this.findRangeWithItem(stop);
        if (istart != -1 && istop != -1) {
            return;
        }
        int i = this.findInsertionPoint(start);
        Range r = new Range(start, stop);
        this.ranges.insertElementAt(r, i);
        this.compress();
    }

    public void remove(int item) {
        int i = this.findRangeWithItem(item);
        if (i == -1) {
            return;
        }
        Range r = this.getRange(i);
        if (r.start == item) {
            ++r.start;
        } else if (r.stop == item) {
            --r.stop;
        } else {
            Range before = new Range(r.start, item - 1);
            Range after = new Range(item + 1, r.stop);
            this.ranges.setElementAt(before, i);
            this.ranges.insertElementAt(after, i + 1);
        }
        r = this.getRange(i);
        if (r.start > r.stop) {
            this.ranges.removeElementAt(i);
        }
    }

    public String getString() {
        StringBuffer sb = new StringBuffer();
        int count = this.ranges.size();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            Range r = this.getRange(i);
            if (r.start == r.stop) {
                sb.append(Integer.toString(r.start));
                continue;
            }
            sb.append(Integer.toString(r.start));
            sb.append('-');
            sb.append(Integer.toString(r.stop));
        }
        return sb.toString();
    }

    public void parseString(String string) throws NumberFormatException {
        Range r;
        String section;
        Vector<Range> newRanges = new Vector<Range>();
        if (string == null || string.length() == 0) {
            this.ranges = newRanges;
            return;
        }
        int begin = 0;
        int end = string.indexOf(44, begin + 1);
        while (end != -1) {
            section = string.substring(begin, end);
            r = this.parseRange(section);
            if (r != null) {
                CMVectorHelper.growBeforeAppend(newRanges);
                newRanges.addElement(r);
            }
            begin = end + 1;
            end = string.indexOf(44, begin + 1);
        }
        if (begin < string.length() && (r = this.parseRange(section = string.substring(begin))) != null) {
            newRanges.addElement(r);
        }
        this.ranges = newRanges;
        this.compress();
    }

    private Range parseRange(String section) throws NumberFormatException {
        Range r;
        if (section == null) {
            return null;
        }
        if ((section = section.trim()).length() == 0) {
            return null;
        }
        int dash = section.indexOf(45);
        if (dash == -1) {
            int item = Integer.parseInt(section);
            r = new Range(item, item);
        } else {
            int start = Integer.parseInt(section.substring(0, dash));
            int stop = Integer.parseInt(section.substring(dash + 1));
            r = new Range(start, stop);
        }
        return r;
    }

    private Range getRange(int i) {
        return (Range)this.ranges.elementAt(i);
    }

    private int findRangeWithItem(int item) {
        int count = this.ranges.size();
        for (int i = 0; i < count; ++i) {
            Range r = this.getRange(i);
            if (item >= r.start && item <= r.stop) {
                return i;
            }
            if (r.start > item) break;
        }
        return -1;
    }

    private int findInsertionPoint(int item) {
        int i;
        int count = this.ranges.size();
        for (i = 0; i < count; ++i) {
            Range r = this.getRange(i);
            if (item <= r.start) break;
        }
        return i;
    }

    private void compress() {
        int count = this.ranges.size();
        Vector<Range> newRanges = new Vector<Range>(count);
        boolean compressed = false;
        if (count <= 1) {
            return;
        }
        Range lastRange = this.getRange(0);
        newRanges.addElement(lastRange);
        for (int i = 1; i < count; ++i) {
            Range thisRange = this.getRange(i);
            if (thisRange.start <= lastRange.stop + 1) {
                lastRange.stop = Math.max(lastRange.stop, thisRange.stop);
                compressed = true;
                continue;
            }
            newRanges.addElement(thisRange);
            lastRange = thisRange;
        }
        if (compressed) {
            this.ranges = newRanges;
        }
    }

    private class Range {
        public int start;
        public int stop;

        public Range(int start, int stop) {
            this.start = start;
            this.stop = stop;
        }
    }
}

