/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.common.CMServerHelper;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.IVMCache;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.Node;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMRender;
import com.cognos.mobile.vm.VMScene;
import com.cognos.mobile.vm.node.GroupNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ReportPrecacher {
    private static Class CLASS = ReportPrecacher.class;
    private final VMRender render;
    private final int cxViewport;
    private final int cyViewport;
    private final IVMPainter painter;
    private final IVMCache cache;
    private VMScene lastScene;

    public ReportPrecacher(VMRender render, int cxViewport, int cyViewport, IVMPainter painter, IVMCache cache) throws CMException {
        this.render = render;
        this.cxViewport = cxViewport;
        this.cyViewport = cyViewport;
        this.painter = painter;
        this.cache = cache;
    }

    public void dispose() {
        this.painter.dispose();
        if (this.lastScene != null) {
            this.lastScene.dispose();
            this.lastScene = null;
        }
    }

    public String precacheZoomImagesByPageSize(int pageIndex, String scenePath, int targetWidth, int targetImage, IClientApplication clientApplication, MobileServiceProxy mobileServiceProxy, int tileSize, int direction, ITaskMonitor taskMonitor) throws CMException {
        if (this.lastScene != null) {
            this.lastScene.dispose();
            this.lastScene = null;
        }
        this.lastScene = this.buildZoomSceneByPageSize(pageIndex, scenePath, targetWidth, clientApplication, mobileServiceProxy, tileSize, direction, taskMonitor);
        if (direction == 1) {
            return this.precacheNodes(pageIndex, scenePath, this.lastScene, targetWidth, targetImage);
        }
        return "";
    }

    public byte[] generateThumbnail(String fileName, int pageIndex, String scenePath, int targetWidth, int targetImage, IClientApplication clientApplication, MobileServiceProxy mobileServiceProxy, int tileSize, int direction, ITaskMonitor taskMonitor) throws CMException {
        int imageType;
        String ext;
        if (this.lastScene != null) {
            this.lastScene.dispose();
            this.lastScene = null;
        }
        if ((ext = CMPathHelper.getPathExt(fileName).toLowerCase()).equals(".png")) {
            imageType = 1;
        } else if (ext.equals(".jpg")) {
            imageType = 2;
        } else if (ext.equals(".jpeg")) {
            imageType = 2;
        } else {
            VM.log(CLASS, 2, "invalid image extension: " + ext);
            imageType = 1;
        }
        this.lastScene = this.buildZoomSceneByPageSize(pageIndex, scenePath, targetWidth, clientApplication, mobileServiceProxy, tileSize, direction, taskMonitor);
        Node node = this.lastScene.getRootNode();
        if (node == null) {
            return null;
        }
        IVMImage zoomImage = null;
        try {
            zoomImage = node.buildZoomImageIfNecessary(this.painter, targetWidth);
        }
        catch (Exception ex) {
            VM.log(CLASS, 3, "failed to build thumbnail for render " + this.render.getMeta().renderID, ex);
        }
        if (zoomImage == null) {
            VM.log(CLASS, 3, "failed to build thumbnail for render " + this.render.getMeta().renderID);
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        zoomImage.onImageSaveEncodedImage(imageType, baos);
        try {
            baos.flush();
            byte[] resultImageAsRawBytes = baos.toByteArray();
            baos.close();
            return resultImageAsRawBytes;
        }
        catch (IOException e) {
            throw new CMException(2008, "error converting image to byte array");
        }
    }

    public String precacheZoomImagesByZoomLevel(int pageIndex, String scenePath, int zoomLevel, int targetImage, IClientApplication clientApplication, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        if (this.lastScene != null) {
            this.lastScene.dispose();
            this.lastScene = null;
        }
        this.lastScene = this.buildZoomSceneByZoomLevel(pageIndex, scenePath, zoomLevel, clientApplication, mobileServiceProxy, tileSize, taskMonitor);
        int pageWidth = this.lastScene.getLastZoomPageWidth();
        return this.precacheNodes(pageIndex, scenePath, this.lastScene, pageWidth, targetImage);
    }

    public VMScene getLastScene() {
        return this.lastScene;
    }

    private VMScene buildZoomSceneByPageSize(int pageIndex, String scenePath, int targetWidth, IClientApplication clientApplication, MobileServiceProxy mobileServiceProxy, int tileSize, int direction, ITaskMonitor taskMonitor) throws CMException {
        VMScene scene = this.render.buildSceneFromScenePath(pageIndex, scenePath, this.cxViewport, this.cyViewport, this.painter, null, clientApplication, this.cache, taskMonitor);
        scene.zoomSceneByPageSize(this.painter, targetWidth, mobileServiceProxy, tileSize, direction, taskMonitor);
        return scene;
    }

    private VMScene buildZoomSceneByZoomLevel(int pageIndex, String scenePath, int zoomLevel, IClientApplication clientApplication, MobileServiceProxy mobileServiceProxy, int tileSize, ITaskMonitor taskMonitor) throws CMException {
        VMScene scene = this.render.buildSceneFromScenePath(pageIndex, scenePath, this.cxViewport, this.cyViewport, this.painter, null, clientApplication, this.cache, taskMonitor);
        scene.zoomSceneByZoomLevel(this.painter, zoomLevel, mobileServiceProxy, tileSize, taskMonitor);
        return scene;
    }

    private String precacheNodes(int pageIndex, String scenePath, VMScene scene, int targetWidth, int targetImage) {
        String nodePath;
        StringBuffer nodePaths = new StringBuffer();
        for (int i = 0; i < scene.getSelection().getSelectableCount(); ++i) {
            Node node = this.selectChildIfRequired(scene.getSelection().getSelectable(i));
            String nodePath2 = this.precacheNode(node, pageIndex, scenePath, targetWidth, targetImage);
            if (nodePath2 == null) continue;
            if (nodePaths.length() > 0) {
                nodePaths.append(",");
            }
            nodePaths.append(nodePath2);
        }
        Node node = scene.getRootNode();
        if (!node.isSelectable() && (nodePath = this.precacheNode(node, pageIndex, scenePath, targetWidth, targetImage)) != null) {
            if (nodePaths.length() > 0) {
                nodePaths.append(",");
            }
            nodePaths.append(nodePath);
        }
        return nodePaths.toString();
    }

    private Node selectChildIfRequired(Node parent) {
        if (parent.getType() == 4 && (((GroupNode)parent).getGroupType() == 5 || ((GroupNode)parent).getGroupType() == 4) && parent.getChildCount() > 0) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                Node child = parent.getChild(i);
                if (child.getType() != 8) continue;
                return child;
            }
        }
        return parent;
    }

    public boolean precacheNode(String nodePath, int pageIndex, String scenePath, int targetWidth, int targetImage, IClientApplication clientApplication, MobileServiceProxy mobileServiceProxy, int tileSize, int direction, ITaskMonitor taskMonitor) throws CMException {
        Node node;
        if (this.lastScene == null) {
            this.lastScene = this.buildZoomSceneByPageSize(pageIndex, scenePath, targetWidth, clientApplication, mobileServiceProxy, tileSize, direction, taskMonitor);
        }
        if ((node = this.lastScene.getRootNode().findNodeFromNodePath(nodePath, 0)) == null) {
            return false;
        }
        this.precacheNode(node, pageIndex, scenePath, targetWidth, targetImage);
        return true;
    }

    private String precacheNode(Node node, int pageIndex, String scenePath, int targetWidth, int targetImage) {
        String nodePath = node.getNodePath();
        if (nodePath == null) {
            return null;
        }
        IVMImage zoomImage = null;
        try {
            zoomImage = node.buildZoomImageIfNecessary(this.painter, targetWidth);
        }
        catch (Exception ex) {
            VM.log(CLASS, 3, "failed to build zoom image for node " + nodePath, ex);
        }
        if (zoomImage == null) {
            VM.log(CLASS, 3, "failed to build zoom image for node " + nodePath);
            return null;
        }
        String fileName = CMServerHelper.buildZoomImageCacheFilename(this.render.getMeta().renderID, pageIndex, scenePath, nodePath, targetWidth, targetImage);
        this.cache.onCacheSaveImage(fileName, zoomImage);
        return nodePath;
    }
}

