/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

public class RingBuffer {
    private Object[] items;
    int head;
    int size;

    public RingBuffer(int maxCapacity) {
        this.items = new Object[maxCapacity];
        this.head = 0;
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int addHead(Object o) {
        if (this.size == 0) {
            this.head = 0;
            this.size = 1;
        } else {
            --this.head;
            if (this.head < 0) {
                this.head = this.items.length - 1;
            }
            if (this.size < this.items.length) {
                ++this.size;
            }
        }
        this.items[this.head] = o;
        return this.size;
    }

    public int addTail(Object o) {
        if (this.size == 0) {
            this.head = 0;
            this.size = 1;
        } else if (this.size == this.items.length) {
            this.head = (this.head + 1) % this.items.length;
        } else {
            ++this.size;
        }
        int tail = (this.head + this.size - 1) % this.items.length;
        this.items[tail] = o;
        return this.size;
    }

    public int removeHead() {
        if (this.size > 0) {
            this.items[this.head] = null;
            --this.size;
        }
        return this.size;
    }

    public int removeTail() {
        if (this.size > 0) {
            int tail = (this.head + this.size) % this.items.length;
            this.items[tail] = null;
            --this.size;
        }
        return this.size;
    }

    public Object elementAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("invalid index: " + index);
        }
        index = (this.head + index) % this.items.length;
        return this.items[index];
    }
}

