/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.vm.VMOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StreamHelper {
    public static Vector loadTextResource(InputStream in) throws IOException {
        Vector<String> renders = new Vector<String>();
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int count = -1;
        while ((count = in.read(b)) > 0) {
            baout.write(b, 0, count);
        }
        String contents = new String(baout.toByteArray(), "UTF-8");
        int start = -1;
        for (int i = 0; i < contents.length(); ++i) {
            if (contents.charAt(i) == '\n' || contents.charAt(i) == '\r') {
                if (start == -1) continue;
                renders.addElement(contents.substring(start, i));
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            renders.addElement(contents.substring(start, contents.length()));
        }
        return renders;
    }

    public static void saveAsProperties(Hashtable h, PrintStream out, String separator) {
        Enumeration keysEnum = h.keys();
        while (keysEnum.hasMoreElements()) {
            String value;
            String key = (String)keysEnum.nextElement();
            if (key == null || (value = (String)h.get(key)) == null) continue;
            out.println(key + separator + value);
        }
    }

    public static void loadOptionFromStream(InputStream is, VMOptions option) throws Exception {
        Hashtable p = StreamHelper.toHashtable(is);
        option.setServerUrl((String)p.get("ServerUrl"), false);
        option.setPageInitialZoom(Integer.parseInt((String)p.get("PageInitialZoom")));
        option.setTextInitialZoom(Integer.parseInt((String)p.get("TextInitialZoom")));
        option.setImageInitialZoom(Integer.parseInt((String)p.get("ImageInitialZoom")));
        option.setEmailMessage((String)p.get("EmailMessage"));
        option.setEmailSubject((String)p.get("EmailSubject"));
        option.setForceLocale((String)p.get("ForceLocale"));
        option.save();
    }

    private static Hashtable toHashtable(InputStream in) {
        Hashtable<String, String> p = new Hashtable<String, String>();
        try {
            Vector lines = StreamHelper.loadTextResource(in);
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.elementAt(i);
                String[] keyValue = CMStringHelper.split(line, '=', true);
                if (keyValue == null || keyValue.length != 2) continue;
                p.put(keyValue[0], keyValue[1]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }

    public static String getProperty(InputStream in, String key) {
        try {
            Vector lines = StreamHelper.loadTextResource(in);
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.elementAt(i);
                String[] keyValue = CMStringHelper.split(line, '=', true);
                if (keyValue == null || keyValue.length != 2 || !keyValue[0].equalsIgnoreCase(key)) continue;
                return keyValue[1];
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

