/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.IPersistenceStore;
import com.cognos.mobile.vm.VM;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;

public class TempStoreHelper {
    private static final Class CLASS = TempStoreHelper.class;

    public static void saveString(IPersistenceStore tmpStore, String tempPath, String content) {
        try {
            if (content == null || content.length() == 0) {
                return;
            }
            OutputStreamWriter writer = new OutputStreamWriter(tmpStore.create(tempPath, true), "UTF-8");
            writer.write(content);
            writer.close();
            VM.log(CLASS, 0, "saved string:" + content + " to: " + tempPath);
        }
        catch (Exception e) {
            VM.log(CLASS, 3, "failed to saveString for " + tempPath, e);
        }
    }

    public static String readString(IPersistenceStore tmpStore, String tempPath, boolean delete) throws IOException {
        int count;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream inStream = tmpStore.get(tempPath);
        if (inStream == null) {
            return null;
        }
        byte[] buffer = new byte[2048];
        while ((count = inStream.read(buffer)) > 0) {
            baos.write(buffer, 0, count);
        }
        String content = baos.toString("UTF-8");
        inStream.close();
        if (delete) {
            tmpStore.remove(tempPath);
        }
        VM.log(CLASS, 0, "read string:" + content + " from: " + tempPath);
        return content;
    }
}

