/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.vm.VM;
import java.util.Enumeration;
import java.util.Vector;

public class TimingStats {
    private static final Class CLASS = TimingStats.class;
    private static final Vector entries = new Vector();

    public static Event create(String task) {
        Event e = new Event(task);
        entries.addElement(e);
        return e;
    }

    public static void dump() {
        VM.log(CLASS, 3, "task - note, total time, time between steps");
        Enumeration e = entries.elements();
        while (e.hasMoreElements()) {
            Event ev = (Event)e.nextElement();
            Vector notes = ev.items;
            Entry ent = (Entry)notes.elementAt(0);
            VM.log(CLASS, 3, ev.task + " - " + ent.note + ", 0, 0");
            for (int i = 1; i < notes.size(); ++i) {
                ent = (Entry)notes.elementAt(i);
                VM.log(CLASS, 3, ev.task + " - " + ent.note + ", " + ev.getDelta(i, 0) + ", " + ev.getDelta(i, i - 1));
            }
            VM.log(CLASS, 3, e.nextElement().toString());
        }
    }

    public static class Event {
        private final String task;
        private final Vector items = new Vector();

        private Event(String task) {
            this.task = task;
        }

        public void add(String note) {
            this.items.addElement(new Entry(note));
        }

        public long getDelta(int i, int j) {
            if (j > i) {
                return ((Entry)this.items.elementAt(j)).time - ((Entry)this.items.elementAt(i)).time;
            }
            return ((Entry)this.items.elementAt(i)).time - ((Entry)this.items.elementAt(j)).time;
        }
    }

    private static class Entry {
        private final String note;
        private final long time;

        Entry(String note) {
            this.note = note;
            this.time = System.currentTimeMillis();
        }
    }
}

