/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.ITimer;
import com.cognos.mobile.common.ITooltipPainter;
import com.cognos.mobile.common.WordWrapper;
import com.cognos.mobile.vm.VMPoint;
import com.cognos.mobile.vm.VMRect;

public final class Tooltip {
    public static final int ALIGNMENT_TOP_LEFT = 1;
    public static final int ALIGNMENT_TOP_RIGHT = 2;
    public static final int ALIGNMENT_BOTTOM_LEFT = 3;
    public static final int ALIGNMENT_BOTTOM_RIGHT = 4;
    public static final int SPACER = 4;
    public static int CX_EDGE = 4;
    public static int CY_EDGE = 2;
    private final ITimer timer;
    private final WordWrapper wordWrapper;
    private ITooltipPainter painter;
    private int alignment;
    private VMRect bounds;
    private String[] paintLines;
    private VMRect paintRect;
    public static final int TOOLTIP_MILLIS_BEFORE_POP = 5000;

    public Tooltip(ITooltipPainter tooltipPainter, int alignment, ITimer timer) {
        this.painter = tooltipPainter;
        this.alignment = alignment;
        this.timer = timer;
        this.wordWrapper = new WordWrapper(tooltipPainter);
    }

    public Tooltip(ITimer timer) {
        this(null, 4, timer);
    }

    public final void setPainter(ITooltipPainter ttp) {
        this.painter = ttp;
    }

    public final void setAlignment(int a) {
        this.alignment = a;
    }

    public void dispose() {
        this.timer.cancel();
    }

    public void setBounds(int x, int y, int cx, int cy) {
        this.bounds = new VMRect(x, y, cx, cy);
    }

    public VMRect getBounds() {
        return this.bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMessage(Object context, String message, long millisBeforePop) {
        Tooltip tooltip = this;
        synchronized (tooltip) {
            String[] lines = this.wordWrapper.wrapText(context, message, this.bounds.cx, this.bounds.cy);
            VMRect rect = this.computeRect(context, lines);
            if (rect == null) {
                return;
            }
            this.hideMessage(context);
            this.timer.cancel();
            this.paintLines = lines;
            this.paintRect = rect;
            this.paint(context);
            if (millisBeforePop != 0L && message != null) {
                this.timer.schedule(new HideMessageTimerTask(this, context, lines.hashCode()), millisBeforePop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideMessage(Object context) {
        Tooltip tooltip = this;
        synchronized (tooltip) {
            if (this.paintRect != null && this.paintLines != null) {
                this.painter.eraseTooltip(context, this.paintRect);
            }
            this.paintRect = null;
            this.paintLines = null;
        }
    }

    public VMRect getRect() {
        return this.paintRect;
    }

    public void paint(Object context) {
        if (this.paintRect != null && this.paintLines != null) {
            this.painter.paintTooltip(context, this.paintRect, this.paintLines);
        }
    }

    protected int getLinesHashCode() {
        if (this.paintLines == null) {
            return 0;
        }
        return this.paintLines.hashCode();
    }

    private VMRect computeRect(Object context, String[] lines) {
        if (lines == null || lines.length == 0) {
            return null;
        }
        VMRect rect = new VMRect();
        int cx = 0;
        int cy = 0;
        for (int i = 0; i < lines.length; ++i) {
            VMPoint lineSize = this.painter.measureText(context, lines[i]);
            cx = Math.max(cx, lineSize.x);
            cy += lineSize.y;
        }
        rect.cx = cx += 2 * CX_EDGE;
        rect.cy = cy += 2 * CY_EDGE;
        VMRect bounds = this.getBounds();
        switch (this.alignment) {
            case 1: {
                rect.x = bounds.x;
                rect.y = bounds.y;
                break;
            }
            case 2: {
                rect.x = bounds.x + Math.max(bounds.cx - cx, 0);
                rect.y = bounds.y;
                break;
            }
            case 3: {
                rect.x = bounds.x;
                rect.y = bounds.y + Math.max(bounds.cy - cy, 0);
                break;
            }
            case 4: {
                rect.x = bounds.x + Math.max(bounds.cx - cx, 0);
                rect.y = bounds.y + Math.max(bounds.cy - cy, 0);
            }
        }
        rect.x -= 4;
        rect.y += 4;
        return rect;
    }

    class HideMessageTimerTask
    implements Runnable {
        private Tooltip tooltip;
        private Object context;
        private int hashCode;

        public HideMessageTimerTask(Tooltip tooltip, Object context, int hashCode) {
            this.tooltip = tooltip;
            this.context = context;
            this.hashCode = hashCode;
        }

        @Override
        public void run() {
            if (this.tooltip.getLinesHashCode() == this.hashCode) {
                this.tooltip.hideMessage(this.context);
            }
        }
    }

    public static interface IShowThem {
        public void showTooltip(String var1);
    }
}

