/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.ITextSizer;
import com.cognos.mobile.common.IntVector;
import com.cognos.mobile.vm.VM;

public class WordWrapper {
    private final Class CLASS = WordWrapper.class;
    private final ITextSizer textMetrics;

    public WordWrapper(ITextSizer textMetrics) {
        this.textMetrics = textMetrics;
    }

    public String[] wrapText(Object context, String text, int maxWidth, int maxHeight) {
        return this.wrapText(context, text, maxWidth, maxHeight, false);
    }

    public String[] wrapText(Object context, String text, int maxWidth, int maxHeight, boolean allowGrow) {
        if (text == null || this.textMetrics.getWidth(context, text) <= maxWidth && text.indexOf(10) < 0) {
            return new String[]{text};
        }
        int[] wrapPos = this.generateWrapPos(context, text, maxWidth, maxHeight, allowGrow);
        return WordWrapper.generateWrappedStrings(context, wrapPos, text);
    }

    public int[] generateWrapPos(Object context, String text, int maxWidth, int maxHeight, boolean allowGrow) {
        int[] wpos;
        int usedLength = 0;
        int totalLength = text == null ? 0 : text.length();
        IntVector wrapPos = new IntVector(2);
        if (allowGrow) {
            maxWidth = this.calcFinalWidth(context, text, maxWidth, maxHeight);
        }
        usedLength = this.generateWrapPos(context, text, maxWidth, maxHeight, totalLength, usedLength, wrapPos);
        if (wrapPos.length() > 0) {
            int lastlineEndIndex = wrapPos.length() - 1;
            int lastLineStartPos = wrapPos.get(lastlineEndIndex - 1);
            int lastLineEndPos = wrapPos.get(lastlineEndIndex);
            String lastLine = text.substring(lastLineStartPos, lastLineEndPos);
            int ellipsisPos = -1;
            String ellipsis = "...";
            int ellipsisWidth = this.textMetrics.getWidth(context, ellipsis);
            if (usedLength < totalLength && (allowGrow || maxWidth >= ellipsisWidth && !allowGrow)) {
                int lastLineWidth = this.textMetrics.getWidth(context, lastLine);
                if (lastLineWidth + ellipsisWidth <= maxWidth) {
                    ellipsisPos = lastLineEndPos;
                } else if (lastLine.length() > ellipsis.length()) {
                    if (maxWidth - ellipsis.length() > lastLine.length()) {
                        ellipsisPos = lastLineEndPos + 1;
                    } else {
                        ellipsisPos = lastLineEndPos - (ellipsis.length() - (maxWidth - lastLine.length()));
                        wrapPos.set(lastlineEndIndex, ellipsisPos);
                    }
                } else if (wrapPos.length() > 3) {
                    ellipsisPos = lastLineStartPos;
                    wrapPos.set(lastlineEndIndex, -1);
                    wrapPos.set(lastlineEndIndex - 1, -1);
                }
            }
            wpos = new int[wrapPos.length() + 1];
            wpos[0] = ellipsisPos;
            for (int i = 0; i < wrapPos.length(); ++i) {
                wpos[i + 1] = wrapPos.get(i);
            }
        } else {
            wpos = new int[]{};
        }
        return wpos;
    }

    private int generateWrapPos(Object context, String text, int maxWidth, int maxHeight, int totalLength, int usedLength, IntVector wrapPos) {
        WrapPoint wp1;
        WrapPoint wp = new WrapPoint();
        int height = 0;
        for (int start = 0; start < totalLength; start += wp1.endIndex + 1) {
            while (start < totalLength && this.isWhitespace(text.charAt(start))) {
                if (start == totalLength - 1) {
                    ++usedLength;
                }
                ++start;
            }
            if (start >= totalLength) break;
            wp.wrappedLine = start == 0 ? text : text.substring(start);
            wp1 = this.findWrapPoint(wp, context, maxWidth, wp.wrappedLine, true);
            if (wp1 == null) {
                wp1 = this.findWrapPoint(wp, context, maxWidth, wp.wrappedLine, false);
            }
            height += wp1.size_y;
            wrapPos.add(start);
            wrapPos.add(start + wp1.endIndex + 1);
            usedLength = start + wp1.endIndex + 1;
        }
        return usedLength;
    }

    private int calcFinalWidth(Object context, String text, int maxWidth, int maxHeight) {
        if (text == null || text.length() == 0) {
            return maxWidth;
        }
        String[] words = CMStringHelper.parseWords(text);
        int widestWidth = 0;
        int widestWordIndex = 0;
        for (int i = 0; i < words.length; ++i) {
            if (words[i].length() < widestWidth) continue;
            widestWordIndex = i;
            widestWidth = words[i].length();
        }
        return Math.max(this.textMetrics.getWidth(context, words[widestWordIndex]), maxWidth);
    }

    public static String[] generateWrappedStrings(Object context, int[] wrapPos, String text) {
        String[] wrapped;
        if (wrapPos.length > 0) {
            int ellipsisPos = wrapPos[0];
            String ellipsis = "...";
            wrapped = new String[(wrapPos.length - 1) / 2];
            int lineStart = 0;
            int lineEnd = 0;
            int wrappedCtr = 0;
            for (int i = 1; i < wrapPos.length; ++i) {
                if (i % 2 > 0) {
                    lineStart = wrapPos[i];
                    continue;
                }
                lineEnd = wrapPos[i];
                if (lineEnd == -1) continue;
                wrapped[wrappedCtr++] = text.substring(lineStart, lineEnd);
            }
            if (ellipsisPos > 0) {
                if (wrapPos[wrapPos.length - 1] == -1) {
                    wrapped[wrapped.length - 1] = ellipsis;
                } else {
                    int n = wrapped.length - 1;
                    wrapped[n] = wrapped[n] + ellipsis;
                }
            }
        } else {
            wrapped = new String[]{};
        }
        return wrapped;
    }

    private final WrapPoint findWrapPoint(WrapPoint wp, Object context, int maxWidth, String line, boolean breakOnlyAtWords) {
        int len;
        for (len = line.length(); len > 0 && this.isWhitespace(line.charAt(len - 1)); --len) {
        }
        line = line.substring(0, len);
        WrapPoint wpTemp = new WrapPoint();
        int lastEndIndex = -1;
        for (int i = 0; i < line.length(); ++i) {
            if (this.isWhitespace(line.charAt(i)) || breakOnlyAtWords && i < line.length() - 1 && !this.isWhitespace(line.charAt(i + 1))) continue;
            wpTemp.wrappedLine = line.substring(0, i + 1);
            wpTemp.size_x = this.textMetrics.getWidth(context, wpTemp.wrappedLine);
            if (wpTemp.size_x > maxWidth || i == line.length() - 1) {
                int newLinePos = wp.wrappedLine.indexOf(10);
                if (newLinePos >= 0) {
                    wp.endIndex = newLinePos - 1;
                } else if (wpTemp.size_x > maxWidth) {
                    if (lastEndIndex == -1) {
                        int wpEndIndex = 0;
                        int guess = wpTemp.wrappedLine.length() * maxWidth / wpTemp.size_x;
                        wpTemp.wrappedLine = wpTemp.wrappedLine.substring(0, guess);
                        wpTemp.size_x = this.textMetrics.getWidth(context, wpTemp.wrappedLine);
                        String aLine = wpTemp.wrappedLine;
                        int aLen = aLine.length();
                        if (aLen > 0) {
                            if (wpTemp.size_x == maxWidth) {
                                wpEndIndex = aLen - 1;
                            } else if (wpTemp.size_x > maxWidth) {
                                for (int j = aLen - 2; j >= 0; --j) {
                                    wpTemp.wrappedLine = aLine.substring(0, j + 1);
                                    wpTemp.size_x = this.textMetrics.getWidth(context, wpTemp.wrappedLine);
                                    if (wpTemp.size_x > maxWidth) continue;
                                    wpEndIndex = j;
                                    break;
                                }
                            } else {
                                for (int j = aLen; j < line.length(); ++j) {
                                    wpTemp.wrappedLine = line.substring(0, j + 1);
                                    wpTemp.size_x = this.textMetrics.getWidth(context, wpTemp.wrappedLine);
                                    if (wpTemp.size_x < maxWidth) continue;
                                    wpEndIndex = wpTemp.size_x == maxWidth ? j : j - 1;
                                    break;
                                }
                            }
                        }
                        wp.endIndex = wpEndIndex;
                    } else {
                        wp.endIndex = lastEndIndex;
                    }
                } else {
                    wp.endIndex = i;
                }
                wp.size_y = this.textMetrics.getHeight(context, wp.wrappedLine);
                return wp;
            }
            wp = wpTemp.copy();
            wpTemp.clear();
            lastEndIndex = i;
        }
        if (breakOnlyAtWords) {
            VM.log(this.CLASS, 2, "not enough width to wrap a single word");
            return null;
        }
        VM.log(this.CLASS, 2, "not enough width to wrap even a single character");
        if (line.equals("\n")) {
            wp.wrappedLine = "";
            wp.size_x = 0;
            wp.endIndex = 1;
        } else {
            wp.wrappedLine = line.substring(0, 1);
            wp.size_x = this.textMetrics.getWidth(context, wp.wrappedLine);
        }
        wp.size_y = this.textMetrics.getHeight(context, wp.wrappedLine);
        return wp;
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\r' || c == '\t' || c == '\f' || c == '\n';
    }

    private static final class WrapPoint {
        public int endIndex;
        public String wrappedLine;
        public int size_x;
        public int size_y;

        private WrapPoint() {
        }

        public WrapPoint copy() {
            WrapPoint temp = new WrapPoint();
            temp.endIndex = this.endIndex;
            temp.wrappedLine = this.wrappedLine;
            temp.size_x = this.size_x;
            temp.size_y = this.size_y;
            return temp;
        }

        public void clear() {
            this.endIndex = 0;
            this.wrappedLine = null;
            this.size_x = 0;
            this.size_y = 0;
        }
    }
}

