/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.compatibility;

import com.cognos.mobile.common.CMStringHelper;

public class VersionRange {
    private static final int MAX_SEGMENT_WIDTH = 4;
    private String lowRange;
    private String highRange;
    private boolean fullRange;

    public VersionRange(String versionLow, String versionHigh) {
        this.fullRange = versionLow.length() == 0 && versionHigh.length() == 0;
        this.lowRange = this.normalizeVersion(versionLow);
        this.highRange = this.normalizeVersion(versionHigh);
    }

    protected boolean inRange(String version) {
        if (version != null) {
            if (this.fullRange) {
                return true;
            }
            String normalizedVersion = this.normalizeVersion(version);
            if (this.lowRange.compareTo(normalizedVersion) <= 0 && this.highRange.compareTo(normalizedVersion) >= 0) {
                return true;
            }
        }
        return false;
    }

    private String normalizeVersion(String version) {
        String[] splitVersion = CMStringHelper.split(version, '.', false);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < splitVersion.length; ++i) {
            for (int j = splitVersion[i].length(); j < 4; ++j) {
                sb.append('0');
            }
            sb.append(splitVersion[i]);
        }
        return sb.toString();
    }
}

