/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.compiler;

import com.cognos.mobile.c8.IMultiPartStreamProvider;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.common.IHTTPListener;
import com.cognos.mobile.common.IInputStreamFactory;
import com.cognos.mobile.common.IPersistenceStore;
import com.cognos.mobile.standardedition.SEAwtHelper;
import com.cognos.mobile.vm.VM;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class ImageTranscoder {
    private static Class CLASS = ImageTranscoder.class;
    private final IInputStreamFactory inFact;
    private final IPersistenceStore tmpStore;
    private final IMultiPartStreamProvider imageProvider;

    public ImageTranscoder(IInputStreamFactory inFact, IPersistenceStore tmpStore) {
        this.inFact = inFact;
        this.tmpStore = tmpStore;
        this.imageProvider = null;
    }

    public ImageTranscoder(IInputStreamFactory inFact, IPersistenceStore tmpStore, IMultiPartStreamProvider imageProvider) {
        this.inFact = inFact;
        this.tmpStore = tmpStore;
        this.imageProvider = imageProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getImageStream(String imageUrl, String parentPath, Hashtable cookies, IHTTPListener httpListener) {
        InputStream in;
        block11: {
            VM.log(CLASS, 0, "transcoding imageUrl: " + imageUrl);
            in = null;
            File tempF = null;
            boolean deleteTempF = true;
            try {
                if (imageUrl.startsWith("cid:") && this.imageProvider != null) {
                    VM.log(CLASS, 0, "getting image from image Provider, cid: " + imageUrl);
                    in = this.imageProvider.getImageStream(imageUrl);
                    break block11;
                }
                if (imageUrl.startsWith("http:") || imageUrl.startsWith("https:")) {
                    VM.log(CLASS, 0, "downloading image url: " + imageUrl);
                    in = this.downloadUrl(imageUrl, cookies, httpListener);
                    break block11;
                }
                VM.log(CLASS, 0, "downloading image file: " + imageUrl);
                deleteTempF = false;
                String path = this.expandPath(imageUrl, parentPath);
                tempF = new File(path);
                if (tempF.exists() && tempF.length() > 0L) {
                    in = new BufferedInputStream(new FileInputStream(tempF));
                    break block11;
                }
                if (tempF.exists()) {
                    VM.log(CLASS, 0, "temp file: " + tempF.getAbsolutePath() + " length: " + tempF.length());
                    tempF.delete();
                } else {
                    VM.log(CLASS, 0, "temp file: " + tempF.getAbsolutePath() + " does not exist.");
                }
                InputStream inputStream = null;
                return inputStream;
            }
            catch (Exception ex) {
                VM.log(CLASS, 0, "failed to obtain image: " + ex.toString());
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                if (tempF != null && deleteTempF) {
                    tempF.delete();
                }
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transcodeImage(String imageUrl, String parentPath, Hashtable cookies, int maxImageArea, int imageFormat) {
        VM.log(CLASS, 0, "transcoding imageUrl: " + imageUrl);
        InputStream in = null;
        File tempF = null;
        boolean deleteTempF = true;
        try {
            String path;
            OutputStream out;
            in = this.getImageStream(imageUrl, parentPath, cookies, null);
            if (in != null && SEAwtHelper.transcodeAndResizeImage(in, out = this.tmpStore.create(path = this.tmpStore.createTempPath("transcoded_tmp_", ".png", "mobile", true), false), maxImageArea, imageFormat)) {
                String string = path;
                return string;
            }
        }
        catch (Exception ex) {
            VM.log(CLASS, 3, "failed to read image: " + ex.toString());
        }
        finally {
            if (tempF != null && deleteTempF) {
                tempF.delete();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {
                VM.log(CLASS, 0, ioe);
            }
        }
        return null;
    }

    private InputStream downloadUrl(String url, Hashtable<String, String> cookies, IHTTPListener httpListener) throws CMException {
        VM.log(CLASS, 0, "downloading url: " + url);
        InputStream in = null;
        try {
            int numRead;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            in = this.inFact.create(url, null, cookies, null, null, httpListener);
            int numWritten = 0;
            while ((numRead = in.read(buffer)) > 0) {
                out.write(buffer, 0, numRead);
                numWritten += numRead;
            }
            VM.log(CLASS, 1, "downloaded " + numWritten + " bytes from url: " + url);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException ex) {
            throw new CMException(1005, new String[]{url}, (Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {
                VM.log(CLASS, 0, ioe);
            }
        }
    }

    private String expandPath(String path, String parentPath) {
        if (path.startsWith("file://")) {
            path = path.substring(7);
        } else if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        CMPathHelper.SplitPathResult pathSplit = CMPathHelper.splitPath(path);
        if (pathSplit.dir == null && parentPath != null) {
            CMPathHelper.SplitPathResult parentPathSplit = CMPathHelper.splitPath(parentPath);
            path = parentPathSplit.dir == null ? pathSplit.file : parentPathSplit.dir + pathSplit.file;
        }
        return path;
    }
}

