/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.compiler;

import com.cognos.mobile.assembler.ASMAssembler;
import com.cognos.mobile.c8.IC8ReportRunnerService;
import com.cognos.mobile.c8.IMultiPartStreamProvider;
import com.cognos.mobile.c8.IReportOutputProcessor;
import com.cognos.mobile.c8.IRunResponse;
import com.cognos.mobile.c8.RunResponse;
import com.cognos.mobile.common.BuxPromptHelper;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.common.CMPathHelper2;
import com.cognos.mobile.common.IInputStreamFactory;
import com.cognos.mobile.common.IPersistenceStore;
import com.cognos.mobile.common.ImageInfo;
import com.cognos.mobile.common.TempStoreHelper;
import com.cognos.mobile.compiler.ImageTranscoder;
import com.cognos.mobile.database.IRenderRow;
import com.cognos.mobile.database.RenderRow;
import com.cognos.mobile.generator.Document;
import com.cognos.mobile.generator.IElementFactory;
import com.cognos.mobile.generator.IGenerator;
import com.cognos.mobile.generator.IReport;
import com.cognos.mobile.generator.MultiDocument;
import com.cognos.mobile.generator.input.ldx.LdxReport;
import com.cognos.mobile.generator.input.mht.MhtReport;
import com.cognos.mobile.generator.input.rsvp_html.RsvpHtmlReport;
import com.cognos.mobile.generator.input.viewer_html.ViewerHtmlReport;
import com.cognos.mobile.generator.output.html.HtmlDocument;
import com.cognos.mobile.generator.output.html.HtmlElementFactory;
import com.cognos.mobile.generator.output.html.HtmlGenerator;
import com.cognos.mobile.generator.output.vm.VmDocument;
import com.cognos.mobile.generator.output.vm.VmElementFactory;
import com.cognos.mobile.generator.output.vm.VmGenerator;
import com.cognos.mobile.vm.IVMWriter;
import com.cognos.mobile.vm.VM;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import org.codehaus.groovy.control.CompilationFailedException;

public class ReportCompiler {
    private static final Class<ReportCompiler> CLASS = ReportCompiler.class;
    public static final int NUM_OUTPUTS = 3;
    public static final int NULL_RENDER_PAGECOUNT = -1;
    public static final String INPUTTYPE_RAW = "rawXML";
    public static final String INPUTTYPE_LDX = "layoutDataXML";
    public static final String INPUTTYPE_LDX_PAGED = "pagedLayoutDataXML";
    public static final String INPUTTYPE_MHT = "MHT";
    public static final String INPUTTYPE_HTML = "HTML";
    public static final String INPUTTYPE_VIEWER_HTML = "VIEWER_HTML";
    public static final String INPUTTYPE_RSVP_HTML = "RSVP_HTML";
    public static final String INPUTTYPE_PDF = "PDF";
    public static final String OUTPUTTYPE_VM = "vm";
    public static final String OUTPUTTYPE_HTML = "html";
    public static final String OUTPUTTYPE_VIEWER_HTML = "viewer_html";
    public static final String OUTPUTTYPE_RSVP_HTML = "rsvp_html";
    public static final String OUTPUTTYPE_RES = "res";
    public static final String RSVP_OUTPUTTYPE_HTML = "HTML";
    public static final String RSVP_OUTPUTTYPE_SCHEDHTML = "SCHEDHTML";
    public static final String RSVP_OUTPUTTYPE_RAWXML = "rawXML";
    public static final String RSVP_OUTPUTTYPE_LDX = "layoutDataXML";
    public static final String RSVP_OUTPUTTYPE_LDX_PAGED = "pagedLayoutDataXML";
    public static final String RSVP_OUTPUTTYPE_PDF = "PDF";
    public static final String TEMP_SUFFIX_HTML = ".html";
    public static final String TEMP_SUFFIX_MHT = ".mht";
    public static final String TEMP_SUFFIX_PDF = ".pdf";
    public static final String TEMP_SUFFIX_LDX = ".ldx";
    public static final String TEMP_SUFFIX_REPORTINFO = ".rinfo";
    public static final String TEMP_SUFFIX_VM = ".vm";
    public static final String TEMP_SUFFIX_RAW = ".raw.xml";
    public static final String TEMP_SUFFIX_RSVPHTML = ".rsvp.html";
    public static final String TEMP_SUFFIX_RSVPSCHEDHTML = ".rsvp.sched.html";
    public static final int TYPE_INPUT = 0;
    public static final int TYPE_OUTPUT = 1;
    public static final int MAXIMAGESIZE_DEFAULT = 150000;
    public static final String IROT_REPORT_SPEC_PATH = "original-spec.xml";
    public static final String IROT_ASTRO_ACTION = "cogmob://com.ibm.cogmob.launchAstro";
    private String m_inputType;
    private IReport m_report;
    private VmGenerator vmGenerator;
    private HtmlGenerator htmlGenerator;
    private boolean m_testing = false;
    private IInputStreamFactory m_inFact = null;
    private IPersistenceStore m_tmpStore = null;
    private ImageTranscoder m_transcoder = null;
    private int m_maxImageSize = 150000;
    private int m_preferredImageFormat = 1;
    private Hashtable<String, String> m_cookies = null;
    private IVMWriter m_writer = null;
    private IC8ReportRunnerService m_reportRunnerService = null;
    private String c8DispatcherUrl;
    private IReportOutputProcessor reportProcessorHost;
    private String portalItemName;
    private boolean hasNextPage;
    private Hashtable widgetState;
    private Hashtable widgetPageIndex;
    private Hashtable widgetHasNextPage;
    private SimpleTemplateEngine gte;

    public ReportCompiler(String inputType) {
        this.m_inputType = inputType;
        this.m_testing = true;
    }

    public ReportCompiler(String inputType, String portalItemName, int portalItemType, IInputStreamFactory inFact, IPersistenceStore tmpStore, Hashtable<String, String> cookies, IVMWriter writer, IMultiPartStreamProvider imageStream, int maxImageSize, boolean testing, String c8DispatcherUrl, String c8TempDirectory) {
        this.m_inputType = inputType;
        this.m_inFact = inFact;
        this.m_tmpStore = tmpStore;
        this.m_transcoder = imageStream == null ? new ImageTranscoder(inFact, tmpStore) : new ImageTranscoder(inFact, tmpStore, imageStream);
        this.m_maxImageSize = maxImageSize;
        this.m_cookies = cookies;
        this.m_writer = writer;
        this.m_testing = testing;
        this.c8DispatcherUrl = c8DispatcherUrl;
        this.portalItemName = portalItemName;
        final String dir = c8TempDirectory;
        this.gte = new SimpleTemplateEngine(){

            public Template createMobileTemplate(String path) throws CompilationFailedException, ClassNotFoundException, IOException {
                return super.createTemplate((Reader)new FileReader(dir + "/../webapps/p2pd/WEB-INF/scripts/templates/" + path));
            }

            public Template createTemplate(File f) {
                try {
                    return super.createTemplate((Reader)new FileReader(dir + "/../webapps/p2pd/WEB-INF/scripts/templates/" + f.getName()));
                }
                catch (Exception e) {
                    VM.log(CLASS, 3, "Couldn't load template: " + dir + "/../webapps/p2pd/WEB-INF/scripts/templates/" + f.getName());
                    return null;
                }
            }
        };
    }

    public ImageTranscoder getImageTranscoder() {
        return this.m_transcoder;
    }

    public void setReportRunnerService(IC8ReportRunnerService reportRunnerService) {
        this.m_reportRunnerService = reportRunnerService;
    }

    public ReportCompiler(IInputStreamFactory inFact, IPersistenceStore tmpStore) {
        this.m_inFact = inFact;
        this.m_tmpStore = tmpStore;
        this.m_transcoder = new ImageTranscoder(inFact, tmpStore);
    }

    public static String getTempFileSuffix(int type, String typeText) {
        if (type == 1) {
            if (OUTPUTTYPE_RES.equals(typeText)) {
                return TEMP_SUFFIX_MHT;
            }
            if (OUTPUTTYPE_HTML.equals(typeText) || OUTPUTTYPE_VIEWER_HTML.equals(typeText) || OUTPUTTYPE_RSVP_HTML.equals(typeText)) {
                return TEMP_SUFFIX_HTML;
            }
            return TEMP_SUFFIX_VM;
        }
        if (INPUTTYPE_MHT.equals(typeText)) {
            return TEMP_SUFFIX_MHT;
        }
        if ("layoutDataXML".equals(typeText) || "pagedLayoutDataXML".equals(typeText)) {
            return TEMP_SUFFIX_LDX;
        }
        if (INPUTTYPE_MHT.equals(typeText)) {
            return TEMP_SUFFIX_MHT;
        }
        if (INPUTTYPE_VIEWER_HTML.equals(typeText) || INPUTTYPE_RSVP_HTML.equals(typeText)) {
            return TEMP_SUFFIX_HTML;
        }
        return TEMP_SUFFIX_PDF;
    }

    public static IElementFactory createReportElementFactory(Document document, String outputType) {
        if (OUTPUTTYPE_RES.equals(outputType) || OUTPUTTYPE_RSVP_HTML.equals(outputType)) {
            return null;
        }
        if (OUTPUTTYPE_HTML.equals(outputType)) {
            return new HtmlElementFactory(document);
        }
        return new VmElementFactory(document);
    }

    public String getReportInputType() {
        return this.m_inputType;
    }

    public void setReportInputType(String inputType) {
        this.m_inputType = inputType;
    }

    public IReport createReport(IRenderRow renderRow, String sourcePath, String gatewayUrl, String dispatcherUrl, String storeID, String cmPath, int maxPages, String drillSig, String burstValue, int sourceCode, String description, String outputType) {
        return this.createReport(renderRow, sourcePath, gatewayUrl, dispatcherUrl, storeID, cmPath, maxPages, drillSig, burstValue, sourceCode, description, null, this.portalItemName, outputType);
    }

    public IReport createReport(IRenderRow renderRow, String sourcePath, String gatewayUrl, String dispatcherUrl, String storeID, String cmPath, int maxPages, String drillSignature, String burstValue, int sourceCode, String description, String pathRoot, String fileRoot, String outputType) {
        int renderID = renderRow.getIntField(RenderRow.RenderField.RENDERID);
        this.m_report = INPUTTYPE_MHT.equals(this.m_inputType) ? new MhtReport(renderID, sourcePath, gatewayUrl, dispatcherUrl, storeID, drillSignature, burstValue, sourceCode, description, this.reportProcessorHost, pathRoot, fileRoot, this.m_tmpStore, this.m_inFact) : (INPUTTYPE_VIEWER_HTML.equals(this.m_inputType) ? new ViewerHtmlReport(renderRow, this.m_inFact, sourcePath, gatewayUrl, dispatcherUrl, storeID, drillSignature, burstValue, sourceCode, description, this.reportProcessorHost, this.m_tmpStore) : (INPUTTYPE_RSVP_HTML.equals(this.m_inputType) ? new RsvpHtmlReport(renderID, sourcePath, gatewayUrl, dispatcherUrl, storeID, drillSignature, burstValue, sourceCode, description, this.reportProcessorHost, pathRoot, fileRoot) : (OUTPUTTYPE_VM.equals(outputType) ? new LdxReport(renderID, sourcePath, gatewayUrl, dispatcherUrl, storeID, cmPath, maxPages, drillSignature, burstValue, sourceCode, description, this, this.reportProcessorHost, new VmDocument(null, this)) : (OUTPUTTYPE_HTML.equals(outputType) ? new LdxReport(renderID, sourcePath, gatewayUrl, dispatcherUrl, storeID, cmPath, maxPages, drillSignature, burstValue, sourceCode, description, this, this.reportProcessorHost, new HtmlDocument(null, this)) : new LdxReport(renderID, sourcePath, gatewayUrl, dispatcherUrl, storeID, cmPath, maxPages, drillSignature, burstValue, sourceCode, description, this, this.reportProcessorHost, new MultiDocument(null, this))))));
        return this.m_report;
    }

    public void setReport(IReport report) {
        this.m_report = report;
    }

    public IReport getReport() {
        return this.m_report;
    }

    public IGenerator createVmGenerator() {
        this.vmGenerator = new VmGenerator(this.m_writer);
        return this.vmGenerator;
    }

    public IGenerator createHtmlGenerator() {
        this.htmlGenerator = new HtmlGenerator(this.gte, this.m_testing, this, this.m_writer, true);
        return this.htmlGenerator;
    }

    public void resetGenerators(VmGenerator vmGenerator, HtmlGenerator htmlGenerator) {
        this.vmGenerator = vmGenerator;
        this.htmlGenerator = htmlGenerator;
    }

    public void generateVM(Document doc, PrintStream vmOut) throws CMException {
        this.m_report = doc.getReport();
        if (this.vmGenerator == null) {
            this.createVmGenerator();
        }
        this.vmGenerator.generate(doc, vmOut);
    }

    public void generateVM(Document doc, PrintStream vmOut, int pageIndex) throws CMException {
        this.m_report = doc.getReport();
        if (this.vmGenerator == null) {
            this.createVmGenerator();
        }
        this.vmGenerator.generate(doc, vmOut, pageIndex);
    }

    public void generateHTML(Document doc, PrintStream htmlOut, int pageIndex) throws CMException {
        this.m_report = doc.getReport();
        if (this.htmlGenerator == null) {
            this.createHtmlGenerator();
        }
        this.htmlGenerator.generate(doc, htmlOut, pageIndex);
    }

    public void generateHTML(Document doc, PrintStream htmlOut) throws CMException {
        this.m_report = doc.getReport();
        if (this.htmlGenerator == null) {
            this.createHtmlGenerator();
        }
        this.htmlGenerator.generate(doc, htmlOut);
    }

    public int assembleProgram(String programPath, IVMWriter writer) throws CMException {
        InputStream in;
        try {
            in = this.m_tmpStore.get(programPath);
        }
        catch (IOException ex) {
            String details = "failed to open program " + programPath;
            VM.log(CLASS, 3, details, ex);
            throw new CMException(1203, details, (Throwable)ex);
        }
        ASMAssembler assembler = new ASMAssembler(false, this);
        assembler.assemble(in, writer);
        return writer.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo storeImageResource(int instruction, String originalBlobUrl, IVMWriter writer) throws CMException {
        VM.log(CLASS, 0, "inserting blob from " + originalBlobUrl);
        if (this.m_tmpStore != null) {
            String blobUrl = originalBlobUrl;
            InputStream in = null;
            int[] dimensions = new int[]{-1, -1};
            ImageInfo imageInfo = (ImageInfo)writer.getBlobCache().get(originalBlobUrl);
            try {
                if (imageInfo == null) {
                    if (this.m_inFact != null && this.m_transcoder != null) {
                        if (instruction == 89) {
                            String tempImagePath = null;
                            if (writer.isShinkImages()) {
                                tempImagePath = this.m_transcoder.transcodeImage(originalBlobUrl, null, this.m_cookies, this.m_maxImageSize, this.m_preferredImageFormat);
                                if (tempImagePath != null) {
                                    in = this.m_tmpStore.get(tempImagePath);
                                } else {
                                    VM.log(CLASS, 0, "tempImagePath is null for " + originalBlobUrl);
                                }
                            } else {
                                in = this.m_transcoder.getImageStream(originalBlobUrl, null, this.m_cookies, null);
                                tempImagePath = this.m_tmpStore.createTempPath("mob", ".png", "mobile", true);
                                OutputStream out = this.m_tmpStore.create(tempImagePath, false);
                                if (in != null && out != null) {
                                    ReportCompiler.copyContent(in, out);
                                    in.close();
                                    out.close();
                                    in = this.m_tmpStore.get(tempImagePath);
                                }
                            }
                            if (in != null) {
                                byte[] blobBytes = this.m_inFact.slurp(in);
                                dimensions = ImageInfo.getDimensions(blobBytes);
                                int rc = writer.onWriterWriteBlob(blobBytes, null, 5, dimensions[1], dimensions[0], -1, -1);
                                VM.log(CLASS, 0, "wrote " + blobBytes.length + " bytes to writer for path " + (tempImagePath == null ? tempImagePath : originalBlobUrl));
                                imageInfo = new ImageInfo(rc, dimensions[0], dimensions[1]);
                                writer.getBlobCache().put(originalBlobUrl, imageInfo);
                                writer.getTempCache().put(originalBlobUrl, tempImagePath);
                            } else {
                                VM.log(CLASS, 0, "tempImagePath is null for " + originalBlobUrl);
                            }
                        }
                        if (imageInfo == null) {
                            try {
                                String p = (String)writer.getTempCache().get(originalBlobUrl);
                                byte[] blobBytes = p != null ? this.readBlob(p, this.m_inFact, this.m_tmpStore, this.m_cookies) : this.readBlob(originalBlobUrl, this.m_inFact, this.m_tmpStore, this.m_cookies);
                                dimensions = ImageInfo.getDimensions(blobBytes);
                                int rc = writer.onWriterWriteBlob(blobBytes, null, 5, dimensions[1], dimensions[0], -1, -1);
                                imageInfo = new ImageInfo(rc, dimensions[0], dimensions[1]);
                                writer.getBlobCache().put(originalBlobUrl, imageInfo);
                            }
                            catch (Exception e) {
                                VM.log(CLASS, 0, e);
                                throw new CMException(1005, new String[]{blobUrl}, "Couldn't read url", e);
                            }
                        }
                    } else {
                        VM.log(CLASS, 2, "input stream factory or transcoder null for " + originalBlobUrl);
                        ImageInfo e = new ImageInfo(-1);
                        return e;
                    }
                }
                ImageInfo e = imageInfo;
                return e;
            }
            catch (IOException e) {
                VM.log(CLASS, 2, "temp store null for " + originalBlobUrl);
                ImageInfo imageInfo2 = new ImageInfo(-1);
                return imageInfo2;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ioe) {
                    VM.log(CLASS, 0, ioe);
                }
            }
        }
        VM.log(CLASS, 2, "temp store null for " + originalBlobUrl);
        return new ImageInfo(-1);
    }

    public static String generateResourcePath(String c8GatewayUrl, int renderID, int blobID, int resourceFormat, int page) {
        switch (resourceFormat) {
            case 5: {
                try {
                    return CMPathHelper2.generateImageSrc(c8GatewayUrl, renderID, blobID, "png");
                }
                catch (CMException e) {
                    return Integer.toString(blobID) + ".png";
                }
            }
            case 7: 
            case 9: {
                return "_meta/thumb_l_" + page + ".png";
            }
            case 6: 
            case 8: {
                return "_meta/thumb_s_" + page + ".png";
            }
            case 14: {
                return "_meta/home.png";
            }
        }
        return null;
    }

    public static String generatePageName(int pageIndex) {
        return "p" + Integer.toString(pageIndex) + TEMP_SUFFIX_HTML;
    }

    public static String generateWrapperPageName(int pageIndex) {
        return "p" + Integer.toString(pageIndex) + "i.html";
    }

    public static String generatePromptPageTempID(int renderID) {
        return "promptPage_" + Integer.toString(renderID);
    }

    private byte[] readBlob(String url, IInputStreamFactory m_inFact, IPersistenceStore m_tmpStore, Hashtable<String, String> cookies) throws IOException {
        if (m_tmpStore.exists(url)) {
            VM.log(CLASS, 0, "reading blob url from tmpStore: " + url);
            return m_inFact.slurp(m_tmpStore.get(url));
        }
        VM.log(CLASS, 0, "reading blob url: " + url);
        return m_inFact.slurp(url, null, cookies, null);
    }

    public InputStream runReport(String storeID, int renderID, int currentWidget, int currentWidgetPage) throws CMException {
        StringBuffer reportOutputTempPath = new StringBuffer();
        InputStream pageOutput = null;
        try {
            String stateData;
            OutputStream reportOutputWriter = this.m_tmpStore.createFileTempWriter(reportOutputTempPath, TEMP_SUFFIX_LDX);
            String promptAnswers = null;
            if (this.m_reportRunnerService == null) {
                return null;
            }
            String tmpPath = BuxPromptHelper.getPromptAnswersStoreName(renderID, currentWidget, storeID);
            promptAnswers = TempStoreHelper.readString(this.m_tmpStore, tmpPath, true);
            VM.log(CLASS, 0, "BuxWidget storeID:" + storeID + " promptAnswers:" + promptAnswers);
            IRunResponse runResponse = this.m_reportRunnerService.runReport(storeID, promptAnswers);
            InputStream inStream = runResponse.getRunOutput();
            if (inStream != null) {
                if (reportOutputWriter != null) {
                    ReportCompiler.copyContent(inStream, reportOutputWriter);
                    reportOutputWriter.close();
                    reportOutputWriter = null;
                }
                inStream.close();
                inStream = null;
                this.m_reportRunnerService.pageCleanup();
            }
            if ((stateData = this.m_reportRunnerService.getSavedStateData()) != null) {
                this.setWidgetState(currentWidget, stateData);
                this.m_writer.onWriterWriteBlob(stateData.getBytes("UTF-8"), null, 15, -1, -1, currentWidget, currentWidgetPage);
                VM.log(CLASS, 0, "Saved Bux state to database, storeID:" + storeID + " widgetID:" + currentWidget);
            } else {
                VM.log(CLASS, 3, "Error retrieving state info for storeID:" + storeID + " widgetID:" + currentWidget);
            }
            pageOutput = this.m_tmpStore.get(reportOutputTempPath.toString());
        }
        catch (IOException e) {
            throw new CMException(1152, e.toString());
        }
        return pageOutput;
    }

    public InputStream nextPage(int currentWidget, int currentWidgetPage) throws CMException {
        StringBuffer reportOutputTempPath = new StringBuffer();
        InputStream pageOutput = null;
        try {
            OutputStream reportOutputWriter = this.m_tmpStore.createFileTempWriter(reportOutputTempPath, TEMP_SUFFIX_LDX);
            String stateData = this.getWidgetState(currentWidget);
            if (stateData == null || this.m_reportRunnerService == null) {
                VM.log(CLASS, 3, "Error retrieving state info for widgetID:" + currentWidget);
                return null;
            }
            VM.log(CLASS, 0, "BuxWidget currentWidget:" + currentWidget);
            IRunResponse runResponse = this.m_reportRunnerService.nextPage(stateData);
            pageOutput = runResponse.getRunOutput();
            if (pageOutput != null) {
                if (reportOutputWriter != null) {
                    ReportCompiler.copyContent(pageOutput, reportOutputWriter);
                    reportOutputWriter.close();
                    reportOutputWriter = null;
                }
                pageOutput.close();
                pageOutput = null;
                this.m_reportRunnerService.pageCleanup();
            }
            if ((stateData = this.m_reportRunnerService.getSavedStateData()) != null) {
                this.setWidgetState(currentWidget, stateData);
                this.m_writer.onWriterWriteBlob(stateData.getBytes("UTF-8"), null, 15, -1, -1, currentWidget, currentWidgetPage);
                VM.log(CLASS, 0, "Saved Bux state to database, widgetID:" + currentWidget);
            } else {
                VM.log(CLASS, 3, "Error retrieving state info for widgetID:" + currentWidget);
            }
            pageOutput = this.m_tmpStore.get(reportOutputTempPath.toString());
        }
        catch (IOException e) {
            throw new CMException(1152, e.toString());
        }
        return pageOutput;
    }

    public static void copyContent(InputStream is, OutputStream os) throws IOException {
        if (is == null || os == null) {
            throw new IOException("null input/output stream");
        }
        int count = 0;
        byte[] buffer = new byte[8192];
        while ((count = is.read(buffer)) != -1) {
            os.write(buffer, 0, count);
        }
    }

    public void createTestReport(String xmlPath) throws CMException {
        String testFName = CMPathHelper.getPathFname(xmlPath);
        this.m_report = this.createReport(new RenderRow().setField(RenderRow.RenderField.RENDERID, 0), testFName, "http://localhost:9300/p2pd/servlet/dispatch", "http://localhost:9300/p2pd/servlet/dispatch", "test", "/test[@file='" + testFName + "'", 50, "", null, 0, "Test Report", null);
        try {
            FileInputStream reader = new FileInputStream(xmlPath);
            RunResponse runResponse = new RunResponse(reader);
            this.m_report.processReportOutput(0, runResponse, true);
        }
        catch (FileNotFoundException e) {
            VM.log(CLASS, 2, "Note: Report source file was missing: " + xmlPath);
        }
    }

    public void createTestReport(String xmlPath, String reportInfoPath, OutputStream finalLdxOut, String pathRoot, String fileRoot) throws CMException {
        String testFName = CMPathHelper.getPathFname(xmlPath);
        this.m_report = this.createReport(new RenderRow().setField(RenderRow.RenderField.RENDERID, 0), testFName, "http://localhost:9300/p2pd/servlet/dispatch", "http://localhost:9300/p2pd/servlet/dispatch", "test", "/test[@file='" + testFName + "'", 50, "", "", 0, "Test Report", pathRoot, fileRoot, null);
        try {
            FileInputStream reader = new FileInputStream(xmlPath);
            RunResponse runResponse = new RunResponse(reader);
            this.m_report.processReportOutput(0, runResponse, true);
            ((InputStream)reader).close();
        }
        catch (FileNotFoundException e) {
            VM.log(CLASS, 2, "Note: Report source file was missing: " + xmlPath);
        }
        catch (IOException e) {
            VM.log(CLASS, 2, "Note: Error closing file file was missing: " + xmlPath);
        }
    }

    public String[] parsePages(String path) throws CMException {
        Vector<String> pages;
        block6: {
            pages = new Vector<String>();
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
                String temp = ReportCompiler.skipUntilMatch(reader, "<mob:output");
                temp = ReportCompiler.skipUntilMatch(reader, ">");
                if (temp.length() == 0) break block6;
                while (true) {
                    try {
                        ReportCompiler.skipUntilMatch(reader, "<mob:page");
                        ReportCompiler.skipUntilMatch(reader, ">");
                    }
                    catch (EOFException ex) {
                        break;
                    }
                    String page = ReportCompiler.skipUntilMatch(reader, "</mob:page>");
                    pages.addElement(page);
                }
            }
            catch (EOFException page) {
            }
            catch (IOException ex) {
                String details = "i/o error: " + ex.toString();
                VM.log(CLASS, 3, details);
                throw new CMException(1004, new String[]{path}, details);
            }
        }
        return pages.toArray(new String[0]);
    }

    public void setHasNextPage() {
        this.hasNextPage = this.getReport().getHasNextPage();
    }

    public boolean getHasNextPage() {
        if (this.m_reportRunnerService == null) {
            return this.hasNextPage;
        }
        int serviceHasNextPage = this.m_reportRunnerService.getHasNextPage();
        if (serviceHasNextPage != 0) {
            return serviceHasNextPage == 2;
        }
        return this.getReport() == null ? false : this.hasNextPage;
    }

    public String getWidgetState(int widget) {
        String state = this.widgetState == null ? null : (String)this.widgetState.get(new Integer(widget));
        return state == null ? null : state;
    }

    public void setWidgetState(int widget, String state) {
        if (this.widgetState == null) {
            this.widgetState = new Hashtable(3);
        }
        this.widgetState.put(new Integer(widget), new String(state));
    }

    public int getWidgetPageIndex(int widget) {
        Integer pageIndex = this.widgetPageIndex == null ? new Integer(0) : (Integer)this.widgetPageIndex.get(new Integer(widget));
        return pageIndex == null ? 0 : pageIndex;
    }

    public void setWidgetPageIndex(int widget, int page) {
        if (this.widgetPageIndex == null) {
            this.widgetPageIndex = new Hashtable(3);
        }
        this.widgetPageIndex.put(new Integer(widget), new Integer(page));
    }

    public void setWidgetHasNextPage(int widget, boolean doesHaveNextPage) {
        if (this.widgetHasNextPage == null) {
            this.widgetHasNextPage = new Hashtable(3);
        }
        this.widgetHasNextPage.put(new Integer(widget), new Boolean(doesHaveNextPage));
    }

    public boolean getWidgetHasNextPage(int widget) {
        if (this.widgetHasNextPage == null) {
            return false;
        }
        Boolean nextPage = (Boolean)this.widgetHasNextPage.get(widget);
        return nextPage == null ? false : nextPage;
    }

    private static String skipUntilMatch(Reader reader, String match) throws IOException, EOFException {
        int matchLength = 0;
        StringBuffer buf = new StringBuffer();
        while (true) {
            int rc;
            if ((rc = reader.read()) == -1) {
                throw new EOFException();
            }
            char ch = (char)rc;
            buf.append(ch);
            if (ch == match.charAt(matchLength)) {
                if (++matchLength != match.length()) continue;
                break;
            }
            matchLength = 0;
        }
        String result = buf.toString();
        result = result.substring(0, result.length() - match.length());
        return result;
    }

    public void setReportProcessorHost(IReportOutputProcessor reportProcessorHost) {
        this.reportProcessorHost = reportProcessorHost;
    }
}

