/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.configuration;

import com.cognos.mobile.configuration.IConfiguration;
import java.util.Hashtable;

public class HashtableConfiguration
implements IConfiguration {
    private Hashtable hashtable;

    public HashtableConfiguration(Hashtable hashtable) {
        this.hashtable = hashtable;
    }

    @Override
    public String getString(String propName, String defaultValue) {
        String value = (String)this.hashtable.get(propName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public int getInt(String propName, int defaultValue) {
        String value = (String)this.hashtable.get(propName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(String propName, boolean defaultValue) {
        String value = (String)this.hashtable.get(propName);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("true");
    }

    @Override
    public long getLong(String propName, long defaultValue) {
        String value = (String)this.hashtable.get(propName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public float getFloat(String propName, float defaultValue) {
        String value = (String)this.hashtable.get(propName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public void setString(String propName, String value) {
        this.hashtable.put(propName, value);
    }

    public void setInt(String propName, int value) {
        this.hashtable.put(propName, Integer.toString(value));
    }
}

