/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.consoleclient;

import com.cognos.mobile.builder.RIMSettingsBuilder;
import com.cognos.mobile.builder.SettingsBuilder;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;

public class MobAdmin {
    private static String usage = "NAME\n  buildSettings \"url1\" \"url2\" \"url3\" ...\n\nDESCRIPTION\n  This windows-only tool preconfigures the list of available server\n  URLs in IBM Cognos Mobile clients.\n  Client configurations are created and stored in: \n      " + SettingsBuilder.getC8Dir() + "/configuration/mobile\n\n" + "  You must copy the platform-specific configuration files to the appropriate\n" + "  folders in:\n" + "      " + SettingsBuilder.getC8Dir() + "/webcontent/mobile\n\n" + "  For the BlackBerry configuration, you must overwrite the\n" + "  rim_desktop/*/cognos_mobile_settings.cod and \n" + "  rim_ota/*/cognos_mobile_settings.cod files.\n\n" + "EXAMPLE\n" + "  buildSettings \"http://server1/c8/cgi-bin/cognos.cgi\" \"http://server2/c8/cgi-bin/cognos.cgi\"\n\n" + "IMPORTANT:\n" + "  The rapc.exe BlackBerry compiler is\n" + "  required to configure the BlackBerry client.  These tools\n" + "  only run on the Windows operating system.";

    public void buildSettings(String[] args) throws Exception {
        System.out.println("\n\nBuilding settings...\n");
        ArrayList<String> urlset = new ArrayList<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (!MobAdmin.doesUrlLookOk(args[i])) {
                return;
            }
            if (urlset.contains(args[i])) {
                System.out.println("URL " + args[i] + " - is a duplicate; ignored...");
                continue;
            }
            System.out.println("URL " + args[i] + " - ok");
            urlset.add(args[i]);
        }
        String urls = CMStringHelper.join(urlset.toArray(new String[urlset.size()]), ";");
        Hashtable<String, String> settings = new Hashtable<String, String>();
        settings.put("Server.URLs", urls);
        SettingsBuilder[] builders = new SettingsBuilder[]{new RIMSettingsBuilder()};
        for (int i = 0; i < builders.length; ++i) {
            try {
                builders[i].buildSettings(settings);
                continue;
            }
            catch (CMException ex) {
                System.out.println("\nERROR!\n");
                ex.printStackTrace(System.err);
            }
        }
        System.out.println("\nBuilding settings complete!");
    }

    public static boolean doesUrlLookOk(String url) throws MalformedURLException {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException mue) {
            System.out.println("ERROR!  Malformed url: " + url + "\nPlease correct the url and try again.");
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        SettingsBuilder.setLoggingStream(System.out);
        MobAdmin mobsettings = new MobAdmin();
        if (args.length == 0) {
            System.out.println("Missing argument\n\n" + usage);
            System.exit(-1);
        }
        mobsettings.buildSettings(args);
    }
}

