/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.IBlobDAO;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.SQLBlobDAO;
import com.cognos.mobile.server.admin.IAdminNotifier;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import java.util.LinkedHashMap;

public class BlobManager {
    private static Class<BlobManager> CLASS = BlobManager.class;
    private final IBlobDAO blobDAO;
    private final IConfiguration scconfig;
    private final IAdminNotifier adminNotifier;

    public BlobManager(ISQLDatabase database, IConfiguration scconfig, IAdminNotifier adminNotifier) {
        this.blobDAO = new SQLBlobDAO(database, scconfig);
        this.scconfig = scconfig;
        this.adminNotifier = adminNotifier;
    }

    public void deleteBlob(int userID) throws CMException {
        this.blobDAO.deleteBlob(userID);
    }

    public void deleteBlob(String hash, StringBuilder detailsLog) throws CMException {
        this.blobDAO.deleteBlob(hash, detailsLog);
    }

    public String[] getUnusedBlobs() throws CMException {
        return this.blobDAO.getUnusedBlobs();
    }

    public void deleteUnusedBlobs() throws CMException {
        this.blobDAO.deleteUnusedBlobs();
    }

    public void insertBlob(int userID, byte[] blob) throws CMException {
        this.blobDAO.insertBlob(userID, blob);
    }

    public int insertBlob(String hash, byte[] blob, int renderID, Connection connection) throws CMException {
        int actualRecords = 0;
        StringBuilder detailsLog = null;
        try {
            if (!this.blobDAO.blobExists(hash)) {
                String problemMsg = "Problematic blob render:" + renderID + " hash:" + hash + " RESULT:";
                if (blob == null) {
                    problemMsg = problemMsg + "SKIPPED - NULL BLOB";
                    throw new CMException(1126, problemMsg);
                }
                if (blob.length == 0) {
                    problemMsg = problemMsg + "SKIPPED - EMPTY BLOB";
                    throw new CMException(1126, problemMsg);
                }
                boolean done = false;
                int count = 0;
                if (this.scconfig != null && this.scconfig.getBoolean("Debug.OutputDetails", false)) {
                    detailsLog = new StringBuilder();
                }
                if (this.scconfig == null || !this.scconfig.getBoolean("Reports.CombinedResourceBlobCommit", false)) {
                    while (!done) {
                        int expectedRecords = this.blobDAO.insertBlob(hash, blob, renderID, detailsLog, connection);
                        actualRecords = this.blobDAO.blobRecordCount(hash, -1, detailsLog);
                        if (detailsLog != null) {
                            detailsLog.append("Attempt:").append(count).append(" Expected records:").append(expectedRecords).append(" Actual records:").append(actualRecords).append("\n").append("*******").append("\n");
                        }
                        if (actualRecords == 0) {
                            problemMsg = problemMsg + "RESULT - EMPTY BLOB";
                            throw new CMException(1126, problemMsg);
                        }
                        if (expectedRecords != actualRecords) {
                            if (++count > 5) {
                                done = true;
                                problemMsg = problemMsg + "FAILED expected:" + expectedRecords + " actual:" + actualRecords;
                                throw new CMException(1126, problemMsg);
                            }
                            this.blobDAO.deleteBlob(hash, detailsLog);
                            continue;
                        }
                        done = true;
                    }
                    if (count > 0) {
                        problemMsg = problemMsg + "SUCCESS";
                        this.sendAdminNotification(renderID, null, problemMsg, detailsLog);
                    }
                } else {
                    this.blobDAO.insertBlob(hash, blob, renderID, detailsLog, connection);
                }
            }
        }
        catch (CMException ex) {
            this.sendAdminNotification(renderID, ex, null, detailsLog);
            throw ex;
        }
        return actualRecords;
    }

    public int blobRecordCount(String hash, int userID, StringBuilder detailsLog) throws CMException {
        return this.blobDAO.blobRecordCount(hash, userID, detailsLog);
    }

    public byte[] getBlob(int userID) throws CMException {
        return this.blobDAO.getBlob(userID);
    }

    public byte[] getBlob(String hash) throws CMException {
        return this.blobDAO.getBlob(hash);
    }

    public boolean blobExists(String hash) throws CMException {
        return this.blobDAO.blobExists(hash);
    }

    private void sendAdminNotification(int renderID, CMException ex, String comments, StringBuilder detailsLog) {
        if (this.adminNotifier != null) {
            LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
            info.put("Render ID", Integer.toString(renderID));
            if (ex != null) {
                info.put("Error Message", ex.getMessage());
            }
            if (comments != null) {
                info.put("Comments", comments);
            }
            if (detailsLog != null) {
                info.put("Error Details", detailsLog.toString());
            }
            try {
                this.adminNotifier.notify(info);
            }
            catch (Exception e) {
                VM.log(CLASS, 2, "Failed admin notification", e);
            }
        }
    }
}

