/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.status.IStatusProvider;
import com.cognos.mobile.status.STStatusProviders;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class DBConnectionPool
implements IStatusProvider,
IConnectionPool {
    private static final Class CLASS = DBConnectionPool.class;
    private static final String VALIDATING_QUERY = null;
    final GenericObjectPool connectionPool;
    private final PoolableConnectionFactory poolableConnectionFactory;

    public DBConnectionPool(int maxPoolSize, int maxWait) {
        this.connectionPool = new GenericObjectPool(null, maxPoolSize);
        this.connectionPool.setMaxWait((long)(maxWait * 1000));
        this.poolableConnectionFactory = new PoolableConnectionFactory(null, (ObjectPool)this.connectionPool, null, VALIDATING_QUERY, false, true);
        STStatusProviders.getInstance().addProvider("database connection pool", this);
    }

    @Override
    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.poolableConnectionFactory.setConnectionFactory(connectionFactory);
    }

    @Override
    public Connection getConnection() throws Exception {
        try {
            Connection connection = (Connection)this.connectionPool.borrowObject();
            connection.setAutoCommit(true);
            return connection;
        }
        catch (Exception e) {
            VM.log(CLASS, 3, "Error while attempting to acquire DB connection", e);
            throw e;
        }
    }

    @Override
    public void returnConnection(Connection connection) throws Exception {
        this.connectionPool.returnObject((Object)connection);
    }

    @Override
    public void releaseConnection(Connection connection) {
        try {
            this.connectionPool.invalidateObject((Object)connection);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void dispose() {
        STStatusProviders.getInstance().removeProvider(this);
        try {
            this.connectionPool.close();
        }
        catch (Exception e) {
            VM.log(CLASS, 3, "error while disposing connection pool", e);
        }
    }

    @Override
    public String getStatus() {
        StringBuffer sb = new StringBuffer();
        sb.append("<connectionPool maxSize=\"");
        sb.append(this.connectionPool.getMaxActive());
        sb.append("\" maxWait=\"");
        sb.append(this.connectionPool.getMaxWait());
        sb.append("\">");
        sb.append("<idleConnections count=\"");
        sb.append(this.connectionPool.getNumIdle());
        sb.append("\"/>");
        sb.append("<activeConnections count=\"");
        sb.append(this.connectionPool.getNumActive());
        sb.append("\"/>");
        sb.append("</connectionPool>");
        return sb.toString();
    }
}

