/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.DBDB2DatabaseCalls;
import com.cognos.mobile.database.DBSqlDatabase;
import com.cognos.mobile.database.DatabaseCleaner;
import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.database.ISQLDatabaseCalls;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBDB2Database
extends DBSqlDatabase {
    private static final Class<DBSqlDatabase> CLASS = DBSqlDatabase.class;
    public static final String DEFAULT_DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    public static final String DEFAULT_CONNECTION_URL_TYPE2 = "jdbc:db2:{1}:retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=true;";
    public static final String DEFAULT_CONNECTION_URL_TYPE4 = "jdbc:db2://{1}/{2}:retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=true;";
    public static final String CONNECTION_OPTION_SSL = "sslConnection=true;";
    private boolean bDB2zOS;

    public DBDB2Database(IConnectionPool connectionPool, String driverClass, String connectionUrl, String databaseName, String username, String password) throws CMException {
        super(true, connectionPool, driverClass, CMStringHelper.formatString(connectionUrl, new String[]{databaseName}), "db2", username, password, "(local)", databaseName, null, null);
        this.init();
    }

    public DBDB2Database(IConnectionPool connectionPool, String driverClass, String connectionUrl, String hostPort, String databaseName, String username, String password, IConfiguration config) throws CMException {
        super(true, connectionPool, driverClass, CMStringHelper.formatString(connectionUrl, new String[]{hostPort, databaseName}), "db2", username, password, hostPort, databaseName, null, config);
        this.init();
    }

    private void init() throws CMException {
        String dbProdName;
        Connection con;
        try {
            con = this.getConnectionPool().getConnection();
        }
        catch (Exception ex) {
            String details = "Failed to get a DB2 connection from the connection pool.";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1147, details, (Throwable)ex);
        }
        try {
            DatabaseMetaData dbInfo = con.getMetaData();
            dbProdName = dbInfo.getDatabaseProductName();
        }
        catch (SQLException ex) {
            String details = "Failed to get database product name.";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1120, details, (Throwable)ex);
        }
        finally {
            this.quietlyReleaseConnection(con);
        }
        if (dbProdName != null && (dbProdName.toLowerCase().contains("z/os") || dbProdName.equalsIgnoreCase("DB2"))) {
            this.setSchemaDirectory("db2zOS");
            this.bDB2zOS = true;
        }
    }

    public boolean isDB2zOS() {
        return this.bDB2zOS;
    }

    @Override
    public int getDatabaseType() {
        return 3;
    }

    @Override
    public byte[] getBlobBytes(ResultSet rs, int column) throws SQLException {
        return rs.getBytes(column);
    }

    @Override
    public void setBlobSpecial(PreparedStatement statement, int paramIndex, byte[] blobArray, int startByte, int length, StringBuilder detailsLog) throws SQLException {
        if (blobArray != null && (startByte != 0 || length != blobArray.length)) {
            byte[] temp = new byte[length];
            System.arraycopy(blobArray, startByte, temp, 0, length);
            blobArray = temp;
        }
        statement.setBytes(paramIndex, blobArray);
        if (detailsLog != null) {
            detailsLog.append("setBlobSpecial paramIndex:").append(paramIndex).append(" blobArray.length:").append(blobArray.length).append("\n");
        }
    }

    @Override
    public ISQLDatabaseCalls getDatabaseCalls() {
        if (this.databaseCalls == null) {
            this.databaseCalls = new DBDB2DatabaseCalls(this.m_jdbcLevel, this.getDatabaseType(), this.isDB2zOS());
        }
        return this.databaseCalls;
    }

    @Override
    public String[] getUserTableNames(Connection connection) throws SQLException {
        ISQLDatabaseCalls calls = this.getDatabaseCalls();
        return calls.getUserTableNames(connection);
    }

    @Override
    public void clean(Connection connection) throws SQLException {
        DatabaseCleaner cleaner = new DatabaseCleaner(this.getDatabaseCalls());
        cleaner.clean(connection);
    }
}

