/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DBDerbyDatabaseCalls;
import com.cognos.mobile.database.DBSqlDatabase;
import com.cognos.mobile.database.DatabaseCleaner;
import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.database.ISQLDatabaseCalls;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBDerbyDatabase
extends DBSqlDatabase {
    public static final String DEFAULT_DRIVER_CLASS = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DEFAULT_CONNECTION_URL = "jdbc:derby://{1}/{2}";
    private String m_directory;

    public DBDerbyDatabase(IConnectionPool connectionPool, String directory, boolean create) throws CMException {
        super(false, connectionPool, DEFAULT_DRIVER_CLASS, "jdbc:derby:" + directory + (create ? ";create=true" : ""), "derby", null, null, null, null, null, null);
        this.m_directory = directory;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            DriverManager.getConnection("jdbc:derby:" + this.m_directory + ";shutdown=true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getDatabaseType() {
        return 6;
    }

    public String getDirectory() {
        return this.m_directory;
    }

    @Override
    public ISQLDatabaseCalls getDatabaseCalls() {
        if (this.databaseCalls == null) {
            this.databaseCalls = new DBDerbyDatabaseCalls(this.m_jdbcLevel, this.getDatabaseType());
        }
        return this.databaseCalls;
    }

    @Override
    public String[] getUserTableNames(Connection connection) throws SQLException {
        ISQLDatabaseCalls calls = this.getDatabaseCalls();
        return calls.getUserTableNames(connection);
    }

    @Override
    public void clean(Connection connection) throws SQLException {
        DatabaseCleaner cleaner = new DatabaseCleaner(this.getDatabaseCalls());
        cleaner.clean(connection);
    }
}

