/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.DBDerbyDatabaseCalls;
import com.cognos.mobile.database.DBSqlDatabase;
import com.cognos.mobile.database.DatabaseCleaner;
import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.database.ISQLDatabaseCalls;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBDerbyNetworkedDatabase
extends DBSqlDatabase {
    public static final String DEFAULT_CONNECTION_URL_1 = "jdbc:derby://{1}/{2};user={3}; password={4}";
    public static final String DEFAULT_CONNECTION_URL_2 = "jdbc:derby://{1}/{2}";
    public static final String DEFAULT_DRIVER_CLASS = "org.apache.derby.jdbc.ClientDriver";

    public DBDerbyNetworkedDatabase(IConnectionPool connectionPool, String hostport, String databaseName, String username, String password, IConfiguration config) throws CMException {
        super(false, connectionPool, DEFAULT_DRIVER_CLASS, username == null || username.length() == 0 || password == null || password.length() == 0 ? CMStringHelper.formatString(DEFAULT_CONNECTION_URL_2, new String[]{hostport, databaseName}) : CMStringHelper.formatString(DEFAULT_CONNECTION_URL_1, new String[]{hostport, databaseName, username, password}), "derby", username, password, hostport, databaseName, null, config);
    }

    @Override
    public int getDatabaseType() {
        return 8;
    }

    @Override
    public byte[] getBlobBytes(ResultSet rs, int column) throws SQLException {
        return rs.getBytes(column);
    }

    @Override
    public ISQLDatabaseCalls getDatabaseCalls() {
        if (this.databaseCalls == null) {
            this.databaseCalls = new DBDerbyDatabaseCalls(this.m_jdbcLevel, this.getDatabaseType());
        }
        return this.databaseCalls;
    }

    @Override
    public String[] getUserTableNames(Connection connection) throws SQLException {
        ISQLDatabaseCalls calls = this.getDatabaseCalls();
        return calls.getUserTableNames(connection);
    }

    @Override
    public void clean(Connection connection) throws SQLException {
        DatabaseCleaner cleaner = new DatabaseCleaner(this.getDatabaseCalls());
        cleaner.clean(connection);
    }
}

