/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.DBInformixDatabaseCalls;
import com.cognos.mobile.database.DBSqlDatabase;
import com.cognos.mobile.database.DatabaseCleaner;
import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.database.ISQLDatabaseCalls;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBInformixDatabase
extends DBSqlDatabase {
    private static final Class<DBSqlDatabase> CLASS = DBSqlDatabase.class;
    public static final String DEFAULT_DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    public static final String DEFAULT_CONNECTION_URL = "jdbc:ids://{1}/{2}:retrieveMessagesFromServerOnGetMessage=true;fullyMaterializeLobData=true;";
    public static final String CONNECTION_OPTION_SSL = "sslConnection=true;";
    public static final String PARAM_LOCK_MODE_WAIT_SECONDS = "INFORMIX_LOCK_MODE_WAIT_SECONDS";
    public static final int DEFAULT_LOCK_MODE_WAIT_SECONDS = 240;
    final int lockModeWaitSeconds;

    public DBInformixDatabase(IConnectionPool connectionPool, String driverClass, String connectionUrl, String hostPort, String databaseName, String username, String password, IConfiguration config) throws CMException {
        super(true, connectionPool, driverClass, CMStringHelper.formatString(connectionUrl, new String[]{hostPort, databaseName}), "informix", username, password, hostPort, databaseName, null, config);
        this.lockModeWaitSeconds = this.getLockModeWaitSeconds(config);
    }

    private int getLockModeWaitSeconds(IConfiguration config) {
        int result = 240;
        if (config != null) {
            result = config.getInt(PARAM_LOCK_MODE_WAIT_SECONDS, 240);
        }
        return result;
    }

    @Override
    public int getDatabaseType() {
        return 10;
    }

    @Override
    public byte[] getBlobBytes(ResultSet rs, int column) throws SQLException {
        return rs.getBytes(column);
    }

    @Override
    public void setBlobSpecial(PreparedStatement statement, int paramIndex, byte[] blobArray, int startByte, int length, StringBuilder detailsLog) throws SQLException {
        if (blobArray != null && (startByte != 0 || length != blobArray.length)) {
            byte[] temp = new byte[length];
            System.arraycopy(blobArray, startByte, temp, 0, length);
            blobArray = temp;
        }
        statement.setBytes(paramIndex, blobArray);
    }

    @Override
    public Connection createConnection() throws SQLException {
        Connection connection = super.createConnection();
        this.connectionSetup(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionSetup(Connection connection) throws SQLException {
        connection.setHoldability(1);
        connection.setTransactionIsolation(2);
        Statement connectionSetupStmt = null;
        try {
            connectionSetupStmt = connection.createStatement();
            connectionSetupStmt.execute("SET LOCK MODE TO WAIT " + this.lockModeWaitSeconds);
        }
        finally {
            if (connectionSetupStmt != null) {
                try {
                    connectionSetupStmt.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public ISQLDatabaseCalls getDatabaseCalls() {
        if (this.databaseCalls == null) {
            this.databaseCalls = new DBInformixDatabaseCalls(this.m_jdbcLevel, this.getDatabaseType());
        }
        return this.databaseCalls;
    }

    @Override
    public String[] getUserTableNames(Connection connection) throws SQLException {
        ISQLDatabaseCalls calls = this.getDatabaseCalls();
        return calls.getUserTableNames(connection);
    }

    @Override
    public void clean(Connection connection) throws SQLException {
        DatabaseCleaner cleaner = new DatabaseCleaner(this.getDatabaseCalls());
        cleaner.clean(connection);
    }
}

