/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.database.DBSqlDatabaseCalls;
import com.cognos.mobile.database.SchemaVersion;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBInformixDatabaseCalls
extends DBSqlDatabaseCalls {
    private static final Class CLASS = DBInformixDatabaseCalls.class;

    public DBInformixDatabaseCalls(int jdbcLvl, int dbType) {
        super(jdbcLvl, dbType);
    }

    @Override
    public SchemaVersion getSchemaVersion(String username, Connection connection) throws SQLException {
        return this.getSchemaVersion(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaVersion getSchemaVersion(Connection connection) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        SchemaVersion schemaVersion = new SchemaVersion(0, 0);
        statement = connection.createStatement();
        try {
            resultSet = statement.executeQuery("select * from MOB_SCHEMA_VERSION");
            if (resultSet.next()) {
                String subminor;
                int major = resultSet.getInt(1);
                int minor = resultSet.getInt(2);
                try {
                    subminor = resultSet.getString(3);
                }
                catch (Exception e) {
                    subminor = "NEW";
                }
                schemaVersion = new SchemaVersion(major, minor, subminor);
            }
            boolean secondRow = false;
            try {
                secondRow = resultSet.next();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (secondRow) {
                throw new SQLException("ERROR!  SELECT * FROM MOB_SCHEMA_VERSION table returned more than 1 row.  Aborting...");
            }
        }
        catch (SQLException se) {
            VM.log(CLASS, 2, "Informix was unable to get schema version. Will assume clean database. SQL state '" + se.getSQLState() + "', '" + se.getMessage() + "'");
        }
        finally {
            super.quietlyCloseResultSet(resultSet);
            super.quietlyCloseStatement(statement);
        }
        return schemaVersion;
    }

    @Override
    public String[] getUserTableNames(Connection connection) throws SQLException {
        String sql = "SELECT owner || '.' || tabname FROM systables WHERE    tabid > 99 AND    tabtype = 'T'";
        return this.executeQueryToStringArray(connection, sql);
    }
}

