/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.BlobManager;
import com.cognos.mobile.database.DeviceManager;
import com.cognos.mobile.database.DrillManager;
import com.cognos.mobile.database.DrillRow;
import com.cognos.mobile.database.HistoryManager;
import com.cognos.mobile.database.HistoryObject;
import com.cognos.mobile.database.IMobileDatabase;
import com.cognos.mobile.database.IRenderRow;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.ISyncDatabase;
import com.cognos.mobile.database.PortalItemManager;
import com.cognos.mobile.database.PortalItemRow;
import com.cognos.mobile.database.RenderGroupManager;
import com.cognos.mobile.database.RenderManager;
import com.cognos.mobile.database.RenderRow;
import com.cognos.mobile.database.RenderStatus;
import com.cognos.mobile.database.ResourceManager;
import com.cognos.mobile.database.ResourceRow;
import com.cognos.mobile.database.SyncDatabaseManager;
import com.cognos.mobile.database.TempStorageManager;
import com.cognos.mobile.database.TempStorageObject;
import com.cognos.mobile.database.UserManager;
import com.cognos.mobile.model.data.Device;
import com.cognos.mobile.model.data.SavedOutputType;
import com.cognos.mobile.model.data.User;
import com.cognos.mobile.server.admin.IAdminNotifier;
import com.cognos.mobile.server.monitoring.InteractiveReportMonitoringController;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

public class DBMobileDatabase
implements IMobileDatabase {
    private static final Class<DBMobileDatabase> CLASS = DBMobileDatabase.class;
    private final ISQLDatabase database;
    private final RenderManager renderManager;
    private final UserManager userManager;
    private final PortalItemManager portalItemManager;
    private final HistoryManager historyManager;
    private final ResourceManager resourceManager;
    private final BlobManager blobManager;
    private final SyncDatabaseManager syncDatabaseManager;
    private final TempStorageManager tempStorageManager;
    private final DrillManager drillManager;
    private final DeviceManager deviceManager;
    private final RenderGroupManager renderGroupManager;

    public DBMobileDatabase(ISQLDatabase database, IConfiguration scconfig, InteractiveReportMonitoringController aMonitoringController, IAdminNotifier adminNotifier) {
        if (database == null) {
            throw new IllegalArgumentException("database must not be null");
        }
        this.database = database;
        this.portalItemManager = new PortalItemManager(database);
        this.blobManager = new BlobManager(database, scconfig, adminNotifier);
        this.renderManager = new RenderManager(database, this.portalItemManager, aMonitoringController);
        this.userManager = new UserManager(database);
        this.historyManager = new HistoryManager(database);
        this.resourceManager = new ResourceManager(database, this.blobManager, scconfig);
        this.syncDatabaseManager = new SyncDatabaseManager(database);
        this.tempStorageManager = new TempStorageManager(database);
        this.drillManager = new DrillManager(database);
        this.deviceManager = new DeviceManager(database);
        this.renderGroupManager = new RenderGroupManager(database);
    }

    public DBMobileDatabase(ISQLDatabase database) {
        this(database, null, null, null);
    }

    @Override
    public User getUser(int id) throws CMException {
        return this.userManager.getUser(id);
    }

    @Override
    public User addUser(String searchPath) throws CMException {
        return this.userManager.addUser(searchPath);
    }

    @Override
    public User addUser(String searchPath, String uniqueUserId) throws CMException {
        return this.userManager.addUser(searchPath, uniqueUserId);
    }

    @Override
    public User getUser(String searchPath) throws CMException {
        return this.userManager.getUser(searchPath);
    }

    @Override
    public List listAllUsers() throws CMException {
        return this.userManager.listAllUsers();
    }

    @Override
    public void setUniqueUserId(int userID, String uniqueUserId) throws CMException {
        this.userManager.setUniqueUserId(userID, uniqueUserId);
    }

    @Override
    public void setKey(String deviceID, int userID, String keyType, byte[] key) throws CMException {
        this.deviceManager.setKey(deviceID, userID, keyType, key);
    }

    @Override
    public Device addDevice(String deviceID, int userID, String pushID, String syncMethod) throws CMException {
        return this.deviceManager.addDevice(deviceID, userID, pushID, syncMethod);
    }

    @Override
    public IRenderRow[] browseRenders(int userID, boolean latestVersionsOnly, List<Integer> supportedOutputFormats) throws CMException {
        IRenderRow[] renders = this.renderManager.browseRenders(userID, supportedOutputFormats);
        if (!latestVersionsOnly || renders.length == 0) {
            return renders;
        }
        LinkedHashMap<String, IRenderRow> result = new LinkedHashMap<String, IRenderRow>();
        for (IRenderRow renderRow : renders) {
            String storeId = renderRow.getStringField(RenderRow.RenderField.STOREID);
            String burstValue = renderRow.getStringField(RenderRow.RenderField.BURST_VALUE);
            String drillParms = renderRow.getStringField(RenderRow.RenderField.DRILLPARAMS);
            if (renderRow.getSavedOutputType() != SavedOutputType.NONE.getType()) {
                if (result.containsKey(Integer.toString(renderRow.getSavedOutputType()) + storeId + burstValue)) continue;
                result.put(Integer.toString(renderRow.getSavedOutputType()) + storeId + burstValue, renderRow);
                continue;
            }
            if (renderRow.getIntField(RenderRow.RenderField.SOURCECODE) == 4) {
                result.put("rescontrib:" + renderRow.getIntField(RenderRow.RenderField.RENDERID), renderRow);
                continue;
            }
            if (result.containsKey(storeId + drillParms + burstValue)) continue;
            result.put(storeId + drillParms + burstValue, renderRow);
        }
        Collection values = result.values();
        return values.toArray(new IRenderRow[values.size()]);
    }

    @Override
    public PortalItemRow addFavourite(int userId, C8.PortalItem item) throws CMException {
        return this.portalItemManager.addFavourite(userId, item);
    }

    @Override
    public void deleteFavourite(int userId, PortalItemRow pi) throws CMException {
        this.portalItemManager.deleteFavourite(userId, pi);
    }

    @Override
    public void deleteFavourites(int userId) throws CMException {
        this.portalItemManager.deleteFavourites(userId);
    }

    @Override
    public void deletePortalItem(int id) throws CMException {
        this.portalItemManager.deletePortalItem(id);
    }

    @Override
    public PortalItemRow[] listFavourites(int userId) throws CMException {
        return this.portalItemManager.listFavourites(userId);
    }

    @Override
    public IRenderRow getDashboard(int userID) throws CMException {
        return this.renderManager.getDashboard(userID);
    }

    @Override
    public int getDashboardID(int userID) throws CMException {
        return this.renderManager.getDashboardID(userID);
    }

    public void deleteRender(int renderID) throws CMException {
        VM.log(CLASS, 0, "deleted render " + renderID);
        this.renderManager.deleteRender(renderID, -1);
    }

    @Override
    public String[] getUnusedBlobs() throws CMException {
        return this.blobManager.getUnusedBlobs();
    }

    @Override
    public void deleteUnusedBlobs() throws CMException {
        this.blobManager.deleteUnusedBlobs();
    }

    @Override
    public void deleteRender(int renderID, int userID) throws CMException {
        VM.log(CLASS, 0, "deleted render " + renderID + " for user " + userID);
        this.renderManager.deleteRender(renderID, userID);
    }

    @Override
    public List<IRenderRow> getPreviousRenders(String cmPath, int userId, int sourceCode, String drillParams, String burstValue, SavedOutputType savedOutputType, List<Integer> withOutputFormats) throws CMException {
        return null;
    }

    @Override
    public void flushOldRenders(int maxAgeDays) throws CMException {
        this.renderManager.flushOldRenders(maxAgeDays);
    }

    @Override
    public Integer[] getExpiredRenders(int maxAgeDays) throws CMException {
        return null;
    }

    @Override
    public IRenderRow loadRender(int renderID) throws CMException {
        return this.renderManager.loadRender(renderID);
    }

    @Override
    public IRenderRow insertRender(int outputTypeMask, int ownerID, String label, String storeID, String cmPath, String sourcePath, String description, int sourceCode, String drillParams, String burstValue, String saveName, String baseDoc, String smallThumb, String mediumThumb, String largeThumb, int portalItemType, Date creationDate, int[] targetUserIDs) throws CMException {
        int portalItemID = this.portalItemManager.insertPortalItem(label, storeID, cmPath, sourcePath, description, portalItemType);
        return this.renderManager.insertRender(outputTypeMask, ownerID, label, storeID, cmPath, sourcePath, description, sourceCode, drillParams, burstValue, saveName, portalItemID, baseDoc, smallThumb, mediumThumb, largeThumb, portalItemType, null, creationDate, targetUserIDs, null);
    }

    @Override
    public IRenderRow insertRender(int outputTypeMask, int ownerID, String label, String storeID, String cmPath, String sourcePath, String description, int sourceCode, String drillParams, String burstValue, String saveName, String baseDoc, String smallThumb, String mediumThumb, String largeThumb, int portalItemType, Date creationDate) throws CMException {
        return this.insertRender(outputTypeMask, ownerID, label, storeID, cmPath, sourcePath, description, sourceCode, drillParams, burstValue, saveName, baseDoc, smallThumb, mediumThumb, largeThumb, portalItemType, creationDate, null);
    }

    @Override
    public IRenderRow insertRender(int outputTypeMask, int ownerID, String label, String storeID, String cmPath, String sourcePath, String description, int sourceCode, String drillParams, String burstValue, String saveName, String baseDoc, String smallThumb, String mediumThumb, String largeThumb, int portalItemType, SavedOutputType savedOutputType, Date creationDate) throws CMException {
        int portalItemID = this.portalItemManager.insertPortalItem(label, storeID, cmPath, sourcePath, description, portalItemType);
        return this.renderManager.insertRender(outputTypeMask, ownerID, label, storeID, cmPath, sourcePath, description, sourceCode, drillParams, burstValue, saveName, portalItemID, baseDoc, smallThumb, mediumThumb, largeThumb, portalItemType, savedOutputType, creationDate, null, null);
    }

    @Override
    public IRenderRow insertRender(int outputTypeMask, int ownerID, int sourceCode, String drillParams, String burstValue, int portalItemID, String baseDoc, String smallThumb, String mediumThumb, String largeThumb, SavedOutputType savedOutputType, Date creationDate, String execId) throws CMException {
        return this.renderManager.insertRender(outputTypeMask, ownerID, null, null, null, null, null, sourceCode, drillParams, burstValue, null, portalItemID, baseDoc, smallThumb, mediumThumb, largeThumb, -1, savedOutputType, creationDate, null, execId);
    }

    public IRenderRow insertRender(int outputTypeMask, int ownerID, String label, String storeID, String cmPath, String sourcePath, String description, int sourceCode, String drillParams, String burstValue, String saveName, String baseDoc, String smallThumb, String mediumThumb, String largeThumb, int portalItemType, Date creationDate, int[] targetUserIDs, String execId) throws CMException {
        int portalItemID = this.portalItemManager.insertPortalItem(label, storeID, cmPath, sourcePath, description, portalItemType);
        return this.renderManager.insertRender(outputTypeMask, ownerID, label, storeID, cmPath, sourcePath, description, sourceCode, drillParams, burstValue, saveName, portalItemID, baseDoc, smallThumb, mediumThumb, largeThumb, portalItemType, null, creationDate, targetUserIDs, execId);
    }

    @Override
    public IRenderRow insertRender(int[] targetUserIDs, IRenderRow row) throws CMException {
        if (row.getIntField(RenderRow.RenderField.PORTALITEM_ID) == -1) {
            int portalItemID = this.portalItemManager.insertPortalItem(row.getStringField(RenderRow.RenderField.LABEL), row.getStringField(RenderRow.RenderField.STOREID), row.getStringField(RenderRow.RenderField.CMPATH), row.getStringField(RenderRow.RenderField.SOURCEPATH), row.getStringField(RenderRow.RenderField.DESCRIPTION), row.getIntField(RenderRow.RenderField.PORTALITEM_TYPE));
            row.setField(RenderRow.RenderField.PORTALITEM_ID, portalItemID);
        }
        IRenderRow result = this.renderManager.insertRender(targetUserIDs, row);
        VM.log(CLASS, 0, "inserted render " + row.getIntField(RenderRow.RenderField.RENDERID) + " storeID: " + row.getStringField(RenderRow.RenderField.STOREID) + " CMPath: " + row.getStringField(RenderRow.RenderField.CMPATH));
        return result;
    }

    @Override
    public IRenderRow insertRender(IRenderRow row) throws CMException {
        return this.insertRender(null, row);
    }

    @Override
    public void deleteBlob(int userID) throws CMException {
        this.blobManager.deleteBlob(userID);
    }

    @Override
    public void deleteBlob(String hash, StringBuilder detailsLog) throws CMException {
        this.blobManager.deleteBlob(hash, detailsLog);
    }

    @Override
    public void insertBlob(int userID, byte[] blob) throws CMException {
        this.blobManager.insertBlob(userID, blob);
    }

    @Override
    public int insertBlob(String hash, byte[] blob, int renderID, StringBuilder detailsLog, Connection connection) throws CMException {
        return this.blobManager.insertBlob(hash, blob, renderID, connection);
    }

    @Override
    public byte[] getBlob(int userID) throws CMException {
        return this.blobManager.getBlob(userID);
    }

    @Override
    public byte[] getBlob(String hash) throws CMException {
        return this.blobManager.getBlob(hash);
    }

    @Override
    public boolean blobExists(String hash) throws CMException {
        return this.blobManager.blobExists(hash);
    }

    @Override
    public int blobRecordCount(String hash, int userID, StringBuilder detailsLog) throws CMException {
        return this.blobManager.blobRecordCount(hash, userID, detailsLog);
    }

    @Override
    public byte[] getBlobBytes(ResultSet rs, int column) throws SQLException {
        return this.syncDatabaseManager.getBlobBytes(rs, column);
    }

    @Override
    public Connection getTransactionConnection() throws CMException {
        return this.resourceManager.getTransactionConnection();
    }

    @Override
    public void releaseTransactionConnection(Connection connection) {
        this.resourceManager.releaseTransactionConnection(connection);
    }

    @Override
    public void insertResource(int renderID, String path, String hash, byte[] blob, int format, int height, int width) throws CMException {
        this.resourceManager.insertResource(renderID, path, hash, blob, format, height, width);
    }

    @Override
    public void insertResource(int renderID, String path, String hash, byte[] blob, int format, int height, int width, int blobID, int objectIndex, int pageIndex) throws CMException {
        this.resourceManager.insertResource(renderID, path, hash, blob, format, height, width, blobID, objectIndex, pageIndex);
    }

    @Override
    public void insertResource(int renderID, String path, String hash, int format, int height, int width, Connection connection) throws CMException {
        this.resourceManager.insertResource(renderID, path, hash, format, height, width, connection);
    }

    @Override
    public void insertResource(int renderID, String path, String hash, int format, int height, int width, int blobID, int objectIndex, int pageIndex) throws CMException {
        this.resourceManager.insertResource(renderID, path, hash, format, height, width, blobID, objectIndex, pageIndex);
    }

    @Override
    public boolean resourceHashIsInUsersInbox(String hash, int userID) throws CMException {
        return this.resourceManager.resourceHashIsInUsersInbox(hash, userID);
    }

    @Override
    public ResourceRow[] getResourceList(int renderID, int[] formats) throws CMException {
        return this.resourceManager.getResourceList(renderID, formats);
    }

    @Override
    public ResourceRow getResource(String hash) throws CMException {
        return this.resourceManager.getResource(hash);
    }

    @Override
    public boolean hasResource(int renderId, String path, String hash) throws CMException {
        return this.getResource(renderId, path, hash) != null;
    }

    @Override
    public ResourceRow getResource(int renderId, String path, String hash) throws CMException {
        return this.resourceManager.getResource(renderId, path, hash);
    }

    @Override
    public ResourceRow getResource(int renderID, int blobID, int format, int objectIndex, int page) throws CMException {
        return this.resourceManager.getResource(renderID, blobID, format, objectIndex, page);
    }

    @Override
    public ResourceRow getResource(String path, int renderId) throws CMException {
        return this.resourceManager.getResource(path, renderId);
    }

    @Override
    public byte[] getResourceBytes(String hash) throws CMException {
        return this.resourceManager.getResourceBytes(hash);
    }

    @Override
    public byte[] getResourceBytes(int renderID, int blobID, int format, int objectIndex, int page) throws CMException {
        return this.resourceManager.getResourceBytes(renderID, blobID, format, objectIndex, page);
    }

    @Override
    public int getMaxBlobID(int renderID) throws CMException {
        return this.resourceManager.getMaxBlobID(renderID);
    }

    @Override
    public ISyncDatabase.SyncResultSet getAddedRenders(Connection connection, int userID, int beginRevision, int endRevision) throws CMException {
        return this.syncDatabaseManager.getAddedRenders(connection, userID, beginRevision, endRevision);
    }

    @Override
    public ISyncDatabase.SyncRecentRenders getRecentRenders(Connection connection, int userID, int beginRevision, int endRevision, int maxVersions) throws CMException {
        return this.syncDatabaseManager.getRecentRenders(connection, userID, beginRevision, endRevision, maxVersions);
    }

    @Override
    public void insertRenderIntoInbox(IRenderRow render, int userID) throws CMException {
        this.renderManager.insertRenderIntoInbox(render, userID);
    }

    @Override
    public void setRenderLastViewed(int renderID, int userID) throws CMException {
        this.renderManager.setRenderLastViewed(renderID, userID);
    }

    @Override
    public IRenderRow[] getReportRecentRenders(int userID, String storeID) throws CMException {
        return this.renderManager.getReportRecentRenders(userID, storeID);
    }

    @Override
    public IRenderRow[] getReportSavedRenders(int userID, String storeID) throws CMException {
        return this.renderManager.getReportSavedRenders(userID, storeID);
    }

    @Override
    public int getRenderSize(int renderID) throws CMException {
        return this.renderManager.getRenderSize(renderID);
    }

    @Override
    public void dispose() {
        this.database.dispose();
    }

    @Override
    public List<RenderStatus> findRenderStatusByRenderId(int renderId) throws CMException {
        return this.renderManager.findRenderStatusByRenderId(renderId);
    }

    @Override
    public TempStorageObject createTempStorage() throws CMException {
        return this.tempStorageManager.createTempStorage();
    }

    @Override
    public TempStorageObject createTempStorage(String path, boolean overwrite) throws CMException {
        return this.tempStorageManager.createTempStorage(path, overwrite);
    }

    @Override
    public String[] findAllTempStoragePaths() throws CMException {
        return this.tempStorageManager.findAllTempStoragePaths();
    }

    @Override
    public TempStorageObject findTempStorageById(int id) throws CMException {
        return this.tempStorageManager.findTempStorageById(id);
    }

    @Override
    public TempStorageObject findTempStorageByPath(String path) throws CMException {
        return this.tempStorageManager.findTempStorageByPath(path);
    }

    @Override
    public boolean tempStoragePathExists(int path) throws CMException {
        return this.tempStorageManager.tempStoragePathExists(path);
    }

    @Override
    public void removeTempStorage(TempStorageObject o) throws CMException {
        this.tempStorageManager.removeTempStorage(o);
    }

    @Override
    public void removeAllTempStorage() throws CMException {
        this.tempStorageManager.removeAllTempStorage();
    }

    @Override
    public void removeTempStorageModifiedBefore(Date modified) throws CMException {
        this.tempStorageManager.removeTempStorageModifiedBefore(modified);
    }

    @Override
    public void updateTempStorage(TempStorageObject o) throws CMException {
        this.tempStorageManager.updateTempStorage(o);
    }

    @Override
    public boolean renderIsInUsersInbox(int renderID, int userID) throws CMException {
        boolean result = this.renderManager.renderIsInUsersInbox(renderID, userID);
        if (result) {
            VM.log(CLASS, 0, "renderID " + renderID + " is in users " + userID + " inbox");
        }
        return result;
    }

    @Override
    public void setSyncMethod(String deviceID, int userID, String syncMethod) throws CMException {
        this.deviceManager.setSyncMethod(deviceID, userID, syncMethod);
    }

    @Override
    public void setLastSynced(String deviceID, int userID, Date updateTime) throws CMException {
        this.deviceManager.setLastSynced(deviceID, userID, updateTime);
    }

    @Override
    public String getLastUpdated(int userID) throws CMException {
        return this.userManager.getLastUpdated(userID);
    }

    @Override
    public Date getLastSynced(String deviceID, int userID) throws CMException {
        return this.deviceManager.getLastSynced(deviceID, userID);
    }

    @Override
    public byte[] readCookies(int userid) throws CMException {
        byte[] b = this.blobManager.getBlob(userid);
        if (b == null || b.length == 0) {
            VM.log(CLASS, 0, "no cached cookies for user " + userid);
        } else {
            VM.log(CLASS, 0, "retrieved cookies (" + b.length + " bytes) for user " + userid);
        }
        return b;
    }

    @Override
    public void writeCookies(int userId, byte[] cookies) throws CMException {
        if (userId == 0) {
            VM.log(CLASS, 0, "User ID 0 is not allowed for writeCookies !");
            return;
        }
        this.blobManager.deleteBlob(userId);
        this.blobManager.insertBlob(userId, cookies);
        VM.log(CLASS, 0, "wrote cookies (" + cookies.length + " bytes) for user " + userId);
    }

    @Override
    public HistoryObject createHistory(int[] userID, int eventID, Date timeStamp, String details, int[] renderID) throws CMException {
        return this.historyManager.createHistory(userID, eventID, timeStamp, details, renderID);
    }

    @Override
    public void removeHistoryBefore(Date modified) throws CMException {
        this.historyManager.removeHistoryBefore(modified);
    }

    @Override
    public HistoryObject[] queryHistoryByUser(int userID, int[] eventID, int start, int end) throws CMException {
        return this.historyManager.queryHistoryByUser(userID, eventID, start, end);
    }

    @Override
    public HistoryObject[] getMostRecentViewedByUser(int userID, int number) throws CMException {
        return this.historyManager.getMostRecentViewedByUser(userID, number);
    }

    @Override
    public IRenderRow getLatestDrillTargetRender(int userID, String storeID, String drillParams) throws CMException {
        return this.renderManager.getLatestDrillTargetRender(userID, storeID, drillParams);
    }

    @Override
    public void insertUserPortalItem(int userID, int portalItemID, int resType) throws CMException {
        this.portalItemManager.insertUserPortalItem(userID, portalItemID, resType);
    }

    @Override
    public void removeUserPortalItem(int userID, int portalItemID, int resType) throws CMException {
        this.portalItemManager.removeUserPortalItem(userID, portalItemID, resType);
    }

    @Override
    public PortalItemRow getPortalItem(int portalItemID) throws CMException {
        return this.portalItemManager.getPortalItem(portalItemID);
    }

    @Override
    public PortalItemRow getPortalItem(String storeID, String cmPath, String sourcePath) throws CMException {
        return this.portalItemManager.getPortalItem(storeID, cmPath, sourcePath);
    }

    @Override
    public String getPortalItemLabel(String storeID) throws CMException {
        return this.portalItemManager.getPortalItemLabel(storeID);
    }

    @Override
    public int insertPortalItem(String label, String storeID, String cmPath, String sourcePath, String description, int portalItemType) throws CMException {
        return this.portalItemManager.insertPortalItem(label, storeID, cmPath, sourcePath, description, portalItemType);
    }

    @Override
    public int getPortalItemID(int userID, int resType) throws CMException {
        return this.portalItemManager.getPortalItemID(userID, resType);
    }

    @Override
    public void updateUserPortalItem(int userID, int portalItemID, int resType) throws CMException {
        this.portalItemManager.updateUserPortalItem(userID, portalItemID, resType);
    }

    @Override
    public void insertDrill(int sourceRenderID, int targetRenderID, String drillContext, int drillType) throws CMException {
        this.drillManager.insertDrill(sourceRenderID, targetRenderID, drillContext, drillType);
    }

    @Override
    public DrillRow getDrills(int sourceRenderID, int drillType) throws CMException {
        return this.drillManager.getDrills(sourceRenderID, drillType);
    }

    @Override
    public void insertResource(String hash, int format) throws CMException {
        this.resourceManager.insertResource(hash, format);
    }

    @Override
    public void insertExternalResources(List<ResourceRow> rr) throws CMException {
        this.resourceManager.insertExternalResources(rr);
    }

    @Override
    public void updateRenderRow(IRenderRow render) throws CMException {
        this.renderManager.updateRenderRow(render);
    }

    @Override
    public void removeResource(int renderID, int pageIndex) throws CMException {
        this.resourceManager.removeResource(renderID, pageIndex);
    }

    @Override
    public List<Device> getDevicesByCamID(String camID) throws CMException {
        return this.deviceManager.getDevicesByCamID(camID);
    }

    @Override
    public Device getDevice(String deviceID, int userID) throws CMException {
        return this.deviceManager.getDevice(deviceID, userID);
    }

    @Override
    public void removeDeviceRegisteredBefore(String pushID, Date date) throws CMException {
        this.deviceManager.removeDeviceRegisteredBefore(pushID, date);
    }

    @Override
    public void setPushID(String deviceID, int userID, String pushID) throws CMException {
        this.deviceManager.setPushID(deviceID, userID, pushID);
    }

    @Override
    public void deleteExpiredDevices(long expiryAgeInDays) throws CMException {
        this.deviceManager.deleteExpiredDevices(expiryAgeInDays);
    }

    @Override
    public void updateDevice(String deviceID, int userID, String syncMethod, String pushID) throws CMException {
        this.deviceManager.updateDevice(deviceID, userID, syncMethod, pushID);
    }

    @Override
    public void resetPushIdsForDevice(String deviceID) throws CMException {
        this.deviceManager.resetPushIdsForDevice(deviceID);
    }

    @Override
    public void insertRenderToGroupMapping(int renderID, List<String> groups) throws CMException {
        this.renderGroupManager.insertRenderToGroupMapping(renderID, groups);
    }

    @Override
    public List<IRenderRow> getRendersForGroup(List<String> groups) throws CMException {
        return this.renderGroupManager.getRendersForGroup(groups);
    }

    @Override
    public void deleteRendersForGroups(List<String> groups) throws CMException {
        this.renderGroupManager.deleteRendersForGroups(groups);
    }

    @Override
    public boolean isUIThemeResource(String hash) throws CMException {
        return this.resourceManager.isUIThemeResource(hash);
    }

    @Override
    public LinkedHashMap<String, IRenderRow> getGroupToRenders() throws CMException {
        return this.renderGroupManager.getGroupToRenders();
    }

    @Override
    public void deleteRenderGrouping(int[] renderIDs) throws CMException {
        this.renderGroupManager.deleteRenderGrouping(renderIDs);
    }

    @Override
    public void updateResourceRenderReferences(int oldRenderID, int newRenderID) throws CMException {
        this.resourceManager.updateResourceRenderReferences(oldRenderID, newRenderID);
    }

    @Override
    public IRenderRow[] getRendersBySource(int sourceID) throws CMException {
        return this.renderManager.getRendersBySource(sourceID);
    }
}

