/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.DBOracleDatabaseCalls;
import com.cognos.mobile.database.DBSqlDatabase;
import com.cognos.mobile.database.DatabaseCleaner;
import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.database.ISQLDatabaseCalls;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class DBOracleDatabase
extends DBSqlDatabase {
    public static final String DEFAULT_DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    public static final String DEFAULT_CONNECTION_URL = "jdbc:oracle:thin:@{1}:{2}";
    public static final String DEFAULT_CONNECTION_ADVANCED_URL = "jdbc:oracle:thin:@{1}";
    public static final String KERBEROS_DRIVER_CLASS = "com.ibm.ba.kerberos.OracleKerberosDriver";
    public static final String DEFAULT_CONNECTION_KERBEROS_URL = "jdbc:cognos:oracle:kerb:@{1}";
    private static final int MAX_BLOB_CHUNK_SIZE_BIG = 1000000;
    private static final int MAX_BLOB_CHUNK_SIZE_SMALL = 2000;
    private int oracleBlobChunkSize = -1;

    public DBOracleDatabase(IConnectionPool connectionPool, String driverClass, String connectionUrl, String hostPort, String serviceName, String username, String password, IConfiguration config) throws CMException {
        super(true, connectionPool, driverClass, CMStringHelper.formatString(connectionUrl, new String[]{hostPort, serviceName}), "oracle", username, password, hostPort, serviceName, null, config);
        if (config != null) {
            this.oracleBlobChunkSize = config.getInt("Database.MaxBlobChunkSize", -1);
        }
    }

    public DBOracleDatabase(IConnectionPool connectionPool, String driverClass, String connectionUrl, String hostPort, String serviceName, String username, String password, String specifier, IConfiguration config) throws CMException {
        super(true, connectionPool, driverClass, CMStringHelper.formatString(DEFAULT_CONNECTION_ADVANCED_URL, new String[]{specifier}), "oracle", username, password, hostPort, serviceName, null, config);
        if (config != null) {
            this.oracleBlobChunkSize = config.getInt("Database.MaxBlobChunkSize", -1);
        }
    }

    public DBOracleDatabase(IConnectionPool connectionPool, String driverClass, String connectionUrl, String hostPort, String serviceName, String specifier, Properties props, IConfiguration config) throws CMException {
        super(true, connectionPool, driverClass, CMStringHelper.formatString(DEFAULT_CONNECTION_KERBEROS_URL, new String[]{specifier}), "oracle", null, null, hostPort, serviceName, props, config);
        if (config != null) {
            this.oracleBlobChunkSize = config.getInt("Database.MaxBlobChunkSize", -1);
        }
    }

    @Override
    public int getDatabaseType() {
        return 2;
    }

    @Override
    public int getMaxBlobChunkSize() {
        if (this.oracleBlobChunkSize != -1) {
            return this.oracleBlobChunkSize;
        }
        if (this.getDriverMajorVersion() >= 10 && this.getDriverMinorVersion() >= 2) {
            return 1000000;
        }
        return 2000;
    }

    @Override
    public ISQLDatabaseCalls getDatabaseCalls() {
        if (this.databaseCalls == null) {
            this.databaseCalls = new DBOracleDatabaseCalls(this.m_jdbcLevel, this.getDatabaseType());
        }
        return this.databaseCalls;
    }

    @Override
    public String[] getUserTableNames(Connection connection) throws SQLException {
        ISQLDatabaseCalls calls = this.getDatabaseCalls();
        return calls.getUserTableNames(connection);
    }

    private String[] getDropableTables(Connection connection) throws SQLException {
        String sql = "SELECT DISTINCT TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME NOT IN (   SELECT dest.table_name as dest_table_name   FROM all_constraints src   JOIN all_constraints dest     ON src.owner = dest.owner     AND src.r_constraint_name = dest.constraint_name   WHERE src.constraint_type = 'R' ) ";
        ISQLDatabaseCalls calls = this.getDatabaseCalls();
        return calls.executeQueryToStringArray(connection, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(Connection connection, String tableName) throws SQLException {
        try {
            String sql = "DROP TABLE " + tableName;
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new SQLException("Unable to drop table " + tableName, ex);
        }
    }

    private void dropTables(Connection connection) throws SQLException {
        String[] tables;
        do {
            for (String table : tables = this.getDropableTables(connection)) {
                this.dropTable(connection, table);
            }
        } while (tables.length > 0);
    }

    @Override
    public void clean(Connection connection) throws SQLException {
        this.dropTables(connection);
        DatabaseCleaner cleaner = new DatabaseCleaner(this.getDatabaseCalls());
        cleaner.clean(connection);
    }
}

