/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.DBSqlDatabaseCalls;
import com.cognos.mobile.database.IPreparedStatementParameterizer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBOracleDatabaseCalls
extends DBSqlDatabaseCalls {
    private static final Class CLASS = DBOracleDatabaseCalls.class;
    private static final int MAX_UPDATE_REPEATS = 10;

    public DBOracleDatabaseCalls(int jdbcLvl, int dbType) {
        super(jdbcLvl, dbType);
    }

    @Override
    protected ResultSet executeUpdateCommand(Connection connection, PreparedStatement statement, IPreparedStatementParameterizer pmsp, String sql, String keyTable, String keyField) throws Exception {
        statement = connection.prepareStatement(sql);
        pmsp.parameterize(statement);
        statement.execute();
        statement.close();
        statement = null;
        String selectSql = "select SEQ_" + keyTable + ".currval from dual";
        statement = connection.prepareStatement(selectSql);
        return statement.executeQuery();
    }

    @Override
    public String[] getUserTableNames(Connection connection) throws SQLException {
        String sql = "SELECT TABLE_NAME FROM USER_TABLES";
        return this.executeQueryToStringArray(connection, sql);
    }

    @Override
    public int executeUpdate(Connection connection, String sql, IPreparedStatementParameterizer pmsp, String keyTable, String keyField) throws CMException {
        int repeats = 0;
        while (true) {
            try {
                return super.executeUpdate(connection, sql, pmsp, keyTable, keyField);
            }
            catch (CMException e) {
                if (!this.isDeadlockError(e) || repeats >= 10) {
                    throw e;
                }
                try {
                    Thread.sleep((long)Math.random() * 100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++repeats;
                continue;
            }
            break;
        }
    }

    private boolean isDeadlockError(CMException e) {
        String msg;
        Throwable t;
        boolean ret = false;
        if (e != null && (t = e.getCause()) instanceof SQLException && (msg = t.getMessage()) != null && msg.contains("ORA-00060")) {
            ret = true;
        }
        return ret;
    }
}

