/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.database.IPreparedStatementParameterizer;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.ISQLDatabaseCalls;
import com.cognos.mobile.database.ISyncDatabase;
import com.cognos.mobile.database.SchemaVersion;
import com.cognos.mobile.vm.VM;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;

public abstract class DBSqlDatabase
implements ISQLDatabase,
ConnectionFactory {
    private static final Class<DBSqlDatabase> CLASS = DBSqlDatabase.class;
    private final Object lock = new Object();
    private final String driverClass;
    private final String connectionUrl;
    private String schemaDirectory;
    private final String username;
    private final String password;
    private final String hostPort;
    private final String databaseName;
    private final Properties props;
    private final boolean supportsVaultus;
    private final int maxBlobChunkSize;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private final IConnectionPool connectionPool;
    protected ISQLDatabaseCalls databaseCalls = null;
    Driver driver;
    protected boolean m_haveSniffedMetadata = false;
    protected int m_jdbcLevel;
    private String databaseProductName;
    private boolean disposed = false;

    public DBSqlDatabase(boolean vaultusSupport, IConnectionPool connectionPool, String driverClass, String connectionUrl, String schemaDirectory, String username, String password, String hostPort, String databaseName, Properties props, IConfiguration config) throws CMException {
        this(null, vaultusSupport, connectionPool, driverClass, connectionUrl, schemaDirectory, username, password, hostPort, databaseName, props, config);
    }

    public DBSqlDatabase(ISQLDatabaseCalls calls, boolean vaultusSupport, IConnectionPool connectionPool, String driverClass, String connectionUrl, String schemaDirectory, String username, String password, String hostPort, String databaseName, Properties props, IConfiguration config) throws CMException {
        Class<?> driverClassObject;
        this.databaseCalls = calls;
        this.driver = null;
        this.supportsVaultus = vaultusSupport;
        if (connectionPool == null) {
            throw new IllegalArgumentException("connectionPool can't be null");
        }
        if (driverClass == null || connectionUrl == null) {
            throw new IllegalArgumentException("driverClass, connectionUrl must be non-null");
        }
        try {
            driverClassObject = Class.forName(driverClass);
        }
        catch (Exception ex) {
            String details = "failed to instantiate driver class: " + this.getDriverClass();
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1119, details, (Throwable)ex);
        }
        connectionPool.setConnectionFactory(this);
        this.connectionPool = connectionPool;
        this.driverClass = driverClass;
        this.connectionUrl = connectionUrl;
        this.schemaDirectory = schemaDirectory;
        this.username = username;
        this.password = password;
        this.hostPort = hostPort;
        this.databaseName = databaseName;
        this.props = props;
        this.maxBlobChunkSize = config != null ? config.getInt("Database.MaxBlobChunkSize", 1024) : 1024;
        try {
            this.driver = (Driver)driverClassObject.newInstance();
        }
        catch (Exception e) {
            VM.log(CLASS, 0, "Unable to load jdbc driver, will use DriverManager for establishing database connections. Caused by: " + e.getMessage());
        }
        VM.log(CLASS, 1, "Database driver class: " + this.driverClass);
        VM.log(CLASS, 1, "Database connection URL: " + CMStringHelper.obfuscatePassword(this.connectionUrl));
        VM.log(CLASS, 1, "Database username: " + this.username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        boolean disposeConnectionPool = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.disposed) {
                disposeConnectionPool = true;
            }
            this.disposed = true;
        }
        if (disposeConnectionPool) {
            this.connectionPool.dispose();
        }
        VM.log(CLASS, 1, "disposed SQL database resources");
    }

    @Override
    public String getDriverClass() throws CMException {
        this.throwIfDisposed();
        return this.driverClass;
    }

    @Override
    public String getDatabaseProductName() throws CMException {
        this.throwIfDisposed();
        return this.databaseProductName;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public int getDownloadRowSize() {
        return 250;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public Properties getProperties() {
        return this.props;
    }

    @Override
    public String getSchemaDirectory() {
        return this.schemaDirectory;
    }

    protected void setSchemaDirectory(String schemaDirectory) {
        this.schemaDirectory = schemaDirectory;
    }

    @Override
    public IConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public String getHostPort() throws CMException {
        this.throwIfDisposed();
        if (this.hostPort == null) {
            throw new CMException(1146, "host/port not configured");
        }
        return this.hostPort;
    }

    @Override
    public String getDatabaseName() throws CMException {
        this.throwIfDisposed();
        if (this.databaseName == null) {
            throw new CMException(1146, "database name not configured");
        }
        return this.databaseName;
    }

    @Override
    public void executeQuery(String sql, IResultSetAccumulator accumulator) throws CMException {
        this.executeQuery(null, sql, accumulator);
    }

    @Override
    public void executeQuery(Connection cxn, String sql, IResultSetAccumulator accumulator) throws CMException {
        this.executeQuery(cxn, sql, accumulator, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Connection cxn, String sql, IResultSetAccumulator accumulator, int attempt) throws CMException {
        block7: {
            this.throwIfDisposed();
            Connection connection = null;
            try {
                connection = this.setupConnection(cxn);
                this.getDatabaseCalls().executeQuery(connection, sql, accumulator);
            }
            catch (Exception t) {
                if (this.retry(t, connection, attempt)) {
                    this.executeQuery(null, sql, accumulator, attempt + 1);
                    break block7;
                }
                String details = "query failed";
                VM.log(CLASS, 0, details, t);
                throw new CMException(1120, details, (Throwable)t);
            }
            finally {
                if (cxn == null) {
                    this.quietlyReleaseConnection(connection);
                }
            }
        }
    }

    private boolean retry(Exception t, Connection connection, int attempt) {
        SQLException se;
        String sqlState;
        if (attempt == 0 && t instanceof SQLException && (sqlState = (se = (SQLException)t).getSQLState()) != null && sqlState.startsWith("08")) {
            this.connectionPool.releaseConnection(connection);
            return true;
        }
        return false;
    }

    @Override
    public void executeQuery(String sql, IPreparedStatementParameterizer ipsp, IResultSetAccumulator accumulator) throws CMException {
        this.executeQuery(null, sql, ipsp, accumulator);
    }

    @Override
    public void executeQuery(Connection cxn, String sql, IPreparedStatementParameterizer ipsp, IResultSetAccumulator accumulator) throws CMException {
        this.executeQuery(cxn, sql, ipsp, accumulator, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Connection cxn, String sql, IPreparedStatementParameterizer ipsp, IResultSetAccumulator accumulator, int attempt) throws CMException {
        block7: {
            this.throwIfDisposed();
            Connection connection = null;
            try {
                connection = this.setupConnection(cxn);
                this.getDatabaseCalls().executeQuery(connection, sql, ipsp, accumulator);
            }
            catch (Exception t) {
                if (this.retry(t, connection, attempt)) {
                    this.executeQuery(null, sql, ipsp, accumulator, attempt + 1);
                    break block7;
                }
                String details = "query failed";
                VM.log(CLASS, 0, details, t);
                throw new CMException(1120, details, (Throwable)t);
            }
            finally {
                if (cxn == null) {
                    this.quietlyReleaseConnection(connection);
                }
            }
        }
    }

    @Override
    public void executeInsert(String sql, IPreparedStatementParameterizer pmsp) throws CMException {
        this.executeInsert(null, sql, pmsp);
    }

    @Override
    public void executeCommittedInsert(String sql, IPreparedStatementParameterizer pmsp) throws CMException {
        this.throwIfDisposed();
        Connection connection = null;
        try {
            connection = this.getTransactionConnection();
            connection.setAutoCommit(false);
            this.executeInsert(connection, sql, pmsp);
            connection.commit();
        }
        catch (CMException t) {
            throw t;
        }
        catch (Exception t) {
            String details = "problem creating/committing query connection";
            VM.log(CLASS, 0, details, t);
            throw new CMException(1120, details, (Throwable)t);
        }
        finally {
            if (connection != null) {
                this.releaseTransactionConnection(connection);
            }
        }
    }

    public void executeInsert(Connection cxn, String sql, IPreparedStatementParameterizer pmsp) throws CMException {
        this.executeInsert(cxn, sql, pmsp, 0);
    }

    public void executeInsert(Connection cxn, String sql, IPreparedStatementParameterizer pmsp, int attempt) throws CMException {
        block16: {
            this.throwIfDisposed();
            PreparedStatement statement = null;
            Connection connection = null;
            try {
                connection = this.setupConnection(cxn);
                boolean useBatch = pmsp.useBatch() && this.m_jdbcLevel >= 3;
                statement = connection.prepareStatement(sql, 1);
                boolean executed = false;
                while (pmsp.parameterize(statement)) {
                    if (useBatch) {
                        statement.addBatch();
                        continue;
                    }
                    statement.execute();
                    executed = true;
                }
                if (!useBatch && !executed) {
                    statement.executeUpdate();
                } else if (pmsp.useBatch()) {
                    statement.addBatch();
                    statement.executeBatch();
                }
            }
            catch (SQLException se) {
                SQLException ne;
                if (this.retry(se, connection, attempt)) {
                    this.executeInsert(null, sql, pmsp, attempt + 1);
                    break block16;
                }
                VM.log(CLASS, 0, "update failed", se);
                VM.log(CLASS, 3, "Got SQL Exception: " + se.getMessage());
                if (ne != null) {
                    StringBuilder builder = new StringBuilder();
                    for (ne = se.getNextException(); ne != null; ne = ne.getNextException()) {
                        builder.append(ne.getMessage());
                        builder.append("\n");
                        VM.log(CLASS, 3, "Next exception: " + ne.getMessage());
                    }
                    throw new CMException(1121, builder.toString(), (Throwable)se);
                }
                throw new CMException(1121, "update failed", (Throwable)se);
            }
            catch (Exception t) {
                VM.log(CLASS, 0, "update failed", t);
                throw new CMException(1121, "update failed", (Throwable)t);
            }
            finally {
                if (cxn == null) {
                    this.quietlyReleaseConnection(connection);
                }
            }
        }
    }

    @Override
    public int executeUpdate(String sql, IPreparedStatementParameterizer pmsp, String keyTable, String keyField) throws CMException {
        return this.executeUpdate(null, sql, pmsp, keyTable, keyField);
    }

    @Override
    public int executeCommittedUpdate(String sql, IPreparedStatementParameterizer pmsp, String keyTable, String keyField) throws CMException {
        this.throwIfDisposed();
        Connection connection = null;
        try {
            connection = this.getTransactionConnection();
            connection.setAutoCommit(false);
            int id = this.executeUpdate(connection, sql, pmsp, keyTable, keyField);
            connection.commit();
            int n = id;
            return n;
        }
        catch (CMException t) {
            throw t;
        }
        catch (Exception t) {
            String details = "problem creating/committing query connection";
            VM.log(CLASS, 0, details, t);
            throw new CMException(1120, details, (Throwable)t);
        }
        finally {
            if (connection != null) {
                this.releaseTransactionConnection(connection);
            }
        }
    }

    @Override
    public int executeUpdate(Connection cxn, String sql, IPreparedStatementParameterizer pmsp, String keyTable, String keyField) throws CMException {
        return this.executeUpdate(cxn, sql, pmsp, keyTable, keyField, 0);
    }

    public int executeUpdate(Connection cxn, String sql, IPreparedStatementParameterizer pmsp, String keyTable, String keyField, int attempt) throws CMException {
        this.throwIfDisposed();
        Connection connection = null;
        try {
            connection = this.setupConnection(cxn);
            int n = this.getDatabaseCalls().executeUpdate(connection, sql, pmsp, keyTable, keyField);
            return n;
        }
        catch (CMException ex) {
            throw ex;
        }
        catch (Exception e) {
            if (this.retry(e, connection, attempt)) {
                int n = this.executeUpdate(null, sql, pmsp, keyTable, keyField, attempt + 1);
                return n;
            }
            String details = "failed to get connection from connection pool.";
            VM.log(CLASS, 3, details);
            throw new CMException(1013, details, (Throwable)e);
        }
        finally {
            if (cxn == null) {
                this.quietlyReleaseConnection(connection);
            }
        }
    }

    @Override
    public void execute(String sql) throws CMException {
        this.execute(null, sql, 0);
    }

    @Override
    public void execute(Connection cxn, String sql) throws CMException {
        this.execute(cxn, sql, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection cxn, String sql, int attempt) throws CMException {
        block7: {
            this.throwIfDisposed();
            Connection connection = null;
            try {
                connection = this.setupConnection(cxn);
                this.getDatabaseCalls().execute(connection, sql);
            }
            catch (Exception t) {
                if (this.retry(t, connection, attempt)) {
                    this.execute(null, sql, attempt++);
                    break block7;
                }
                String details = "command failed: '" + sql + "'";
                VM.log(CLASS, 0, details, t);
                throw new CMException(1121, details, (Throwable)t);
            }
            finally {
                if (cxn == null) {
                    this.quietlyReleaseConnection(connection);
                }
            }
        }
    }

    @Override
    public void executeScript(File script) throws CMException {
        this.executeScript(script, null);
    }

    @Override
    public void executeScript(File script, Connection cxn) throws CMException {
        this.throwIfDisposed();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(script));
            StringBuffer command = null;
            while ((line = br.readLine()) != null) {
                boolean commandExecuted = false;
                if ((line = line.trim()).startsWith("--")) continue;
                switch (this.getDatabaseType()) {
                    case 1: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: {
                        if (!line.equalsIgnoreCase("go") || command == null) break;
                        this.execute(cxn, command.toString());
                        command = null;
                        commandExecuted = true;
                        break;
                    }
                    case 6: 
                    case 8: 
                    case 10: {
                        if (!line.endsWith(";")) break;
                        line = line.substring(0, line.length() - 1);
                        if (command == null) {
                            this.execute(cxn, line);
                        } else {
                            this.execute(cxn, command.toString() + line);
                        }
                        command = null;
                        commandExecuted = true;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (!line.equalsIgnoreCase("/") || command == null) break;
                        this.execute(cxn, command.toString().trim());
                        command = null;
                        commandExecuted = true;
                    }
                }
                if (commandExecuted) continue;
                if (command == null) {
                    command = new StringBuffer();
                }
                command.append(line);
                command.append("\n");
            }
            if (command != null) {
                line = command.toString().trim();
                if (line.length() > 0) {
                    this.execute(cxn, line);
                }
                command = null;
            }
        }
        catch (Exception ex) {
            String details = "execution of script '" + script.getAbsolutePath() + "' failed";
            VM.log(CLASS, 0, details, ex);
            throw new CMException(1121, details, (Throwable)ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void executePreparedStatement(String sql, IPreparedStatementParameterizer ipsp, StringBuilder detailsLog) throws CMException {
        this.executePreparedStatement(null, sql, ipsp, detailsLog);
    }

    @Override
    public void executePreparedStatement(Connection cxn, String sql, IPreparedStatementParameterizer ipsp, StringBuilder detailsLog) throws CMException {
        this.executePreparedStatement(cxn, sql, ipsp, 0, detailsLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePreparedStatement(Connection cxn, String sql, IPreparedStatementParameterizer ipsp, int attempt, StringBuilder detailsLog) throws CMException {
        block7: {
            this.throwIfDisposed();
            Connection connection = null;
            try {
                connection = this.setupConnection(cxn);
                this.getDatabaseCalls().executePreparedStatement(connection, sql, ipsp, detailsLog);
            }
            catch (Exception t) {
                if (this.retry(t, connection, attempt)) {
                    this.executePreparedStatement(null, sql, ipsp, attempt++, detailsLog);
                    break block7;
                }
                String msg = "command failed: '" + sql + "'";
                VM.log(CLASS, 0, msg, t);
                throw new CMException(1121, msg, (Throwable)t);
            }
            finally {
                if (cxn == null) {
                    this.quietlyReleaseConnection(connection);
                }
            }
        }
    }

    @Override
    public void executeBatchedPreparedStatement(String sql, IPreparedStatementParameterizer ipsp, int batchSize, StringBuilder detailsLog) throws CMException {
        this.executeBatchedPreparedStatement(null, sql, ipsp, batchSize, detailsLog);
    }

    @Override
    public void executeBatchedPreparedStatement(Connection cxn, String sql, IPreparedStatementParameterizer ipsp, int batchSize, StringBuilder detailsLog) throws CMException {
        this.executeBatchedPreparedStatement(cxn, sql, ipsp, 0, batchSize, detailsLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatchedPreparedStatement(Connection cxn, String sql, IPreparedStatementParameterizer ipsp, int attempt, int batchSize, StringBuilder detailsLog) throws CMException {
        block15: {
            this.throwIfDisposed();
            Connection connection = null;
            boolean supportsBatched = false;
            try {
                connection = this.setupConnection(cxn);
                supportsBatched = this.supportsBatchUpdates(connection);
                if (supportsBatched) {
                    boolean doCommit;
                    if (cxn != null) {
                        doCommit = false;
                    } else {
                        doCommit = true;
                        connection.setAutoCommit(false);
                    }
                    this.getDatabaseCalls().executeBatchedPreparedStatement(connection, sql, ipsp, batchSize, detailsLog, doCommit);
                } else {
                    this.getDatabaseCalls().executePreparedStatement(connection, sql, ipsp, detailsLog);
                }
            }
            catch (Exception t) {
                if (this.retry(t, connection, attempt)) {
                    if (this.supportsBatchUpdates(connection)) {
                        this.executeBatchedPreparedStatement(connection, sql, ipsp, attempt++, batchSize, detailsLog);
                    } else {
                        this.executePreparedStatement(null, sql, ipsp, attempt++, detailsLog);
                    }
                    break block15;
                }
                String msg = "command failed: '" + sql + "'";
                VM.log(CLASS, 0, msg, t);
                throw new CMException(1121, msg, (Throwable)t);
            }
            finally {
                if (cxn == null) {
                    if (supportsBatched) {
                        this.releaseTransactionConnection(connection);
                    } else {
                        this.quietlyReleaseConnection(connection);
                    }
                }
            }
        }
    }

    private boolean supportsBatchUpdates(Connection connection) {
        try {
            DatabaseMetaData dbmd;
            if (connection != null && (dbmd = connection.getMetaData()) != null) {
                if (dbmd.supportsBatchUpdates()) {
                    VM.log(CLASS, 0, "JDBC driver supports batch updates");
                    return true;
                }
                VM.log(CLASS, 0, "JDBC driver does not support batch updates");
            }
        }
        catch (SQLException ex) {
            VM.log(CLASS, 0, "JDBC driver 'supportsBatchUpdates' method threw exception", ex);
        }
        catch (AbstractMethodError err) {
            VM.log(CLASS, 0, "JDBC driver does not support JDBC 2.0 'supportsBatchUpdates' method", err);
        }
        return false;
    }

    @Override
    public ISyncDatabase.SyncResultSet createScrollableResultSet(Connection connection, String sql) throws CMException {
        return this.createScrollableResultSet(connection, sql, 0);
    }

    public ISyncDatabase.SyncResultSet createScrollableResultSet(Connection connection, String sql, int attempt) throws CMException {
        this.throwIfDisposed();
        ISyncDatabase.SyncResultSet rc = new ISyncDatabase.SyncResultSet();
        try {
            SQLWarning warning;
            rc.statement = connection.createStatement(1004, 1007);
            rc.resultSet = rc.statement.executeQuery(sql);
            for (warning = connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                VM.log(CLASS, 2, "connection warning: " + warning.getMessage());
            }
            for (warning = rc.statement.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                VM.log(CLASS, 2, "statement warning: " + warning.getMessage());
            }
            for (warning = rc.resultSet.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                VM.log(CLASS, 2, "resultSet warning: " + warning.getMessage());
            }
        }
        catch (Exception t) {
            if (this.retry(t, connection, attempt)) {
                return this.createScrollableResultSet(null, sql, attempt++);
            }
            String details = "query failed";
            VM.log(CLASS, 0, details, t);
            DBSqlDatabase.quietlyCloseStatement(rc.statement);
            DBSqlDatabase.quietlyCloseResultSet(rc.resultSet);
            throw new CMException(1120, details, (Throwable)t);
        }
        return rc;
    }

    @Override
    public byte[] getBlobBytes(ResultSet rs, int column) throws SQLException {
        byte[] bytes = null;
        Blob blob = rs.getBlob(column);
        if (blob != null) {
            int len = (int)blob.length();
            bytes = blob.getBytes(1L, len);
        }
        return bytes;
    }

    @Override
    public SchemaVersion getSchemaVersion(String username) throws CMException {
        return this.getSchemaVersion(null, username);
    }

    @Override
    public SchemaVersion getSchemaVersion(Connection cxn, String username) throws CMException {
        this.throwIfDisposed();
        SchemaVersion schemaVersion = new SchemaVersion(0, 0);
        Connection connection = null;
        try {
            connection = this.setupConnection(cxn);
            try {
                schemaVersion = this.getDatabaseCalls().getSchemaVersion(connection);
            }
            catch (SQLException se) {
                if (cxn == null) {
                    this.connectionPool.returnConnection(connection);
                    connection = this.connectionPool.getConnection();
                } else {
                    this.connectionPool.returnConnection(cxn);
                    connection = cxn = this.connectionPool.getConnection();
                }
                schemaVersion = this.getDatabaseCalls().getSchemaVersion(username, connection);
            }
        }
        catch (SQLException se) {
            VM.log(CLASS, 0, "couldn't read schema version from database: SQL state '" + se.getSQLState() + "', '" + se.getMessage() + "'");
            throw new CMException(2017, "couldn't read schema version", (Throwable)se);
        }
        catch (Exception e) {
            VM.log(CLASS, 0, "couldn't obtain db schema version: " + e.getMessage());
            throw new CMException(1120, "couldn't obtain db schema version: " + e.getMessage());
        }
        finally {
            if (cxn == null) {
                this.quietlyReleaseConnection(connection);
            }
        }
        return schemaVersion;
    }

    @Override
    public void updateSchemaVersion(int major, int minor) throws CMException {
        this.updateSchemaVersion(null, major, minor, "");
    }

    @Override
    public void updateSchemaVersion(int major, int minor, String subminor) throws CMException {
        this.updateSchemaVersion(null, major, minor, subminor);
    }

    @Override
    public void updateSchemaVersion(Connection cxn, int major, int minor) throws CMException {
        this.updateSchemaVersion(cxn, major, minor, "");
    }

    @Override
    public void updateSchemaVersion(Connection cxn, int major, int minor, String subminor) throws CMException {
        Connection connection = null;
        try {
            connection = this.setupConnection(cxn);
            this.getDatabaseCalls().updateSchemaVersion(connection, major, minor, subminor);
        }
        catch (Exception e) {
            VM.log(CLASS, 0, "couldn't update db schema version: " + e.getMessage());
            throw new CMException(1121, "failed to update mobile schema version: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (cxn == null) {
                this.quietlyReleaseConnection(connection);
            }
        }
    }

    @Override
    public void updateSchemaVersion(Connection connection, SchemaVersion schemaVersion) throws CMException {
        this.updateSchemaVersion(connection, schemaVersion.getMajor(), schemaVersion.getMinor(), schemaVersion.getSubminor());
    }

    @Override
    public Connection getConnection() throws CMException {
        Connection connection;
        block2: {
            this.throwIfDisposed();
            int attempt = 0;
            connection = null;
            try {
                connection = this.setupConnection(null);
            }
            catch (Exception e) {
                if (this.retry(e, connection, attempt)) break block2;
                String details = "failed to get connection from connection pool.";
                VM.log(CLASS, 3, details);
                throw new CMException(1013, details, (Throwable)e);
            }
        }
        return connection;
    }

    private Connection setupConnection(Connection cxn) throws Exception {
        Connection connection = cxn == null ? this.connectionPool.getConnection() : cxn;
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws SQLException {
        String logMessage;
        Connection con;
        if (this.getUsername() == null || this.getUsername().length() == 0 || this.getPassword() == null || this.getPassword().length() == 0) {
            if (this.getProperties() == null) {
                con = DriverManager.getConnection(this.getConnectionUrl());
            } else if (this.driverClass.equals("com.ibm.ba.kerberos.OracleKerberosDriver")) {
                logMessage = "Oracle Kerberos connection - Properties:";
                for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                    logMessage = logMessage + " " + entry.getKey() + ": " + entry.getValue();
                }
                VM.log(CLASS, 0, logMessage);
                try {
                    con = this.driver.connect(this.getConnectionUrl(), this.props);
                }
                catch (Exception e) {
                    try {
                        con = this.driver.connect(this.getConnectionUrl(), this.props);
                    }
                    catch (Exception e2) {
                        VM.log(CLASS, 3, "Driver connection failed due to: " + e2.getMessage());
                        con = DriverManager.getConnection(this.getConnectionUrl(), this.props);
                    }
                }
            } else {
                con = DriverManager.getConnection(this.getConnectionUrl(), this.props);
            }
        } else if (this.getProperties() != null) {
            logMessage = this.driverClass + " connection - Properties:";
            for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                logMessage = logMessage + " " + entry.getKey() + ": " + entry.getValue();
            }
            VM.log(CLASS, 0, logMessage);
            this.props.put("user", this.getUsername());
            this.props.put("password", this.getPassword());
            try {
                con = this.driver.connect(this.getConnectionUrl(), this.props);
            }
            catch (Exception e) {
                try {
                    con = this.driver.connect(this.getConnectionUrl(), this.props);
                }
                catch (Exception e2) {
                    VM.log(CLASS, 3, "Driver connection failed due to: " + e2.getMessage());
                    con = DriverManager.getConnection(this.getConnectionUrl(), this.props);
                }
            }
        } else {
            con = DriverManager.getConnection(this.getConnectionUrl(), this.getUsername(), this.getPassword());
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.m_haveSniffedMetadata) {
                try {
                    this.readMetadata(this, con);
                    this.m_haveSniffedMetadata = true;
                }
                catch (CMException e) {
                    VM.log(CLASS, 2, "couldn't obtain DB metadata", e);
                }
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwIfDisposed() throws CMException {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed) {
                throw new CMException(1155);
            }
        }
    }

    public void readMetadata(ISQLDatabase database, Connection connection) throws CMException {
        DatabaseMetaData metadata;
        try {
            metadata = connection.getMetaData();
            String driverName = metadata.getDriverName() + " " + metadata.getDriverVersion();
            this.databaseProductName = metadata.getDatabaseProductName() + " " + metadata.getDatabaseProductVersion();
            VM.log(CLASS, 1, "JDBC driver: " + driverName);
            VM.log(CLASS, 1, "Database: " + this.databaseProductName);
        }
        catch (SQLException ex) {
            String msg = "failed to get JDBC metadata";
            VM.log(CLASS, 0, msg, ex);
            throw new CMException(1119, "couldn't get JDBC metadata", (Throwable)ex);
        }
        try {
            this.driverMajorVersion = metadata.getDriverMajorVersion();
            this.driverMinorVersion = metadata.getDriverMinorVersion();
        }
        catch (Exception e) {
            this.driverMajorVersion = 0;
            this.driverMinorVersion = 0;
        }
        try {
            this.m_jdbcLevel = metadata.getJDBCMajorVersion();
        }
        catch (AbstractMethodError ex) {
            this.m_jdbcLevel = 2;
        }
        catch (SQLException ex) {
            VM.log(CLASS, 2, "failed to sniff JDBC level; assuming 2.0");
            this.m_jdbcLevel = 2;
        }
        this.databaseProductName = this.databaseProductName.toLowerCase();
        if (database.getDatabaseType() == 2 && this.m_jdbcLevel >= 3 || database.getDatabaseType() == 3) {
            VM.log(CLASS, 2, "using Oracle or DB2 universal driver; assuming JDBC 2.0 instead of " + this.m_jdbcLevel);
            this.m_jdbcLevel = 2;
        }
    }

    @Override
    public final boolean supportsVaultus() {
        return this.supportsVaultus;
    }

    @Override
    public int getMaxBlobChunkSize() {
        return this.maxBlobChunkSize;
    }

    @Override
    public void setBlobSpecial(PreparedStatement statement, int paramIndex, byte[] blobArray, int startByte, int length, StringBuilder detailsLog) throws SQLException {
        statement.setBinaryStream(paramIndex, (InputStream)new ByteArrayInputStream(blobArray, startByte, length), length);
    }

    @Override
    public Connection getTransactionConnection() throws Exception {
        Connection cxn = this.connectionPool.getConnection();
        cxn.setAutoCommit(false);
        return cxn;
    }

    @Override
    public void releaseTransactionConnection(Connection cxn) {
        try {
            this.connectionPool.returnConnection(cxn);
        }
        catch (Exception ex) {
            VM.log(CLASS, 2, "Exception caught when trying to return transaction connection to the pool.");
        }
    }

    @Override
    public void quietlyReleaseConnection(Connection connection) {
        if (connection != null) {
            try {
                this.connectionPool.returnConnection(connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void quietlyCloseStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void quietlyCloseResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public abstract ISQLDatabaseCalls getDatabaseCalls();
}

