/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.IPreparedStatementParameterizer;
import com.cognos.mobile.database.IResultSetAccumulator;
import com.cognos.mobile.database.ISQLDatabaseCalls;
import com.cognos.mobile.database.SchemaVersion;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;

public abstract class DBSqlDatabaseCalls
implements ISQLDatabaseCalls {
    private static final Class<DBSqlDatabaseCalls> CLASS = DBSqlDatabaseCalls.class;
    protected static final String MOB_SCHEMA_VERSION_TABLE_NAME = "MOB_SCHEMA_VERSION";
    protected static final String[] TABLE_PARAM = new String[]{"TABLE"};
    protected static final String SELECT_FROM_MOB_SCHEMA_VERSION = "select * from MOB_SCHEMA_VERSION";
    protected int jdbcLevel;
    protected int databaseType;

    public DBSqlDatabaseCalls(int jdbcLvl, int dbType) {
        this.jdbcLevel = jdbcLvl;
        this.databaseType = dbType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Connection connection, String sql) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(sql);
        }
        finally {
            this.quietlyCloseStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executePreparedStatement(Connection connection, String sql, IPreparedStatementParameterizer ipsp, StringBuilder detailsLog) throws Exception {
        PreparedStatement statement = null;
        int count = 0;
        try {
            statement = connection.prepareStatement(sql);
            while (ipsp.parameterize(statement)) {
                if ((count += statement.executeUpdate()) != 0) continue;
                String msg = "Insert failed for:" + sql;
                if (detailsLog != null) {
                    detailsLog.append(msg).append("\n");
                }
                VM.log(CLASS, 0, msg);
            }
        }
        finally {
            this.quietlyCloseStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBatchedPreparedStatement(Connection connection, String sql, IPreparedStatementParameterizer ipsp, int batchSize, StringBuilder detailsLog, boolean doCommit) throws Exception {
        PreparedStatement statement = null;
        int[] totalAdded = new int[]{};
        try {
            int[] added;
            statement = connection.prepareStatement(sql);
            int count = 0;
            while (ipsp.parameterize(statement)) {
                statement.addBatch();
                if (++count % batchSize != 0) continue;
                added = statement.executeBatch();
                totalAdded = ArrayUtils.addAll((int[])totalAdded, (int[])added);
                statement.clearBatch();
            }
            added = statement.executeBatch();
            if (doCommit) {
                connection.commit();
            }
            totalAdded = ArrayUtils.addAll((int[])totalAdded, (int[])added);
        }
        finally {
            for (int i = 0; i < totalAdded.length; ++i) {
                if (totalAdded[i] != 0) continue;
                String msg = "Insert failed for:" + sql + " record:" + i;
                if (detailsLog != null) {
                    detailsLog.append(msg).append("\n");
                }
                VM.log(CLASS, 0, msg);
            }
            this.quietlyCloseStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(Connection connection, String sql, IPreparedStatementParameterizer ipsp, IResultSetAccumulator accumulator) throws Exception {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            IResultSetAccumulator.Action action;
            statement = connection.prepareStatement(sql);
            ipsp.parameterize(statement);
            resultSet = statement.executeQuery();
            while (resultSet.next() && (action = accumulator.accumulate(resultSet)) != IResultSetAccumulator.STOP) {
            }
            this.quietlyCloseStatement(statement);
            this.quietlyCloseResultSet(resultSet);
        }
        catch (Throwable throwable) {
            this.quietlyCloseStatement(statement);
            this.quietlyCloseResultSet(resultSet);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(Connection connection, String sql, IResultSetAccumulator accumulator) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                IResultSetAccumulator.Action action = accumulator.accumulate(resultSet);
                if (action != IResultSetAccumulator.STOP) continue;
                break;
            }
        }
        finally {
            this.quietlyCloseStatement(statement);
            this.quietlyCloseResultSet(resultSet);
        }
    }

    @Override
    public String[] executeQueryToStringArray(Connection connection, String sql) throws SQLException {
        class ListAccumulator
        extends IResultSetAccumulator {
            LinkedList<String> list = new LinkedList();

            ListAccumulator() {
            }

            @Override
            public IResultSetAccumulator.Action accumulate(ResultSet resultSet) throws SQLException {
                String data = resultSet.getString(1);
                this.list.add(data);
                return CONTINUE;
            }
        }
        ListAccumulator accumulator = new ListAccumulator();
        try {
            this.executeQuery(connection, sql, accumulator);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        int size = accumulator.list.size();
        Iterator iter = accumulator.list.iterator();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)iter.next();
        }
        return result;
    }

    @Override
    public int executeUpdate(Connection connection, String sql, IPreparedStatementParameterizer pmsp, String keyTable, String keyField) throws CMException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            if (this.jdbcLevel >= 3 && (this.databaseType != 10 || keyField != null)) {
                statement = connection.prepareStatement(sql, 1);
                pmsp.parameterize(statement);
                statement.executeUpdate();
                resultSet = statement.getGeneratedKeys();
            } else if (keyTable != null && keyField != null) {
                resultSet = this.executeUpdateCommand(connection, statement, pmsp, sql, keyTable, keyField);
            } else {
                statement = connection.prepareStatement(sql);
                pmsp.parameterize(statement);
                statement.execute();
                resultSet = null;
            }
        }
        catch (Exception t) {
            VM.log(CLASS, 0, "update failed", t);
            this.quietlyCloseResultSet(resultSet);
            this.quietlyCloseStatement(statement);
            throw new CMException(1121, "update failed", (Throwable)t);
        }
        try {
            int t = this.getKeyValueFromUpdateResultSet(resultSet);
            return t;
        }
        catch (SQLException ex) {
            String details = "failed to find auto-generated new value for " + keyField + " in resultset";
            VM.log(CLASS, 0, details);
            throw new CMException(1140, details);
        }
        finally {
            this.quietlyCloseResultSet(resultSet);
            this.quietlyCloseStatement(statement);
        }
    }

    protected ResultSet executeUpdateCommand(Connection connection, PreparedStatement statement, IPreparedStatementParameterizer pmsp, String sql, String keyTable, String keyField) throws Exception {
        statement = connection.prepareStatement(sql);
        pmsp.parameterize(statement);
        statement.execute();
        statement.close();
        statement = null;
        String selectSql = "select max(?) from ?";
        statement = connection.prepareStatement(selectSql);
        statement.setString(1, keyField);
        statement.setString(2, keyTable);
        return statement.executeQuery();
    }

    private int getKeyValueFromUpdateResultSet(ResultSet resultSet) throws SQLException {
        int autoGenKeyID;
        if (resultSet != null) {
            if (!resultSet.next()) {
                throw new SQLException();
            }
            autoGenKeyID = resultSet.getInt(1);
        } else {
            autoGenKeyID = -1;
        }
        return autoGenKeyID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSchemaVersion(Connection connection, int major, int minor, String subminor) throws SQLException {
        PreparedStatement statement = null;
        try {
            String sql = "UPDATE MOB_SCHEMA_VERSION SET MAJOR=?, MINOR=?, SUBMINOR=?";
            statement = connection.prepareStatement(sql);
            statement.setInt(1, major);
            statement.setInt(2, minor);
            statement.setString(3, subminor);
            statement.executeUpdate();
            this.quietlyCloseStatement(statement);
        }
        catch (Throwable throwable) {
            this.quietlyCloseStatement(statement);
            throw throwable;
        }
    }

    @Override
    public SchemaVersion getSchemaVersion(Connection connection) throws SQLException {
        return this.getSchemaVersion(null, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaVersion getSchemaVersion(String username, Connection connection) throws SQLException {
        Statement statement = null;
        ResultSet tables = null;
        ResultSet resultSet = null;
        SchemaVersion schemaVersion = new SchemaVersion(0, 0);
        try {
            DatabaseMetaData dbm = connection.getMetaData();
            tables = dbm.getTables(null, username, MOB_SCHEMA_VERSION_TABLE_NAME, TABLE_PARAM);
            if (tables.next()) {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(SELECT_FROM_MOB_SCHEMA_VERSION);
                if (resultSet.next()) {
                    String subminor;
                    int major = resultSet.getInt(1);
                    int minor = resultSet.getInt(2);
                    try {
                        subminor = resultSet.getString(3);
                    }
                    catch (Exception e) {
                        subminor = "NEW";
                    }
                    schemaVersion = new SchemaVersion(major, minor, subminor);
                }
                boolean secondRow = false;
                try {
                    secondRow = resultSet.next();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (secondRow) {
                    throw new SQLException("ERROR!  SELECT * FROM MOB_SCHEMA_VERSION table returned more than 1 row.  Aborting...");
                }
            }
            this.quietlyCloseResultSet(tables);
            this.quietlyCloseResultSet(resultSet);
            this.quietlyCloseStatement(statement);
        }
        catch (Throwable throwable) {
            this.quietlyCloseResultSet(tables);
            this.quietlyCloseResultSet(resultSet);
            this.quietlyCloseStatement(statement);
            throw throwable;
        }
        return schemaVersion;
    }

    protected void quietlyCloseStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void quietlyCloseResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

