/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.database.DBSqlDatabase;
import com.cognos.mobile.database.DBSqlServerDatabaseCalls;
import com.cognos.mobile.database.DatabaseCleaner;
import com.cognos.mobile.database.IConnectionPool;
import com.cognos.mobile.database.ISQLDatabaseCalls;
import com.cognos.mobile.vm.VM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class DBSqlServerDatabase
extends DBSqlDatabase {
    private static final Class CLASS = DBSqlServerDatabase.class;
    public static final String DEFAULT_DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String DEFAULT_CONNECTION_URL = "jdbc:sqlserver://{1};databaseName={2}";
    public static final String DEFAULT_TRUSTED_CONNECTION_URL = "jdbc:sqlserver://{1};databaseName={2};integratedSecurity=true";
    public static final String CONNECTION_OPTION_SSL = ";encrypt=true;trustServerCertificate=false";
    public static final String DEFAULT_VAULTUS_2000_DRIVER_CLASS = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public static final String DEFAULT_VAULTUS_2000_CONNECTION_URL = "jdbc:microsoft:sqlserver://{1};databaseName={2}";
    public static final String DEFAULT_VAULTUS_2005_DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String DEFAULT_VAULTUS_2005_CONNECTION_URL = "jdbc:sqlserver://{1};databaseName={2};selectMethod=cursor";
    private int databaseType = 0;

    public DBSqlServerDatabase(IConnectionPool connectionPool, String driverClass, String connectionUrl, String hostPort, String databaseName, String username, String password, Properties props, IConfiguration config) throws CMException {
        super(true, connectionPool, driverClass, CMStringHelper.formatString(connectionUrl, new String[]{hostPort, databaseName}), "sqlserver", username, password, hostPort, databaseName, props, config);
    }

    @Override
    public byte[] getBlobBytes(ResultSet rs, int column) throws SQLException {
        return rs.getBytes(column);
    }

    @Override
    public int getDatabaseType() {
        if (this.databaseType == 0) {
            try {
                String databaseProductName = this.getDatabaseProductName();
                if (databaseProductName.indexOf("8.") != -1 || databaseProductName.indexOf("2000") != -1) {
                    VM.log(CLASS, 1, "using SQL Server 2000 semantics");
                    this.databaseType = 1;
                } else if (databaseProductName.indexOf("9.") != -1 || databaseProductName.indexOf("2005") != -1) {
                    VM.log(CLASS, 1, "using SQL Server 2005 semantics");
                    this.databaseType = 7;
                } else if (databaseProductName.indexOf("10.") != -1 || databaseProductName.indexOf("2008") != -1) {
                    VM.log(CLASS, 1, "using SQL Server 2008 semantics");
                    this.databaseType = 9;
                } else if (databaseProductName.indexOf("11.") != -1 || databaseProductName.indexOf("2012") != -1) {
                    VM.log(CLASS, 1, "using SQL Server 2012 semantics");
                    this.databaseType = 11;
                } else if (databaseProductName.indexOf("12.") != -1 || databaseProductName.indexOf("2014") != -1) {
                    VM.log(CLASS, 1, "using SQL Server 2014 semantics");
                    this.databaseType = 12;
                } else {
                    VM.log(CLASS, 2, "unrecognized SQL Server version: " + databaseProductName);
                    VM.log(CLASS, 2, "assuming SQL Server 2014 semantics");
                    this.databaseType = 12;
                }
            }
            catch (Exception ex) {
                VM.log(CLASS, 3, "unable to determine SQL Server version", ex);
            }
        }
        return this.databaseType;
    }

    @Override
    public ISQLDatabaseCalls getDatabaseCalls() {
        if (this.databaseCalls == null) {
            this.databaseCalls = new DBSqlServerDatabaseCalls(this.m_jdbcLevel, this.getDatabaseType());
        }
        return this.databaseCalls;
    }

    @Override
    public String[] getUserTableNames(Connection connection) throws SQLException {
        ISQLDatabaseCalls calls = this.getDatabaseCalls();
        return calls.getUserTableNames(connection);
    }

    private String[] getDropableTables(Connection connection) throws SQLException {
        String sql = "select DISTINCT TABLE_SCHEMA + '.' + TABLE_NAME AS NAME from information_schema.tables WHERE    table_type = 'BASE TABLE' AND   TABLE_NAME NOT IN    (      SELECT TABLE_NAME       from information_schema.tables, sys.foreign_keys       WHERE         referenced_object_id = OBJECT_ID(TABLE_SCHEMA + '.' + TABLE_NAME)\t  )  ORDER BY NAME";
        ISQLDatabaseCalls calls = this.getDatabaseCalls();
        return calls.executeQueryToStringArray(connection, sql);
    }

    private void dropTable(Connection connection, String tableName) throws SQLException {
        String sql = "DROP TABLE " + tableName;
        PreparedStatement stmt = connection.prepareStatement(sql);
        stmt.executeUpdate();
        stmt.close();
    }

    private void dropTables(Connection connection) throws SQLException {
        String[] tables;
        do {
            for (String table : tables = this.getDropableTables(connection)) {
                this.dropTable(connection, table);
            }
        } while (tables.length > 0);
    }

    @Override
    public void clean(Connection connection) throws SQLException {
        this.dropTables(connection);
        DatabaseCleaner cleaner = new DatabaseCleaner(this.getDatabaseCalls());
        cleaner.clean(connection);
    }
}

