/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.IPersistenceStore;
import com.cognos.mobile.database.ITempStorageDAO;
import com.cognos.mobile.database.TempStorageObject;
import com.cognos.mobile.vm.VM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DBTempPersistenceStore
implements IPersistenceStore {
    private static final Class CLASS = DBTempPersistenceStore.class;
    private final ITempStorageDAO tsDAO;

    public DBTempPersistenceStore(ITempStorageDAO tsDAO) {
        this.tsDAO = tsDAO;
    }

    @Override
    public String createTempPath(String prefix, String suffix, String path, boolean overwrite) throws IOException {
        try {
            TempStorageObject tso = this.tsDAO.createTempStorage();
            return tso.getPath();
        }
        catch (CMException cme) {
            throw new IOException("Couldn't create TempPath from prefix: " + prefix + " suffix: " + suffix + " path: " + path);
        }
    }

    @Override
    public OutputStream create(String path, boolean overwrite) throws IOException {
        try {
            TempStorageObject tso = this.getTempObject(path);
            boolean useId = true;
            int id = 0;
            try {
                id = Integer.parseInt(path.trim());
            }
            catch (NumberFormatException e) {
                useId = false;
            }
            if (tso == null) {
                tso = useId ? this.tsDAO.createTempStorage() : this.tsDAO.createTempStorage(path, overwrite);
            }
            return new PersistenceStoreDBOutputStream(tso);
        }
        catch (Exception cme) {
            throw new IOException("Couldn't create TempPath from path: " + path);
        }
    }

    @Override
    public boolean exists(String path) {
        try {
            int id = Integer.parseInt(path.trim());
            return this.tsDAO.tempStoragePathExists(id);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String[] findAllPaths() throws IOException {
        try {
            return this.tsDAO.findAllTempStoragePaths();
        }
        catch (CMException cme) {
            throw new IOException("Cannot list paths " + cme);
        }
    }

    private TempStorageObject getTempObject(String path) throws IOException {
        boolean useId = true;
        int id = 0;
        try {
            id = Integer.parseInt(path.trim());
        }
        catch (NumberFormatException e) {
            useId = false;
        }
        try {
            if (useId) {
                return this.tsDAO.findTempStorageById(id);
            }
            return this.tsDAO.findTempStorageByPath(path);
        }
        catch (Exception e) {
            throw new IOException("Couldn't get Temp Object from path: " + path);
        }
    }

    @Override
    public InputStream get(String path) throws IOException {
        TempStorageObject tso = this.getTempObject(path);
        if (tso != null && tso.getContent() != null) {
            return new ByteArrayInputStream(tso.getContent());
        }
        VM.log(CLASS, 0, "content for path: " + path + " is null");
        return null;
    }

    @Override
    public boolean remove(String path) throws IOException {
        try {
            boolean useId = true;
            int id = 0;
            try {
                id = Integer.parseInt(path.trim());
            }
            catch (NumberFormatException e) {
                useId = false;
            }
            TempStorageObject tso = useId ? this.tsDAO.findTempStorageById(id) : this.tsDAO.findTempStorageByPath(path);
            if (tso != null) {
                this.tsDAO.removeTempStorage(tso);
                return true;
            }
            return false;
        }
        catch (CMException cme) {
            throw new IOException("Couldn't remove Temp Object from path: " + path);
        }
    }

    @Override
    public OutputStream createFileTempWriter(StringBuffer path, String tempSuffix) throws IOException {
        path.append(this.createTempPath("mob", tempSuffix, "", true));
        return this.create(path.toString(), true);
    }

    class PersistenceStoreDBOutputStream
    extends OutputStream {
        private TempStorageObject tso;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        PersistenceStoreDBOutputStream(TempStorageObject tso) {
            this.tso = tso;
        }

        @Override
        public void close() throws IOException {
            this.baos.close();
            this.tso.setContent(this.baos.toByteArray());
            try {
                DBTempPersistenceStore.this.tsDAO.updateTempStorage(this.tso);
            }
            catch (CMException cme) {
                throw new IOException("Couldn't update content: " + cme);
            }
        }

        @Override
        public void flush() throws IOException {
            super.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.baos.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.baos.write(b);
        }
    }
}

