/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.IMobileDatabase;
import com.cognos.mobile.vm.VM;

public class DeviceCleanupTask
implements Runnable {
    protected static Class<DeviceCleanupTask> CLASS = DeviceCleanupTask.class;
    private IMobileDatabase database;
    private long expiryAgeInDays;

    public DeviceCleanupTask(IMobileDatabase database, long expiryAgeInDays) {
        this.database = database;
        this.expiryAgeInDays = expiryAgeInDays;
    }

    @Override
    public void run() {
        try {
            this.database.deleteExpiredDevices(this.expiryAgeInDays);
            VM.log(CLASS, 1, "Deleted expired devices from the database (older than " + this.expiryAgeInDays + " days)");
        }
        catch (CMException e) {
            VM.log(CLASS, 3, "Failed to delete expired devices from the database", e);
        }
    }
}

