/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.IDeviceDAO;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.SQLDeviceDAO;
import com.cognos.mobile.model.data.Device;
import java.util.Date;
import java.util.List;

public class DeviceManager {
    private final IDeviceDAO deviceDAO;

    public DeviceManager(ISQLDatabase database) {
        this.deviceDAO = new SQLDeviceDAO(database);
    }

    public void setKey(String deviceID, int userID, String keyType, byte[] key) throws CMException {
        this.deviceDAO.setKey(deviceID, userID, keyType, key);
    }

    public Device addDevice(String deviceID, int userID, String pushID, String syncMethod) throws CMException {
        return this.deviceDAO.addDevice(deviceID, userID, pushID, syncMethod);
    }

    public void setSyncMethod(String deviceID, int userID, String syncMethod) throws CMException {
        this.deviceDAO.setSyncMethod(deviceID, userID, syncMethod);
    }

    public void setLastSynced(String deviceID, int userID, Date updateTime) throws CMException {
        this.deviceDAO.setLastSynced(deviceID, userID, updateTime);
    }

    public Date getLastSynced(String deviceID, int userID) throws CMException {
        return this.deviceDAO.getLastSynced(deviceID, userID);
    }

    public List<Device> getDevicesByCamID(String camID) throws CMException {
        return this.deviceDAO.getDevicesByCamID(camID);
    }

    public Device getDevice(String deviceID, int userID) throws CMException {
        return this.deviceDAO.getDevice(deviceID, userID);
    }

    public void removeDeviceRegisteredBefore(String pushID, Date date) throws CMException {
        this.deviceDAO.removeDeviceRegisteredBefore(pushID, date);
    }

    public void setPushID(String deviceID, int userID, String pushID) throws CMException {
        this.deviceDAO.setPushID(deviceID, userID, pushID);
    }

    public void deleteExpiredDevices(long expiryAgeInDays) throws CMException {
        this.deviceDAO.deleteExpiredDevices(expiryAgeInDays);
    }

    public void updateDevice(String deviceID, int userID, String syncMethod, String pushID) throws CMException {
        this.deviceDAO.updateDevice(deviceID, userID, syncMethod, pushID);
    }

    public void resetPushIdsForDevice(String deviceID) throws CMException {
        this.deviceDAO.resetPushIdsForDevice(deviceID);
    }
}

