/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.database;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.database.HistoryObject;
import com.cognos.mobile.database.IHistoryDAO;
import com.cognos.mobile.database.IRenderHistoryDAO;
import com.cognos.mobile.database.ISQLDatabase;
import com.cognos.mobile.database.IUserHistoryDAO;
import com.cognos.mobile.database.SQLHistoryDAO;
import com.cognos.mobile.database.SQLRenderHistoryDAO;
import com.cognos.mobile.database.SQLUserHistoryDAO;
import java.util.Date;

public class HistoryManager {
    private final IHistoryDAO historyDAO;
    private final IUserHistoryDAO userHistoryDAO;
    private final IRenderHistoryDAO renderHistoryDAO;

    public HistoryManager(ISQLDatabase database) {
        this.historyDAO = new SQLHistoryDAO(database);
        this.userHistoryDAO = new SQLUserHistoryDAO(database);
        this.renderHistoryDAO = new SQLRenderHistoryDAO(database);
    }

    public HistoryObject createHistory(int[] userID, int eventID, Date timeStamp, String details, int[] renderID) throws CMException {
        HistoryObject history = this.historyDAO.createHistory(userID, eventID, timeStamp, details, renderID);
        this.userHistoryDAO.insertHistoryUsers(userID, history.getHistoryID());
        this.renderHistoryDAO.insertHistoryRenders(renderID, history.getHistoryID());
        return history;
    }

    public HistoryObject[] getMostRecentViewedByUser(int userID, int number) throws CMException {
        return this.historyDAO.getMostRecentViewedByUser(userID, number);
    }

    public HistoryObject[] queryHistoryByUser(int userID, int[] eventID, int start, int end) throws CMException {
        return this.historyDAO.queryHistoryByUser(userID, eventID, start, end);
    }

    public void removeHistoryBefore(Date modified) throws CMException {
        this.historyDAO.removeHistoryBefore(modified);
    }
}

